
;-> > Images

;Inverse les conventions RGB et BGR
Macro ReverseRGB(COLOR)
  (COLOR & $FF0000) >> 16 + (COLOR & $00FF00) + (COLOR & $0000FF) << 16
EndMacro

;Le point est-il en bordure de la carte ?
Macro BorderMap(BMP,X,Y)
  X=0 Or X=BMP\bmWidth-1 Or Y=0 Or Y=BMP\bmHeight-1
EndMacro

;Le point est-il en-dehors de la carte ?
Macro OffMap(BMP,X,Y)
  X<0 Or X>BMP\bmWidth-1 Or Y<0 Or Y>BMP\bmHeight-1
EndMacro

;Le point est-il dans la carte ?
Macro InMap(BMP,X,Y)
  Not (OffMap(BMP,X,Y))
EndMacro

;Adresse mmoire du point sur cette carte
Macro Mem(BMP,X,Y)
  BMP\bmBits+X*4+Y*BMP\bmWidthBytes
EndMacro

;-> > Strings

;Traduit une chane de caractres en valeur
Macro StringToVal(STRING,VALUE)
  If STRING="no"
    VALUE=#False
  ElseIf STRING="yes"
    VALUE=#True
  ElseIf STRING="teutonic"
    VALUE=2
  EndIf
EndMacro

;Traduit une valeur en chane de caractres
Macro ValToString(VALUE,STRING)
  If VALUE=#False
    STRING="no"
  ElseIf VALUE=#True
    STRING="yes"
  ElseIf VALUE=2
    STRING="teutonic"
  EndIf
EndMacro

;Traduit une chane de caractres en niveau de communaut
Macro StringToLevel(STRING,LEVEL)
  Select STRING
    Case "village" : LEVEL=0
    Case "town" : LEVEL=1 
    Case "large_town" : LEVEL=2
    Case "city" : LEVEL=3
    Case "large_city" : LEVEL=4
    Case "huge_city" : LEVEL=5
    Default : FatalError("Niveau de communaut "+STRING+" inconnu.")
  EndSelect
EndMacro

;Traduit le niveau de communaut en chane de caractres
Macro LevelToString(LEVEL,STRING)
  Select LEVEL
    Case 0 : STRING="village"
    Case 1 : STRING="town"
    Case 2 : STRING="large_town"
    Case 3 : STRING="city"
    Case 4 : STRING="large_city"
    Case 5 : STRING="huge_city"
    Default : FatalError("Valeur de niveau de communaut incorrect : "+Str(LEVEL)+" !")
  EndSelect
EndMacro

;Identification du type de personnage
Macro StringToChar(STRING,VALUE)
  Select STRING
    Case "named character" : VALUE=#Named
    Case "general" : VALUE=#General
    Case "admiral" : VALUE=#Admiral
    Case "diplomat" : VALUE=#Diplomat
    Case "princess" : VALUE=#Princess
    Case "spy" : VALUE=#Spy
    Case "assassin" : VALUE=#Assassin
    Case "merchant" : VALUE=#Merchant
    Case "priest" : VALUE=#Priest
    Case "witch" : VALUE=#Witch
    Case "heretic" : VALUE=#Heretic
    Case "inquisitor" : VALUE=#Inquisitor
  EndSelect
EndMacro

;Rcriture du type de personnage
Macro CharToString(VALUE,STRING)
  Select VALUE
    Case #Named : STRING="named character"
    Case #General : STRING="general"
    Case #Admiral : STRING="admiral"
    Case #Diplomat : STRING="diplomat"
    Case #Princess : STRING="princess"
    Case #Spy : STRING="spy"
    Case #Assassin : STRING="assassin"
    Case #Merchant : STRING="merchant"
    Case #Priest : STRING="priest"
    Case #Witch : STRING="witch"
    Case #Heretic : STRING="heretic"
    Case #Inquisitor : STRING="inquisitor"
  EndSelect
EndMacro

;Suppression de la premire partie d'une chane (il ne reste que l'argument)
Macro Argument(STRING,LENGTH)
  STRING=Trim(Mid(STRING,LENGTH+1,Len(STRING)-LENGTH))
EndMacro

;Nettoyage complet d'une chane de caractres
Macro ClearString(STRING)
  ;Remplacement des tabulations par des espaces
  ReplaceString(STRING,Chr(9)," ",2)
  ;Suppression des commentaires
  If FindString(STRING,";",1) : STRING=Left(STRING,FindString(STRING,";",1)-1) : EndIf
  ;Suppression des espaces devant et derrire
  STRING=Trim(STRING)
EndMacro

;Cration de la chane de caractre Tab$ compose de X caractres de tabulation
Macro Tab(X)
  Tab$=Space(X) : ReplaceString(Tab$," ",Chr(9),2)
EndMacro

;-> > Others

;Convertit un fichier textuel binaire en une liste chane structure avec les champs In$ et Out$
Macro ReadStringsBin(FILE,NAMES,TYPE,LENGTH,NUMBER,ADDRESS)
  ;FILE est la constante qui identifie le fichier  lire
  ;NAMES doit tre une liste chane avec une Structure comprenant les champs In$ et Out$ (comme name)
  ;TYPE, LENGTH et NUMBER doivent tre des words .w
  ;ADDRESS est un pointeur mmoire de type *Address
  
  ;Initialisation
  TYPE=-4
  ;Boucle de lecture du bin
  While Not Eof(FILE)
    ;Longueur  lire
    LENGTH=ReadWord(FILE)
    ;Nombre d'entits  lire
    If TYPE=-2 : NUMBER=LENGTH*2 : EndIf
    ;Si la longueur n'est pas nulle
    If LENGTH
      ;Si on a dpass l'entte
      If TYPE>-1
        ;Slection du cas : In=0 et Out=1
        Select TYPE%2
          Case 0
            ;Ajoute un lment
            AddElement(NAMES)
            ;Allocation de mmoire pour la chane de caractre
            ADDRESS=AllocateMemory(LENGTH*2+1) ;+1 octet, important  la fin de toute chane de caractre
            ;Lecture effective de la chane
            ReadData(FILE,ADDRESS,LENGTH*2)
            ;On met un zro pour signaler la fin de la chane de caractre
            PokeW(ADDRESS+LENGTH*2,0)
            ;Stockage de la chane de caractre ainsi cre
            NAMES\In$=PeekS(ADDRESS,LENGTH*2+1,#PB_Unicode) ;Format unicode, trs important
            ;Libration de la mmoire temporaire, important
            FreeMemory(ADDRESS)
          Case 1
            ;Mme procdure que ci-dessus
            ADDRESS=AllocateMemory(LENGTH*2+1)
            ReadData(FILE,Address,LENGTH*2)
            PokeW(ADDRESS+LENGTH*2,0)
            NAMES\Out$=PeekS(ADDRESS,LENGTH*2+1,#PB_Unicode)
            FreeMemory(ADDRESS)
        EndSelect
      EndIf
    EndIf
    ;Incrmentation automatique
    TYPE+1
    ;Si toutes les entits ont t lues, on quitte la boucle avant la fin du fichier
    If TYPE=NUMBER : Break : EndIf
  Wend
EndMacro

;Mise  jour du pourcentage de progression dans la barre de progression
Macro SetProgress(PERCENT)
  SetGadgetState(#Progress,PERCENT)
  SetGadgetText(#ProgressText,Str(PERCENT)+" %")
  UpdateWindow_(WindowID(#Win))
  If PERCENT=100
    CloseWindow(#WinProgress)
    DisableWindow(#Win,0)
  EndIf
EndMacro

; IDE Options = PureBasic 4.10 (Windows - x86)
; CursorPosition = 133
; FirstLine = 19
; Folding = AAw