
Procedure MapGen()
  Protected X.w,Y.w,Color.l,Item,Max.l,Number.b
  
  Number=CountList(Religions())+4
  
  ;********************************************************************************************************
  ;-Window
  ;********************************************************************************************************
  
  ;Dsactivation de la fentre principale
  DisableWindow(#Win,1)
  
  ;Cration de la fentre de l' propos
  If OpenWindow(#WinProgress,0,0,240,145,"Gnration des cartes",#PB_Window_WindowCentered,WindowID(#Win))
    If CreateGadgetList(WindowID(#WinProgress))
      ProgressBarGadget(#Progress,10,10,220,30,0,100)
      ProgressBarGadget(#ProgressTotal,10,80,220,30,0,100)
      TextGadget(#ProgressText,10,50,220,14,"0 %",#PB_Text_Center)
      TextGadget(#ProgressTotalText,10,120,220,14,"Total : 0 %",#PB_Text_Center)
    Else
      FatalError("Impossible de crer les lments de la fentre de progression.")
    EndIf
  Else
    FatalError("Impossible d'afficher la fentre de progression.")
  EndIf
  
  DisplayScreen()
  
  ;Cration des dossiers
  DeleteDirectory(Gen$+"maps","*.*",#PB_FileSystem_Force)
  CreateDirectory(Gen$+"maps")
  CreateDirectory(Gen$+"maps\religions")
  
  ;********************************************************************************************************
  ;-Religions
  ;********************************************************************************************************
  
  ForEach Religions()
    
    ;Cration de la carte de base
    CreateImage(#OriGeneric,OriRegion\bmWidth+65,OriRegion\bmHeight,32)
    GetObject_(ImageID(#OriGeneric),SizeOf(BITMAP),@OriGeneric)
    If StartDrawing(ImageOutput(#OriGeneric))
      Box(0,0,OriGeneric\bmWidth,OriGeneric\bmHeight,#White)
      DrawImage(ImageID(#OriRegion),0,0)
    StopDrawing() : EndIf
    
    ;Modification de la couleur des rgions
    For Y=0 To OriRegion\bmHeight-1
      For X=0 To OriRegion\bmWidth-1
        Color=PeekL(OriGeneric\bmBits+X*4+Y*OriGeneric\bmWidthBytes)
        Color=ReverseRGB(Color)
        ForEach Regions()
          If Regions()\Color=Color
            Item=Regions()\Religions[ListIndex(Religions())]
            Color=RGB(255*(100-Item)/100,255*(100-Item)/100,255)
            PokeL(OriGeneric\bmBits+X*4+Y*OriGeneric\bmWidthBytes,Color)
            Break
          EndIf
        Next
      Next X
      SetGadgetState(#Progress,Y*100/(OriRegion\bmHeight-1))
      SetGadgetText(#ProgressText,"Fichier "+Religions()\In$+".bmp : "+Str(Y*100/(OriRegion\bmHeight-1))+" %")
    Next Y
    
    ;Cration de la lgende sur le ct droit
    If StartDrawing(ImageOutput(#OriGeneric))
      For Y=9 To OriRegion\bmHeight-10
        Item=100-(100*(Y-9)/(OriRegion\bmHeight-20))
        Color=RGB(255*(100-Item)/100,255*(100-Item)/100,255)
        Color=ReverseRGB(Color)
        LineXY(OriRegion\bmWidth+10,Y,OriRegion\bmWidth+28,Y,Color)
      Next Y
      DrawingMode(#PB_2DDrawing_Transparent)
      DrawingFont(FontID(#DrawFont))
      DrawText(OriRegion\bmWidth+35,10,"100 %")
      DrawText(OriRegion\bmWidth+35,5+(OriRegion\bmHeight-20)/2,"50 %")
      DrawText(OriRegion\bmWidth+35,OriRegion\bmHeight-20,"0 %")
    StopDrawing() : EndIf
    
    ;Sauvegarde de la carte ainsi gnre
    SaveImage(#OriGeneric,Gen$+"maps\religions\"+Religions()\In$+".bmp")
    
    SetGadgetState(#ProgressTotal,(ListIndex(Religions())+1)*100/Number)
    SetGadgetText(#ProgressTotalText,"Total : "+Str((ListIndex(Religions())+1)*100/Number)+" %")
    
  Next
  
  ;********************************************************************************************************
  ;-Factions
  ;********************************************************************************************************
  
  ;Cration de la carte de base
  CreateImage(#OriGeneric,OriRegion\bmWidth+65,OriRegion\bmHeight,32)
  GetObject_(ImageID(#OriGeneric),SizeOf(BITMAP),@OriGeneric)
  If StartDrawing(ImageOutput(#OriGeneric))
    Box(0,0,OriGeneric\bmWidth,OriGeneric\bmHeight,#White)
    DrawImage(ImageID(#OriRegion),0,0)
  StopDrawing() : EndIf
  
  ;Modification de la couleur des rgions
  For Y=0 To OriRegion\bmHeight-1
    For X=0 To OriRegion\bmWidth-1
      Color=PeekL(OriRegion\bmBits+X*4+Y*OriRegion\bmWidthBytes)
      Color=ReverseRGB(Color)
      ForEach Regions()
        If Regions()\Color=Color
          ;Slection de la faction possdant cette rgion
          ForEach Factions() : If Factions()\Name\In$=Regions()\Faction$ : Break : EndIf : Next
          ;Couleur de la faction
          If BorderMap(OriRegion,X,Y)
            Color=ReverseRGB(Factions()\Color2)
          Else
            Color=ReverseRGB(Color)
            If Color=PeekL(OriRegion\bmBits+(X-1)*4+Y*OriRegion\bmWidthBytes) And Color=PeekL(OriRegion\bmBits+(X+1)*4+Y*OriRegion\bmWidthBytes) And Color=PeekL(OriRegion\bmBits+X*4+(Y+1)*OriRegion\bmWidthBytes) And Color=PeekL(OriRegion\bmBits+X*4+(Y-1)*OriRegion\bmWidthBytes)
              Color=ReverseRGB(Factions()\Color1)
            Else
              Color=ReverseRGB(Factions()\Color2)
            EndIf
          EndIf
          PokeL(OriGeneric\bmBits+X*4+Y*OriGeneric\bmWidthBytes,Color)
          Break
        EndIf
      Next
    Next X
    SetGadgetState(#Progress,Y*100/(OriRegion\bmHeight-1))
    SetGadgetText(#ProgressText,"Fichier factions.bmp : "+Str(Y*100/(OriRegion\bmHeight-1))+" %")
  Next Y
  
  ;Sauvegarde de la carte ainsi gnre
  SaveImage(#OriGeneric,Gen$+"maps\factions.bmp")
  
  SetGadgetState(#ProgressTotal,(Number-3)*100/Number)
  SetGadgetText(#ProgressTotalText,"Total : "+Str((Number-3)*100/Number)+" %")
  
  ;********************************************************************************************************
  ;-Creators
  ;********************************************************************************************************
  
  ;Cration de la carte de base
  CreateImage(#OriGeneric,OriRegion\bmWidth+65,OriRegion\bmHeight,32)
  GetObject_(ImageID(#OriGeneric),SizeOf(BITMAP),@OriGeneric)
  If StartDrawing(ImageOutput(#OriGeneric))
    Box(0,0,OriGeneric\bmWidth,OriGeneric\bmHeight,#White)
    DrawImage(ImageID(#OriRegion),0,0)
  StopDrawing() : EndIf
  
  ;Modification de la couleur des rgions
  For Y=0 To OriRegion\bmHeight-1
    For X=0 To OriRegion\bmWidth-1
      Color=PeekL(OriRegion\bmBits+X*4+Y*OriRegion\bmWidthBytes)
      Color=ReverseRGB(Color)
      ForEach Regions()
        If Regions()\Color=Color
          ;Slection de la faction possdant cette rgion
          ForEach Factions() : If Factions()\Name\In$=Regions()\OriFaction$ : Break : EndIf : Next
          ;Couleur de la faction
          If BorderMap(OriRegion,X,Y)
            Color=ReverseRGB(Factions()\Color2)
          Else
            Color=ReverseRGB(Color)
            If Color=PeekL(OriRegion\bmBits+(X-1)*4+Y*OriRegion\bmWidthBytes) And Color=PeekL(OriRegion\bmBits+(X+1)*4+Y*OriRegion\bmWidthBytes) And Color=PeekL(OriRegion\bmBits+X*4+(Y+1)*OriRegion\bmWidthBytes) And Color=PeekL(OriRegion\bmBits+X*4+(Y-1)*OriRegion\bmWidthBytes)
              Color=ReverseRGB(Factions()\Color1)
            Else
              Color=ReverseRGB(Factions()\Color2)
            EndIf
          EndIf
          PokeL(OriGeneric\bmBits+X*4+Y*OriGeneric\bmWidthBytes,Color)
          Break
        EndIf
      Next
    Next X
    SetGadgetState(#Progress,Y*100/(OriRegion\bmHeight-1))
    SetGadgetText(#ProgressText,"Fichier creators.bmp : "+Str(Y*100/(OriRegion\bmHeight-1))+" %")
  Next Y
  
  ;Sauvegarde de la carte ainsi gnre
  SaveImage(#OriGeneric,Gen$+"maps\creators.bmp")
  
  SetGadgetState(#ProgressTotal,(Number-2)*100/Number)
  SetGadgetText(#ProgressTotalText,"Total : "+Str((Number-2)*100/Number)+" %")
  
  ;********************************************************************************************************
  ;-Agriculture
  ;********************************************************************************************************
  
  ;Cration de la carte de base
  CreateImage(#OriGeneric,OriRegion\bmWidth+40,OriRegion\bmHeight,32)
  GetObject_(ImageID(#OriGeneric),SizeOf(BITMAP),@OriGeneric)
  If StartDrawing(ImageOutput(#OriGeneric))
    Box(0,0,OriGeneric\bmWidth,OriGeneric\bmHeight,#White)
    DrawImage(ImageID(#OriRegion),0,0)
  StopDrawing() : EndIf
  
  ;Recherche du niveau maximum d'agriculture
  ForEach Regions()
    If Regions()\Agriculture>Max
      Max=Regions()\Agriculture
    EndIf
  Next
  
  ;Modification de la couleur des rgions
  For Y=0 To OriRegion\bmHeight-1
    For X=0 To OriRegion\bmWidth-1
      Color=PeekL(OriGeneric\bmBits+X*4+Y*OriGeneric\bmWidthBytes)
      Color=ReverseRGB(Color)
      ForEach Regions()
        If Regions()\Color=Color
          Item=100*Regions()\Agriculture/Max
          Color=RGB(128*(100-Item)/100,255*(100-Item/2)/100,255*(100-Item)/100)
          PokeL(OriGeneric\bmBits+X*4+Y*OriGeneric\bmWidthBytes,Color)
          Break
        EndIf
      Next
    Next X
    SetGadgetState(#Progress,Y*100/(OriRegion\bmHeight-1))
    SetGadgetText(#ProgressText,"Fichier agriculture.bmp : "+Str(Y*100/(OriRegion\bmHeight-1))+" %")
  Next Y
  
  ;Cration de la lgende sur le ct droit
  If StartDrawing(ImageOutput(#OriGeneric))
    For Y=0 To Max
      Item=100*(Max-Y)/Max
      Color=RGB(128*(100-Item)/100,255*(100-Item/2)/100,255*(100-Item)/100)
      Color=ReverseRGB(Color)
      Box(OriRegion\bmWidth+8,8+Y*12,12,8,Color)
      DrawingMode(#PB_2DDrawing_Transparent)
      DrawingFont(FontID(#DrawFont))
      DrawText(OriRegion\bmWidth+24,7+Y*12,Str(Max-Y))
    Next
  StopDrawing() : EndIf
  Max=0
  
  ;Sauvegarde de la carte ainsi gnre
  SaveImage(#OriGeneric,Gen$+"maps\agriculture.bmp")
  
  SetGadgetState(#ProgressTotal,(Number-1)*100/Number)
  SetGadgetText(#ProgressTotalText,"Total : "+Str((Number-1)*100/Number)+" %")
  
  ;********************************************************************************************************
  ;-Population
  ;********************************************************************************************************
  
  ;Cration de la carte de base
  CreateImage(#OriGeneric,OriRegion\bmWidth+65,OriRegion\bmHeight,32)
  GetObject_(ImageID(#OriGeneric),SizeOf(BITMAP),@OriGeneric)
  If StartDrawing(ImageOutput(#OriGeneric))
    Box(0,0,OriGeneric\bmWidth,OriGeneric\bmHeight,#White)
    DrawImage(ImageID(#OriRegion),0,0)
  StopDrawing() : EndIf
  
  ;Recherche du nombre maximal d'habitants
  ForEach Regions()
    If Regions()\City\Population>Max
      Max=Regions()\City\Population
    EndIf
  Next
  
  ;Modification de la couleur des rgions
  For Y=0 To OriRegion\bmHeight-1
    For X=0 To OriRegion\bmWidth-1
      Color=PeekL(OriGeneric\bmBits+X*4+Y*OriGeneric\bmWidthBytes)
      Color=ReverseRGB(Color)
      ForEach Regions()
        If Regions()\Color=Color
          ;Item=100*Regions()\City\Population/Max
          Item=100*Log10(1+9*Regions()\City\Population/Max)
          Color=RGB(128*(100-Item)/100,255*(100-Item)/100,255*(100-Item/2)/100)
          PokeL(OriGeneric\bmBits+X*4+Y*OriGeneric\bmWidthBytes,Color)
          Break
        EndIf
      Next
    Next X
    SetGadgetState(#Progress,Y*100/(OriRegion\bmHeight-1))
    SetGadgetText(#ProgressText,"Fichier population.bmp : "+Str(Y*100/(OriRegion\bmHeight-1))+" %")
  Next Y
  
  ;Cration de la lgende sur le ct droit
  If StartDrawing(ImageOutput(#OriGeneric))
    For Y=9 To OriRegion\bmHeight-10
      ;Item=100-(100*Log10(1+9*(Y-9)/(OriRegion\bmHeight-20)))
      ;Item=100-(100*Pow(10,(Y-9)/(OriRegion\bmHeight-20)-1))
      Item=100-(100*(Y-9)/(OriRegion\bmHeight-20))
      Color=RGB(128*(100-Item)/100,255*(100-Item)/100,255*(100-Item/2)/100)
      Color=ReverseRGB(Color)
      LineXY(OriRegion\bmWidth+10,Y,OriRegion\bmWidth+28,Y,Color)
    Next Y
    DrawingMode(#PB_2DDrawing_Transparent)
    DrawingFont(FontID(#DrawFont))
    ;DrawText(OriRegion\bmWidth+35,10,"100 %")
    ;DrawText(OriRegion\bmWidth+35,5+(OriRegion\bmHeight-20)/2,"50 %")
    ;DrawText(OriRegion\bmWidth+35,OriRegion\bmHeight-20,"0 %")
  StopDrawing() : EndIf
  
  ;Sauvegarde de la carte ainsi gnre
  SaveImage(#OriGeneric,Gen$+"maps\population.bmp")
  
  ;Finalisation de la procdure
  SetGadgetState(#ProgressTotal,100)
  SetGadgetText(#ProgressTotalText,"Total : 100 %")
  DisableWindow(#Win,0)
  CloseWindow(#WinProgress)
  RunProgram(Gen$+"maps")
  
EndProcedure

; IDE Options = PureBasic 4.10 (Windows - x86)
; CursorPosition = 133
; FirstLine = 73
; Folding = -