
Procedure.l SubColor(X.l,Y.l)
  Protected i.b,j.b,k.b,Color.l,Type.b,Number.b
  Protected Dim Count.color(8)
  
  ;Test des 9 pixels autour du point concern
  For i=-1 To 1
    For j=-1 To 1
      ;Initialisation
      Type=0
      ;Rcupration de la couleur du point
      If InMap(OriRegion,X+i,Y+j)
        Color=PeekL(OriRegion\bmBits+(X+i)*4+(Y+j)*OriRegion\bmWidthBytes)
      Else
        Color=-1
      EndIf
      ;On vrifie que ce n'est pas une couleur interdite (noir, blanc, mer, -1)
      For k=0 To 6 : If ReverseRGB(Color)=NonColor(k) : Type=1 : Break : EndIf : Next k
      ;Si elle est interdite, on passe  l'itration suivante
      If Type : Continue : EndIf
      ;Ici on sait que la couleur est valide, on cherche  savoir si elle est nouvelle ou non
      For k=0 To 7 : If Color=Count(k)\Color : Count(k)\Number+1 : Type=1 : Break : EndIf : Next k
      ;Si elle n'est pas nouvelle on ajoute un lment  la liste
      If Not Type : Count(Number)\Color=Color : Count(Number)\Number=1 : Number+1 : EndIf
    Next j
  Next i
  
  ;On trie la liste selon le nombre d'entits trouves
  SortStructuredArray(Count(),1,OffsetOf(color\Number),#PB_Sort_Byte)
  ;Le premier lment est l'lment recherch
  ProcedureReturn Count(0)\Color
    
EndProcedure

Procedure.l ChangeColor(Color.l)
  Protected i.b,Alea.b,Quit.b,Ignore.b,X.l,Y.l,*Pixel.Long
  
  ;Faut-il gnrer une couleur alatoire ?
  If Color=0 : Alea=1 : EndIf
  
  If Not Alea And SelectedRegion=-1
    Error("Aucune rgion n'est actuellement slectionne !")
    ProcedureReturn #False
  EndIf
  
  ;On supprime une rgion et on la colore avec la couleur d'une autre rgion
  If Color<0 : Color=-Color : Ignore=1 : EndIf
  
  ;Cration et vrification de la couleur
  Repeat
    ;Cration d'une couleur alatoire
    If Alea : Color=RGB(Random(255),Random(255),Random(255)) : EndIf
    ;Est-ce une couleur interdite ?
    For i=0 To 6
      If Color=NonColor(i)
        Quit=-1
        Break
      EndIf
    Next i
    ;Est-ce la couleur d'une rgion dj existante ?
    If Not Ignore
      If Quit=0
        ForEach Regions()
          If Color=Regions()\Color
            Quit=-2
            Break
          EndIf
        Next
      EndIf
    EndIf
    ;On recommence ou non ?
    If Quit<0
      ;Si on voulait juste une couleur alatoire on recommence, sinon on quitte (la couleur demande n'est pas bonne)
      If Alea : Quit=0 : Else : ProcedureReturn Quit : EndIf
    Else
      ;Si on a trouv la couleur qui nous intresse, on s'en va (couleur alatoire trouve)
      ;Sinon on continue la procdure pour l'appliquer
      If Alea : ProcedureReturn Color : Else : Break : EndIf
    EndIf
  ForEver
  
  ;Application de la couleur
  For Y=0 To OriRegion\bmHeight-1
    For X=0 To OriRegion\bmWidth-1
      
      ;Si le pixel est de la couleur de la rgion slectionne
      ;On change avec la nouvelle couleur
      *Pixel=OriRegion\bmBits+X*4+Y*OriRegion\bmWidthBytes
      If *Pixel\l=ReverseRGB(SelectedRegion)
        *Pixel\l=ReverseRGB(Color)
      EndIf
    Next X
  Next Y
  
  ;On change la couleur de la rgion slectionne
  If Not Ignore
    ForEach Regions()
      If SelectedRegion=Regions()\Color
        Regions()\Color=Color
        SelectedRegion=Color
        Break
      EndIf
    Next
  EndIf
  
  ;Dtection des erreurs
  If SelectedRegion<>Color And Not Ignore
    FatalError("La couleur de la rgion slectionne n'a pas pu tre modifie, une erreur fatale s'est produite !")
  EndIf
  
  ;Mise  jour des sprites
  ResizeWorld()
  
  ;Retour avec succs
  ProcedureReturn #True
  
EndProcedure

Procedure LoadGrid()
  Protected Iteration.l,i.l
  
  ;Cration des sprites des grilles
  CreateSprite(#VertexGrid,#Screen,#Screen)
  CreateSprite(#PositionGrid,#Screen,#Screen)
  
  ;Grille des vertex
  If StartDrawing(SpriteOutput(#VertexGrid))
    
    ;Nombre de lignes  tracer
    Iteration=#Screen/Scale-1
    
    ;Lignes verticales
    For i=0 To Iteration
      LineXY(i*Scale,0,i*Scale,#Screen,#Gray)
    Next i
    ;Lignes horizontales
    For i=0 To Iteration
      LineXY(0,i*Scale,#Screen,i*Scale,#Gray)
    Next i
    
  StopDrawing() : EndIf
  
  ;Grille de positionnement
  If StartDrawing(SpriteOutput(#PositionGrid))
    
    Iteration=Iteration/2
    
    For i=0 To Iteration
      LineXY(i*Scale*2+Scale/2,0,i*Scale*2+Scale/2,#Screen,#One)
    Next i
    For i=0 To Iteration
      LineXY(0,i*Scale*2+Scale/2,#Screen,i*Scale*2+Scale/2,#One)
    Next i
    
  StopDrawing() : EndIf
  
  ProcedureReturn #True
  
EndProcedure

Procedure SaveTGA(Image.l,File$,Starting.b,Ending.b)
  Protected *Memory,*Address,X.l,Y.l,Length
  Protected Width.l,Height.l,Bmp.BITMAP,*Image,*Pixel.Long
  
  ;Amplitude de la progression
  Length=Ending-Starting
  
  ;Dimensions de l'image
  Height=ImageHeight(Image)
  Width=ImageWidth(Image)
  
  ;Allocation mmoire pour enregistrer le TGA
  *Memory=AllocateMemory(ImageWidth(Image)*ImageHeight(Image)*3)
  *Address=*Memory
  
  ;Adresse de l'image
  GetObject_(ImageID(Image),SizeOf(BITMAP),@Bmp) : *Image=Bmp\bmBits
  
  For X=0 To Height-1
    For Y=0 To Width-1
      ;Adresse du pixel
      *Pixel=*Image+Y*4+X*4*Width
      ;Ecriture des octets de couleur
      PokeB(*Memory,Red(*Pixel\l))
      *Memory+1
      PokeB(*Memory,Green(*Pixel\l))
      *Memory+1
      PokeB(*Memory,Blue(*Pixel\l))
      *Memory+1
    Next Y
    If Length : SetProgress(Starting+Length*X/(Height-1)) : EndIf
  Next X
  
  ;Cration du fichier
  CreateFile(0,File$)
  
  ;Entte du fichier
  WriteByte(0,0)
  WriteByte(0,0)
  WriteByte(0,2)
  
  WriteWord(0,0)
  WriteWord(0,0)
  WriteByte(0,0)
  
  WriteWord(0,0)
  WriteWord(0,0)
  
  WriteWord(0,Width)
  WriteWord(0,Height)
  
  WriteByte(0,24)
  WriteByte(0,0)
  
  ;Ecriture des donnes
  WriteData(0,*Address,Width*Height*3)
  
  ;Libration de la mmoire
  FreeMemory(*Address)
  CloseFile(0)
    
EndProcedure

Procedure ResizeWorld()
  Protected Map.b,Width.l,Height.l,UWidth.l,VHeight.l,U.l,V.l,X.l,Y.l
  Protected i.b,AntiColor.l,Line.l,*Address1,*Address2,*Img1.Long,*Img2.Long
  
  AntiColor=ReverseRGB(SelectedRegion)
  
  ;Pour crer une image plus grande que l'cran (on la dcale par la suite)
  X=Cam\X-2*Scale : Y=Cam\Y-2*Scale
  
  ;Initialisation, taille thorique
  Width=#Screen/Scale+4
  Height=#Screen/Scale+4
  
  ;Si la coordonne est en-dehors du champ  gauche
  If X<0 : Width+X : X=0 : EndIf
  
  ;Si la coordonne est en-dehors du champ en haut
  If Y<0 : Height+Y : Y=0 : EndIf
  
  For Map=#OriClimate To #OriArmy
    
    ;Dcoupage de l'image originale
    If Map>=#Region
      
      ;Si la coordonne est en-dehors du champ  droite
      If X+Width*Scale>ImageWidth(Map)*Scale*2
        Width=2*ImageWidth(Map)-X/Scale
      EndIf
      
      ;Si la coordonne est en-dehors du champ en bas
      If Y+Height*Scale>ImageHeight(Map)*Scale*2
        Height=2*ImageHeight(Map)-Y/Scale
      EndIf
      
      ;Protection anti-bug, si la totalit de la carte est en dehors du champ, on affichera rien!
      If Height>0 And Width>0
        ;Crer une image en prlevant un rectangle sur l'image originale
        GrabImage(Map,#Generic,X/2,Y/2,Width/2,Height/2)
      EndIf
      
    Else
      If X*Scale+Width*Scale>ImageWidth(Map)*Scale : Width=ImageWidth(Map)-X : EndIf
      If Y*Scale+Height*Scale>ImageHeight(Map)*Scale : Height=ImageHeight(Map)-Y : EndIf
      If Height>0 And Width>0 : GrabImage(Map,#Generic,X,Y,Width,Height) : EndIf
    EndIf
    
    ;Libration du prcdent sprite
    If IsSprite(Map) : FreeSprite(Map) : EndIf
    
    ;Si l'image a t cre
    If IsImage(#Generic)
      
      ;Agrandissement de l'image gnre
      If Map>=#Region ;Attention  la parit!!!
        UWidth=(Width/2)*2*Scale
        VHeight=(Height/2)*2*Scale
      Else
        UWidth=Width*Scale
        VHeight=Height*Scale
      EndIf
      ResizeImage(#Generic,UWidth,VHeight,#PB_Image_Raw)
      CreateSprite(Map,UWidth,VHeight)
      
      ;Dessiner la carte sur le sprite (enfin!)  partir de l'image
      If StartDrawing(SpriteOutput(Map))
        DrawImage(ImageID(#Generic),0,0)
      StopDrawing() : EndIf
      
      ;Cration de l'image de slection
      If Map=#Region And SelectedRegion>-1
        
        *Address1=AllocateMemory(36)
        *Address2=AllocateMemory(36)
        
        For i=0 To 8 : PokeL(*Address2+i*4,AntiColor) : Next i
        
        CreateImage(#Selected,UWidth,VHeight,32)
        ;Adresse de l'image #Generic
        GetObject_(ImageID(#Generic),SizeOf(BITMAP),@OriGeneric)
        ;Adresse de l'image #Selected
        GetObject_(ImageID(#Selected),SizeOf(BITMAP),@OriSelected)
        
        *Img1=OriGeneric\bmBits
        *Img2=OriSelected\bmBits
        
        ;Pour le changement de ligne
        Line=OriGeneric\bmWidthBytes
        
        ;Dtection des contours
        For V=0 To VHeight-1
          For U=0 To UWidth-1
            ;Si c'est un pixel de la bonne couleur
            If *Img1\l=AntiColor
              ;Si c'est un pixel de bordure
              ;Alors c'est un pixel de contour
              If BorderMap(OriGeneric,U,V)
                *Img2\l=#One
              Else
                ;Code en assembleur pour optimiser au maximum la vitesse d'excution
                !MOV eax,dword [p.v_AntiColor]
                !MOV ebp,dword [p.p_Img1]
                !MOV edi,dword [p.p_Img2]
                !SUB ebp,dword [p.v_Line]
                
                !ADD ebp,-4
                !MOV ebx,dword [ebp]
                !CMP eax,ebx
                !JE  ENDIF1
                !MOV dword [edi],$010101
                !JMP l_loop
                !ENDIF1:
                
                !ADD  ebp,4
                !MOV  ebx,dword [ebp]
                !CMP  eax,ebx
                !JE   ENDIF2
                !MOV  dword [edi],$010101
                !JMP  l_loop
                !ENDIF2:
                
                !ADD  ebp,4
                !MOV  ebx,dword [ebp]
                !CMP  eax,ebx
                !JE   ENDIF3
                !MOV  dword [edi],$010101
                !JMP  l_loop
                !ENDIF3:
                
                !ADD  ebp,dword [p.v_Line]
                
                !MOV  ebx,dword [ebp]
                !CMP  eax,ebx
                !JE   ENDIF4
                !MOV  dword [edi],$010101
                !JMP  l_loop
                !ENDIF4:
                
                !ADD  ebp,-8
                !MOV  ebx,dword [ebp]
                !CMP  eax,ebx
                !JE   ENDIF5
                !MOV  dword [edi],$010101
                !JMP  l_loop
                !ENDIF5:
                
                !ADD  ebp,dword [p.v_Line]
                
                !MOV  ebx,dword [ebp]
                !CMP  eax,ebx
                !JE   ENDIF6
                !MOV  dword [edi],$010101
                !JMP  l_loop
                !ENDIF6:
                
                !ADD  ebp,4
                !MOV  ebx,dword [ebp]
                !CMP  eax,ebx
                !JE   ENDIF7
                !MOV  dword [edi],$010101
                !JMP  l_loop
                !ENDIF7:
                
                !ADD  ebp,4
                !MOV  ebx,dword [ebp]
                !CMP  eax,ebx
                !JE   ENDIF8
                !MOV  dword [edi],$010101
                !JMP  l_loop
                !ENDIF8:
                LOOP:
              EndIf
            EndIf
            *Img1+4
            *Img2+4
          Next U
        Next V
        
        ;Libration des mmoires
        FreeMemory(*Address1)
        FreeMemory(*Address2)
        
        ;Cration du sprite du calque de slection
        CreateSprite(#Selected,UWidth,VHeight)
        If StartDrawing(SpriteOutput(#Selected))
          DrawImage(ImageID(#Selected),0,0)
        StopDrawing() : EndIf
        ;Libration de l'image du calque de slection
        FreeImage(#Selected)
        
      EndIf
      
      ;Libration de l'image gnrique
      FreeImage(#Generic)
      
    EndIf
    
  Next Map
  
  ;Transparence spciale pour la carte des cits et des ports
  If IsSprite(#City) : TransparentSpriteColor(#City,#Gray) : EndIf
  
EndProcedure

Procedure DisplayMap(X.l,Y.l,Option.l)
  Protected U.l,V.l
  
  ;Demi-dcalage des coordonnes du sprite
  X-2*Scale
  Y-2*Scale
  
  ;Si le sprite est en dehors du champ en haut ou  gauche
  If X<0 : U=-X*Scale : EndIf
  If Y<0 : V=-Y*Scale : EndIf
  
  ;Dcalage de l'affichage
  U-4*Scale
  V-4*Scale
  
  ;Affichage de la carte principale
  If IsSprite(Option)
    If Option=#Region
      DisplaySprite(Option,U+Scale/2,V+Scale/2) ;Dcalage par rapport aux vertex
    Else
      DisplaySprite(Option,U,V)
    EndIf
  EndIf
  
  ;Affichage des autres lments
  If GetGadgetState(#Feature) And IsSprite(#Feature) : DisplayTransparentSprite(#Feature,U+Scale/2,V+Scale/2) : EndIf
  If GetGadgetState(#City) And IsSprite(#City) : DisplayTransparentSprite(#City,U+Scale/2,V+Scale/2) : EndIf
  If GetGadgetState(#Resource) And IsSprite(#Resource) : DisplayTransparentSprite(#Resource,U+Scale/2,V+Scale/2) : EndIf
  If GetGadgetState(#Army) And IsSprite(#Army) : DisplayTransparentSprite(#Army,U+Scale/2,V+Scale/2) : EndIf
  
  ;Affichage du calque de slection
  If SelectedRegion>-1 And IsSprite(#Selected) : DisplayTransparentSprite(#Selected,U+Scale/2,V+Scale/2) : EndIf
  
  ;Grille des vertex (Grid impair)
  If Grid%2 : DisplayTransparentSprite(#VertexGrid,0,0) : EndIf
  
  ;Grille de positionnement (Grid=2 ou 3)
  If Grid>1 : DisplayTransparentSprite(#PositionGrid,0,0) : EndIf
  
EndProcedure

Procedure DisplayScreen()

  ;On fait table-rase!!!
  ClearScreen(BackColor)
  ;Affichage de la carte
  DisplayMap(Cam\X,Cam\Y,Map)
  ;Affichage du pointeur si la souris est dans l'cran
  If InScreen
    ;Le pointeur de zoom
    If Cursor=#MouseZoom
      DisplayTransparentSprite(Cursor,Mouse\X-6,Mouse\Y-6) ;Dcalage (-6,-6) pour centrer la zone zoome au milieu de la loupe
      ;Dessin de la boite noir autour du pointeur
      If StartDrawing(ScreenOutput())
        DrawingMode(#PB_2DDrawing_Outlined)
        Box(Mouse\X-#Screen4,Mouse\Y-#Screen4,#Screen2,#Screen2,0)
        DrawingMode(#PB_2DDrawing_Default)
      StopDrawing() : EndIf
      ;Le pointeur de slection
      ElseIf Cursor=#MouseArrow
        DisplayTransparentSprite(Cursor,Mouse\X,Mouse\Y)
      ElseIf Cursor=#MousePoint
        DisplayTransparentSprite(Cursor,Mouse\X,Mouse\Y-16)
      ElseIf Cursor=#MouseColor
        DisplayTransparentSprite(Cursor,Mouse\X-3,Mouse\Y-15)
      ElseIf Cursor=#MouseSample
        DisplayTransparentSprite(Cursor,Mouse\X,Mouse\Y-15)
    EndIf
  EndIf
  ;Inversion des tampons d'cran (affichage final)
  FlipBuffers()
  ;MJ de la fentre principale !!! (pour mettre  jour les gadgets, les zones grises, etc.)
  
EndProcedure

; IDE Options = PureBasic 4.10 (Windows - x86)
; CursorPosition = 222
; Folding = A+