
;-Text files
;{

;Ouverture de la fentre de progression
Progress("Chargement...")

;MJ de la barre d'tat
StatusBarText(#Status,0,"Chargement des donnes...")
  
;********************************************************************************************************
;-Religions
;********************************************************************************************************

;Ouverture du fichier bin pour la lecture des religions
ReadFile(#Religions,Path$+Files(#Religions))

;Macro de lecture du bin
ReadStringsBin(#Religions,Religions(),Type,Length,Number,*Address)

;Fermeture du fichier bin
CloseFile(#Religions)
  
;Un nombre impair d'entits lues indique une erreur de correspondance
;Entre les noms internes et externes qui vont forcment par pair
If Type%2
  FatalError("Le fichier "+Files(#Religions)+" est corrompu !")
EndIf

;Ouverture du fichier descr_religions.txt pour ordonner les religions
ReadFile(#DescrReligions,Path$+Files(#DescrReligions))

FirstElement(Religions())
Type=-2

;Boucle de lecture
While Not Eof(#DescrReligions)
  
  ;Lecture
  String$=ReadString(#DescrReligions)
  ;Nettoyage de la ligne
  ClearString(String$)
  ;Si la ligne est vide on continue
  If String$="" : Continue : EndIf
  
  ;La liste des religions
  If String$="religions" : Type=-1 : Continue : EndIf
  ;Le commencement de la liste des religions
  If String$="{" And Type=-1 : Type=0 : Continue : EndIf
  ;Si on lit la liste des religions
  If Type>-1
    ;Si on a finit
    If String$="}"
      ;Suppression des lments superflus
      Number=CountList(Religions())-Type
      LastElement(Religions()) : Type=0
      While Type<Number : DeleteElement(Religions()) : Type+1 : Wend
      Break
    Else ;La religion suivante ordonne dans la liste chane
      ;On slectionne l'emplacement suivant
      SelectElement(Religions(),Type) : *First=@Religions() : Error=1
      ;On cherche quel est l'lment qui convient pour cet emplacement
      ForEach Religions() : If String$=Religions()\In$ : *Second=@Religions() : Error=0 : Break : EndIf : Next
      ;On change les lments et on passe  l'emplacement suivant
      If Not Error : SwapElements(Religions(),*First,*Second) : Type+1 : Else : FatalError("Les fichiers concernant les religions pourraient tre corrompus.") : EndIf
    EndIf
  EndIf
Wend

;Dtection des erreurs
If CountList(Religions())>10
  FatalError("La limite maximale de 10 religions a t dpasse, impossible de continuer !")
EndIf

;Fermeture du fichier descr_religions.txt
CloseFile(#DescrReligions)

;Mise au point des lments religieux de la fentre principale
OpenGadgetList(#InnerPanel,1)
  
  Item=CountList(Religions())
  
  If Item<8
    Frame3DGadget(#TextReligion,10,150,#PanelWidth-50,51+Item/2*25,"Religions :")
    ContainerGadget(#ScrollReligion,20,170,#PanelWidth-70,20+Item/2*25)
    Total=0
  Else
    Frame3DGadget(#TextReligion,10,150,#PanelWidth-50,138,"Religions :")
    ScrollAreaGadget(#ScrollReligion,20,170,#PanelWidth-70,108,#PanelWidth-91,30+Item/2*25,100)
    Total=1
  EndIf
  
  ResetList(Religions())
  For Type=0 To Item-1
    NextElement(Religions())
    TextGadget(#TextA+Type*2,5*Total+(Type%2)*(135-20*Total),3+5*Total+25*(Type/2),70-5*Total,14,Religions()\Out$+" :")
    SpinGadget(#SpinA+Type*2,75-5*Total+(Type%2)*(135-20*Total),5*Total+25*(Type/2),35,20,0,100,#PB_Spin_Numeric) : SetGadgetState(#SpinA+Type*2,0)
  Next Type
  TextGadget(#TextTotalReligion,5*Total+(Type%2)*(135-20*Total),3+5*Total+25*(Type/2),70-5*Total,14,"Total :")
  StringGadget(#TotalReligion,75-5*Total+(Type%2)*(135-20*Total),5*Total+25*(Type/2),25,20,"0",#PB_String_Numeric|#PB_String_ReadOnly) : SetGadgetColor(#TotalReligion,#PB_Gadget_FrontColor,#Rouge)
  
  CloseGadgetList()
  
CloseGadgetList()

;Mise au point du menu droulant religieux de la fentre des factions
ResetList(Religions())
For Type=0 To Item-1
  NextElement(Religions())
  AddGadgetItem(#FReligion,Type,Religions()\Out$)
  SetGadgetItemData(#FReligion,Type,@Religions())
Next Type
ResizeGadget(#FReligion,#PB_Ignore,#PB_Ignore,#PB_Ignore,Item*20)

SetProgress(2)

;********************************************************************************************************
;-Rebels
;********************************************************************************************************

;Ouverture de descr_rebel_factions.txt
ReadFile(#DescrRebelFactions,Path$+Files(#DescrRebelFactions))

While Not Eof(#DescrRebelFactions)
  ;Lecture
  String$=ReadString(#DescrRebelFactions)
  ;Nettoyage de la ligne
  ClearString(String$)
  ;Si la ligne est vide on continue
  If String$="" : Continue : EndIf
  
  If Left(String$,10)="rebel_type" ;Identifiant interne d'une faction rebelle
    AddElement(RebelFactions())
    String$=Mid(String$,11,Len(String$)-10)
    ClearString(String$)
    RebelFactions()\In$=String$
  ElseIf Left(String$,8)="category"
    String$=Mid(String$,9,Len(String$)-8)
    ClearString(String$)
    If String$<>"peasant_revolt" ;On ne garde que les rvoltes populaires
      DeleteElement(RebelFactions(),1)
    EndIf
  EndIf
Wend

;Fermeture du fichier
CloseFile(#DescrRebelFactions)

;Ouverture du fichier binaire rebel_faction_descr.txt.strings.bin
;Pour associer les identifiants internes aux noms externes
ReadFile(#RebelFactions,Path$+Files(#RebelFactions))
ReadStringsBin(#RebelFactions,Names(),Type,Length,Number,*Address)
CloseFile(#RebelFactions)

;Boucle d'association
Type=0
ForEach RebelFactions()
  ForEach Names()
    If RebelFactions()\In$=Names()\In$
      RebelFactions()\Out$=Names()\Out$
      Break
    EndIf
  Next
  AddGadgetItem(#RebelsRegion,Type,RebelFactions()\Out$)
  SetGadgetItemData(#RebelsRegion,Type,@RebelFactions())
  Type+1
Next

;MJ de la taille du gadget!
If CountList(RebelFactions())>10
  ResizeGadget(#RebelsRegion,#PB_Ignore,#PB_Ignore,#PB_Ignore,200)
Else
  ResizeGadget(#RebelsRegion,#PB_Ignore,#PB_Ignore,#PB_Ignore,20*CountList(RebelFactions()))
EndIf

;Contenu de liste maintenant inutile
ClearList(Names())

SetProgress(5)

;********************************************************************************************************
;-Factions
;********************************************************************************************************

;Ouverture du fichier descr_sm_factions.txt
ReadFile(#DescrSmFactions,Path$+Files(#DescrSmFactions))

While Not Eof(#DescrSmFactions)
  
  ;Lecture
  String$=ReadString(#DescrSmFactions)
  ;Nettoyage
  ClearString(String$)
  ;Si la ligne est vide on continue
  If String$="" : Continue : EndIf
  
  ;Recherche de l'identifiant
  Com=FindString(String$," ",1)
  Text$=Left(String$,Com-1)
  Argument(String$,Com)
  
  ;Remplissage de la liste chane avec les diffrents arguments
  Select Text$
    Case "faction"
      ;Nouvelle faction
      AddElement(Factions())
      Com=FindString(String$,",",1)
      If Com=0
        Factions()\Name\In$=String$
      Else
        Text$=Left(String$,Com-1)
        String$=Trim(Mid(String$,Com+1,Len(String$)-Com))
        Factions()\Name\In$=Text$
        Factions()\Spawned$=StringField(String$,1," ")
        Argument(String$,Len(Factions()\Spawned$))
        Factions()\Shadow$=String$
      EndIf
      
      ;Initialisation de quelques valeurs
      Factions()\Plague=-1
      Factions()\Disband=-1
      Factions()\Tower=-1
      For Type=0 To 9
        Factions()\Horde\Disband[Type]=-1
      Next Type
      
    Case "culture"
      Factions()\Culture$=String$
    Case "religion"
      Factions()\Religion\In$=String$
      ;Association de l'identifiant interne avec le nom externe
      ForEach Religions()
        If String$=Religions()\In$
          Factions()\Religion\Out$=Religions()\Out$
          Break
        EndIf
      Next
    Case "special_faction_type"
      Factions()\SpecialType$=String$
    Case "symbol"
      Factions()\Hidden\Symbol$=String$
    Case "rebel_symbol"
      Factions()\Hidden\Rebel$=String$
    Case "primary_colour"
      Red=Val(StringField(String$,2," "))
      Green=Val(StringField(String$,4," "))
      Blue=Val(StringField(String$,6," "))
      Factions()\Color1=RGB(Red,Green,Blue)
    Case "secondary_colour"
      Red=Val(StringField(String$,2," "))
      Green=Val(StringField(String$,4," "))
      Blue=Val(StringField(String$,6," "))
      Factions()\Color2=RGB(Red,Green,Blue)
    Case "loading_logo"
      Factions()\Hidden\Loading$=String$
    Case "standard_index"
      Factions()\Hidden\Standard=Val(String$)
    Case "logo_index"
      Factions()\Hidden\Logo$=String$
    Case "small_logo_index"
      Factions()\Hidden\SmallLogo$=String$
    Case "triumph_value"
      Factions()\Hidden\Triumph=Val(String$)
    Case "custom_battle_availability"
      StringToVal(String$,Factions()\Custom)
    Case "horde_min_units"
      Type=0
      Factions()\Horde\MinUnits=Val(String$)
    Case "horde_max_units"
      Factions()\Horde\MaxUnits=Val(String$)
    Case "horde_max_units_reduction_every_horde"
      Factions()\Horde\Reduction=Val(String$)
    Case "horde_unit_per_settlement_population"
      Factions()\Horde\Population=Val(String$)
    Case "horde_min_named_characters"
      Factions()\Horde\Character=Val(String$)
    Case "horde_max_percent_army_stack"
      Factions()\Horde\Army=Val(String$)
    Case "horde_disband_percent_on_settlement_capture"
      Factions()\Horde\Disband[Type]=Val(String$)
      Type+1
    Case "horde_unit"
      If Factions()\Horde\Units$=""
        Factions()\Horde\Units$=String$
      Else
        Factions()\Horde\Units$+Chr(9)+String$
      EndIf
    Case "can_sap"
      StringToVal(String$,Factions()\Sap)
    Case "prefers_naval_invasions"
      StringToVal(String$,Factions()\Naval)
    Case "can_have_princess"
      StringToVal(String$,Factions()\Princess)
    Case "has_family_tree"
      StringToVal(String$,Factions()\Family)
    Case "can_transmit_plague"
      StringToVal(String$,Factions()\Plague)
    Case "disband_to_pools"
      StringToVal(String$,Factions()\Disband)
    Case "can_build_siege_towers"
      StringToVal(String$,Factions()\Tower)
  EndSelect
  
Wend

;Fermeture du fichier descr_sm_factions.txt
CloseFile(#DescrSmFactions)

;Lecture de expanded.txt.strings.bin
OpenFile(#Expanded,Path$+Files(#Expanded))
ReadStringsBin(#Expanded,Names(),Type,Length,Number,*Address)
CloseFile(#Expanded)

Type=0
ForEach Factions()
  
  ;Association identifiant interne et nom externe
  String$=UCase(Factions()\Name\In$)
  ForEach Names()
    If String$=Names()\In$
      Factions()\Name\Out$=Names()\Out$
      Break
    EndIf
  Next
  
  ;Remplissage des ComboBox
  AddGadgetItem(#FactionRegion,Type,Factions()\Name\Out$)
  AddGadgetItem(#OriFactionRegion,Type,Factions()\Name\Out$)
  ;Donnes internes des gadgets
  SetGadgetItemData(#FactionRegion,Type,@Factions())
  SetGadgetItemData(#OriFactionRegion,Type,@Factions())
  
  Type+1 ;Incrmentation
Next

;Ajustement de la taille des gadgets
If CountList(Factions())>10
  ResizeGadget(#FactionRegion,#PB_Ignore,#PB_Ignore,#PB_Ignore,200)
  ResizeGadget(#OriFactionRegion,#PB_Ignore,#PB_Ignore,#PB_Ignore,200)
Else
  ResizeGadget(#FactionRegion,#PB_Ignore,#PB_Ignore,#PB_Ignore,20*CountList(Factions()))
  ResizeGadget(#OriFactionRegion,#PB_Ignore,#PB_Ignore,#PB_Ignore,20*CountList(Factions()))
EndIf

;On a finit de s'en servir
ClearList(Names())

Type=0
ForEach Factions()
  AddGadgetItem(#ListFaction,Type,Factions()\Name\Out$)
  SetGadgetItemData(#ListFaction,Type,@Factions())
  Type+1
Next

;Cration des tableaux de relations entre factions
Type=CountList(Factions())-1
Global Dim Standings.b(Type,Type)
Global Dim Relationships.b(Type,Type)

SetProgress(10)

;********************************************************************************************************
;-Regions
;********************************************************************************************************

;Ouverture du fichier descr_regions.txt
ReadFile(#DescrRegions,Path$+Files(#DescrRegions))

Number=0
Type=0

;Boucle de lecture
While Not Eof(#DescrRegions)
  
  ;Lecture
  String$=ReadString(#DescrRegions)
  ;Nettoyage de la ligne
  ClearString(String$)
  ;Si la chane est maintenant vide, on passe  l'itration suivante
  If String$="" : Continue : EndIf
  
  ;Longueur de la chane
  Length=Len(String$)
  
  ;Etape de la lecture
  Select Type
    Case 0 ;Nom de la province
      AddElement(Regions())
      Regions()\Province\In$=String$
    Case 1 ;Nom de la ville
      Regions()\City\In$=String$
      Regions()\City\Population=400
    Case 2 ;Faction
      Regions()\OriFaction$=String$
    Case 3 ;Nom des rebelles
      Regions()\Rebels$=String$
    Case 4 ;Couleur de la rgion
      Red=Val(StringField(String$,1," "))
      Green=Val(StringField(String$,2," "))
      Blue=Val(StringField(String$,3," "))
      Regions()\Color=RGB(Red,Green,Blue)
    Case 5 ;Liste des ressources
      Regions()\Resources$=String$
    Case 6 ;Victoire
      Regions()\Victory=Val(String$)
    Case 7 ;Rendement des rcoltes
      Regions()\Agriculture=Val(String$)
    Case 8 ;Religions
      For Com=0 To CountList(Religions())-1
        Regions()\Religions[Com]=Val(StringField(String$,4+2*Com," "))
      Next
  EndSelect
  
  ;Incrmentation ou rinitialisation
  If Type<8 : Type+1 : Else : Type=0 : EndIf
  
Wend

;Dtection des erreurs
If CountList(Regions())>199
  Error("Il semble que le nombre maximal de 199 rgions ait t dpass !")
EndIf

;Fermeture du fichier descr_regions.txt
CloseFile(#DescrRegions)

SetProgress(12)

;********************************************************************************************************
;-Region names
;********************************************************************************************************

;Ouverture du fichier imperial_campaign_regions_and_settlement_names.txt.strings.bin
ReadFile(#Regions,Path$+Files(#Regions))
ReadStringsBin(#Regions,Names(),Type,Length,Number,*Address)
CloseFile(#Regions)

;Un nombre impair d'entits lues indique une erreur de correspondance
;Entre les noms internes et externes qui vont forcment par pair
If Type%2
  FatalError("Le fichier "+Files(#Regions)+" est corrompu !")
EndIf

;Position de la rgion dans la liste
Number=0

;Boucle d'association des noms internes et externes
ForEach Regions()
  ;Recherche du nom de rgion
  Type=1
  String$=Regions()\Province\In$
  ForEach Names()
    If String$=Names()\In$
      Regions()\Province\Out$=Names()\Out$
      AddGadgetItem(#ListRegion,Number,Regions()\Province\Out$)
      SetGadgetItemData(#ListRegion,Number,@Regions())
      Type=0
      Break
    EndIf
  Next
  If Type : FatalError("La rgion "+String$+" n'est associe  aucune entre dans le fichier "+Files(#Regions)+" !") : EndIf
  ;Recherche du nom de ville
  Type=1
  String$=Regions()\City\In$
  ForEach Names()
    If String$=Names()\In$
      Regions()\City\Out$=Names()\Out$
      Type=0
      Break
    EndIf
  Next
  If Type : FatalError("La ville "+String$+" n'est associe  aucune entre dans le fichier "+Files(#Regions)+" !") : EndIf
  Number+1 ;incrmentation
Next

;Cette liste ne sert plus  rien
ClearList(Names())

SetProgress(14)

;********************************************************************************************************
;-Mercenaries
;********************************************************************************************************

ReadFile(#DescrMercenaries,Path$+Files(#DescrMercenaries))

;Boucle de lecture du fichier
While Not Eof(#DescrMercenaries)
  
  ;Nettoyage de la ligne
  String$=ReadString(#DescrMercenaries)
  ClearString(String$)
  
  If String$<>""
    
    If Left(String$,4)="pool" ;Nouveau pool de mercenaires
      AddElement(Mercenaries())
      Argument(String$,4)
      Mercenaries()\Pool$=String$
    ElseIf Left(String$,7)="regions" ;Les rgions du pool
      Argument(String$,7)
      For i=1 To CountString(String$," ")+1
        Text$=StringField(String$,i," ")
        If Text$<>""
          ;Text$ est l'identifiant interne d'une rgion
          ;Il faut trouver cette rgion pour lui attribuer le pool
          ForEach Regions()
            If Regions()\Province\In$=Text$
              Regions()\Pool$=Mercenaries()\Pool$
              Break
            EndIf
          Next
        EndIf
      Next i
    ElseIf Left(String$,4)="unit"
      Argument(String$,4)
      Text$=Trim(Left(String$,FindString(String$," exp",1)))
      Argument(String$,Len(Text$))
      If Mercenaries()\Units$="" And Mercenaries()\Features$=""
        Mercenaries()\Units$=Text$
        Mercenaries()\Features$=String$
      Else
        Mercenaries()\Units$=Mercenaries()\Units$+Chr(9)+Text$
        Mercenaries()\Features$=Mercenaries()\Features$+Chr(9)+String$
      EndIf
    EndIf
  EndIf
  
Wend

;Fermeture du fichier
CloseFile(#DescrMercenaries)

;Remplissage de la ComboBox
AddGadgetItem(#MercRegion,-1,"(Aucun)")
ForEach Mercenaries()
  AddGadgetItem(#MercRegion,-1,Mercenaries()\Pool$)
Next
;Taille de la ComboBox
If CountGadgetItems(#MercRegion)>10
  ResizeGadget(#MercRegion,#PB_Ignore,#PB_Ignore,#PB_Ignore,200)
Else
  ResizeGadget(#MercRegion,#PB_Ignore,#PB_Ignore,#PB_Ignore,20*CountGadgetItems(#MercRegion))
EndIf
;Initialisation
SetGadgetState(#MercRegion,0)

SetProgress(17)

;********************************************************************************************************
;-Musics
;********************************************************************************************************

ReadFile(#DescrSoundsMusicTypes,Path$+Files(#DescrSoundsMusicTypes))

While Not Eof(#DescrSoundsMusicTypes)
  
  ;Lecture et nettoyage
  String$=ReadString(#DescrSoundsMusicTypes)
  ClearString(String$)
  If String$="" : Continue : EndIf
  
  If Left(String$,10)="music_type"
    ;Nouveau type de musique
    Argument(String$,10)
    Music$=String$
    AddGadgetItem(#MusicRegion,-1,Music$)
    AddGadgetItem(#FMusic,-1,Music$)
  ElseIf Left(String$,7)="regions"
    ;Attribution des musiques aux rgions
    Argument(String$,7)
    For i=1 To CountString(String$," ")+1
      Text$=Trim(StringField(String$,i," "))
      If Text$="" : Continue : EndIf
      ForEach Regions()
        If Regions()\Province\In$=Text$
          Regions()\Music$=Music$
          Break
        EndIf
      Next
    Next i
  ElseIf Left(String$,8)="factions"
    ;Attribution des musiques aux factions
    Argument(String$,8)
    For i=1 To CountString(String$," ")+1
      Text$=Trim(StringField(String$,i," "))
      If Text$="" : Continue : EndIf
      ForEach Factions()
        If Factions()\Name\In$=Text$
          Factions()\Music$=Music$
          Break
        EndIf
      Next
    Next i
  EndIf
  
Wend

ResizeGadget(#MusicRegion,#PB_Ignore,#PB_Ignore,#PB_Ignore,20*CountGadgetItems(#MusicRegion))
ResizeGadget(#FMusic,#PB_Ignore,#PB_Ignore,#PB_Ignore,20*CountGadgetItems(#FMusic))

CloseFile(#DescrSoundsMusicTypes)

SetProgress(18)

;********************************************************************************************************
;-Buildings
;********************************************************************************************************

OpenFile(#EDB,Path$+Files(#EDB))

While Not Eof(#EDB)

  ;Lecture et nettoyage
  String$=ReadString(#EDB)
  ClearString(String$)
  If String$="" : Continue : EndIf
  
  If Left(String$,8)="building"
    ;Nouveau type de btiment
    Argument(String$,8)
    AddElement(Buildings())
    Buildings()\Type$=String$
  ElseIf Left(String$,6)="levels"
    ;Tous les niveaux possibles
    Argument(String$,6)
    Buildings()\Levels$=String$
  EndIf
Wend

CloseFile(#EDB)

;********************************************************************************************************
;-Victory conditions
;********************************************************************************************************

OpenFile(#DescrWinConditions,Path$+Files(#DescrWinConditions))

Type=0
Total=0
While Not Eof(#DescrWinConditions)
  
  ;Lecture de la ligne
  String$=ReadString(#DescrWinConditions)
  ClearString(String$)
  If String$="" : Continue : EndIf
  
  ;A quelle faction correspondent les conditions de victoire qui suivront ?
  ForEach Factions()
    If String$=Factions()\Name\In$
      *Faction=@Factions()
      Type=1
      Total=0
      Break
    EndIf
  Next
  
  ;Si on a trouv une faction, ses conditions de victoire se trouvent  la ligne suivante
  If Type : Type=0 : Continue : EndIf
  
  ;On rinitialise la faction
  ChangeCurrentElement(Factions(),*Faction)
  
  ;Si la campagne est courte
  If Left(String$,14)="short_campaign" : Total=1 : Argument(String$,14) : EndIf
  
  ;Lecture des conditions de victoire
  If Left(String$,12)="hold_regions"
    Argument(String$,12) : Type=1
    Repeat
      If StringField(String$,Type," ")<>""
        If Total
          If Factions()\Short\Hold$="" : Factions()\Short\Hold$=StringField(String$,Type," ") : Else : Factions()\Short\Hold$+Chr(9)+StringField(String$,Type," ") : EndIf
        Else
          If Factions()\Long\Hold$="" : Factions()\Long\Hold$=StringField(String$,Type," ") : Else : Factions()\Long\Hold$+Chr(9)+StringField(String$,Type," ") : EndIf
        EndIf
        Type+1
        If Str(Val(StringField(String$,Type," ")))=StringField(String$,Type," ")
          If Total : Factions()\Short\Hold$+","+StringField(String$,Type," ") : Else : Factions()\Long\Hold$+","+StringField(String$,Type," ") : EndIf
        Else
          Type-1 : If Total : Factions()\Short\Hold$+",-1" : Else : Factions()\Long\Hold$+",0" : EndIf
        EndIf
      EndIf
      Type+1
    Until Type>CountString(String$," ")+1 : Type=0
  ElseIf Left(String$,12)="take_regions"
    Argument(String$,12)
    If Total : Factions()\Short\Take=Val(String$) : Else : Factions()\Long\Take=Val(String$) : EndIf
  ElseIf Left(String$,7)="outlive"
    Argument(String$,7)
    If Total : Factions()\Short\Outlive$=String$ : Else : Factions()\Long\Outlive$=String$ : EndIf
  EndIf
  
Wend

CloseFile(#DescrWinConditions)

;********************************************************************************************************
;-Campaign
;********************************************************************************************************

OpenFile(#DescrStrat,Path$+Files(#DescrStrat))

Type=0
Campaign\Upkeep=-1 ;par dfaut

While Not Eof(#DescrStrat)
  
  ;Lecture de la ligne
  String$=ReadString(#DescrStrat)
  ClearString(String$)
  If String$="" : If Type=8 : Type=6 : EndIf : Continue : EndIf
  
  ;- > > Playability
  ;Factions jouables, dbloquables ou injouables ?
  If Type<3
    Select String$
      Case "playable" : Total=1
      Case "unlockable" : Total=2
      Case "nonplayable" : Total=3
      Case "end" : Type+1
      Default
        If Total=Type+1
          ForEach Factions()
            If Factions()\Name\In$=String$
              Factions()\Status\Playable=Total
              Break
            EndIf
          Next
        EndIf
    EndSelect
    Continue
  EndIf
  
  ;- > > Time
  ;Les dates de dpart et de fin de campagne, et l'chelle de temps
  If Type=3
    If Left(String$,10)="start_date"
      Argument(String$,10)
      Campaign\StartDate\Year=Val(StringField(String$,1," "))
      Campaign\StartDate\Season$=StringField(String$,2," ")
    ElseIf Left(String$,8)="end_date"
      Argument(String$,8)
      Campaign\EndDate\Year=Val(StringField(String$,1," "))
      Campaign\EndDate\Season$=StringField(String$,2," ")
    ElseIf Left(String$,9)="timescale"
      Argument(String$,9)
      Campaign\TimeScale=ValF(String$)
      Type=4
    EndIf
    Continue
  EndIf
  
  ;- > > Brigands & pirates
  If Type=4
    If Left(String$,19)="brigand_spawn_value"
      Argument(String$,19)
      Campaign\Brigand=Val(String$)
    ElseIf Left(String$,18)="pirate_spawn_value"
      Argument(String$,18)
      Campaign\Pirate=Val(String$)
      Type=5
    Else
      If Campaign\Options$="" : Campaign\Options$=String$ : Else : Campaign\Options$+Chr(9)+String$ : EndIf
    EndIf
    Continue
  EndIf
  
  ;- > > Resources
  If Type=5
    Total=0
    If Left(String$,17)="free_upkeep_forts"
      Argument(String$,17)
      Campaign\Upkeep=Val(String$)
      If Campaign\Upkeep>20 : FatalError("La limite de 20 units entretenues gratuitement dans les forts a t dpasse !") : EndIf
    ElseIf Left(String$,8)="resource"
      Argument(String$,8)
      Coord\X=Val(Trim(StringField(String$,2,",")))
      Coord\Y=Val(Trim(StringField(String$,3,",")))
      ;Vrification qu'il n'y a pas dj une ressource  cet endroit
      ForEach Resources()
        If Resources()\X=Coord\X And Resources()\Y=Coord\Y
          Error("La ressource "+Trim(StringField(String$,1,","))+" aux coordonnes "+Str(Coord\X)+", "+Str(Coord\Y)+" sera ignore.")
          Total=1
          Break
        EndIf
      Next
      If Total : Continue : EndIf
      AddElement(Resources())
      Resources()\Name$=Trim(StringField(String$,1,","))
      Resources()\X=Coord\X
      Resources()\Y=Coord\Y
    Else
      Type=6
    EndIf
    ;Pas de Continue ici !!!
  EndIf
  
  ;Passage  la structure qui traite des personnages
  If Left(String$,9)="character" Or Left(String$,16)="character_record" Or Left(String$,8)="relative"
    Type=8
  EndIf
  
  ;Passage  la structure qui traite de la diplomatie
  If Left(String$,17)="faction_standings" Or Left(String$,21)="faction_relationships"
    Type=9
  EndIf
  
  ;-> > Factions
  If Type=6
    If Left(String$,7)="faction"
      Argument(String$,7)
      ForEach Factions()
        If Factions()\Name\In$=StringField(String$,1,",")
          *Faction=@Factions()
          String$=Trim(StringField(String$,2,","))
          Factions()\Status\EconomicAI$=StringField(String$,1," ")
          Factions()\Status\MilitaryAI$=StringField(String$,2," ")
        EndIf
      Next
    ElseIf Left(String$,8)="ai_label"
      Argument(String$,8)
      ChangeCurrentElement(Factions(),*Faction)
      Factions()\Status\LabelAI$=String$
    ElseIf Left(String$,6)="denari"
      ChangeCurrentElement(Factions(),*Faction)
      If Left(String$,18)="denari_kings_purse"
        Argument(String$,18)
        Factions()\Status\KingsPurse=Val(String$)
      Else
        Argument(String$,6)
        Factions()\Status\Money=Val(String$)
      EndIf
    ElseIf String$="undiscovered"
      ChangeCurrentElement(Factions(),*Faction)
      Factions()\Status\Undiscovered=1
    ElseIf String$="dead_until_resurrected"
      ChangeCurrentElement(Factions(),*Faction)
      Factions()\Status\Spawning=1
    ElseIf String$="dead_until_emerged"
      ChangeCurrentElement(Factions(),*Faction)
      Factions()\Status\Spawning=2
    ElseIf String$="re_emergent"
      ChangeCurrentElement(Factions(),*Faction)
      Factions()\Status\Reemergent=1
    ElseIf Left(String$,10)="settlement"
      ChangeCurrentElement(Factions(),*Faction)
      Argument(String$,10)
      If String$="castle" : Castle=1 : Else : Castle=0 : EndIf
      Type=7
      Total=0
    ElseIf String$="script" : Type=10
    EndIf
    Continue
  EndIf
  
  ;- > > Communities
  ;Btiments et informations sur les communautes
  If Type=7
    If String$="{" : Total+1
    ElseIf String$="}"
    Total-1 : If Total=0 : Type=6 : Continue : EndIf
    ElseIf Left(String$,5)="level"
      Argument(String$,5)
      StringToLevel(String$,Level)
    ElseIf Left(String$,6)="region"
      ChangeCurrentElement(Factions(),*Faction)
      Argument(String$,6)
      ForEach Regions()
        If Regions()\Province\In$=String$
          *Region=@Regions()
          Regions()\City\Castle=Castle
          Regions()\City\Level=Level
          Regions()\Faction$=Factions()\Name\In$
        EndIf
      Next
    ElseIf Left(String$,10)="population"
      ChangeCurrentElement(Regions(),*Region)
      Argument(String$,10)
      Regions()\City\Population=Val(String$)
    ElseIf Left(String$,4)="type"
      ChangeCurrentElement(Regions(),*Region)
      Argument(String$,4)
      If Regions()\City\Buildings$=""
        Regions()\City\Buildings$=String$
      Else
        Regions()\City\Buildings$+Chr(9)+String$
      EndIf
    EndIf
  EndIf
  
  ;- > > Characters
  If Type=8
    If Left(String$,9)="character" And Not Left(String$,16)="character_record"
      AddElement(Characters())
      ChangeCurrentElement(Factions(),*Faction)
      Characters()\Faction$=Factions()\Name\In$
      Argument(String$,9)
      i=1 : j=0
      If Characters()\Faction$="slave"
        ;Sous-faction spciale pour la faction rebelle
        Repeat
          Text$=StringField(String$,i,",")
          ClearString(Text$)
          If i=1 : Argument(Text$,11) : Characters()\SubFaction$=Text$
          ElseIf i=2 : Characters()\Name$=Text$
          ElseIf i=3 : StringToChar(Text$,Item) : Characters()\Type=Item
          ElseIf i=4 : If Text$="male" : Characters()\Sex=1 : EndIf
          ElseIf i=5
            If Text$="leader" Or Text$="heir"
              If Text$="leader" : Characters()\Leader=1 : Else : Characters()\Leader=2 : EndIf
            Else
              Argument(Text$,3) : ClearString(Text$) : Characters()\Age=Val(Text$)
            EndIf
          EndIf
          If Characters()\Leader=0
            If i=6
              Argument(Text$,1) : ClearString(Text$) : Characters()\Pos\X=Val(Text$)
            ElseIf i=7
              Argument(Text$,1) : ClearString(Text$) : Characters()\Pos\Y=Val(Text$)
              ;On sort de la boucle
              Break
            EndIf
          Else
            If i=6
              Argument(Text$,3) : ClearString(Text$) : Characters()\Age=Val(Text$)
            ElseIf i=7
              Argument(Text$,1) : ClearString(Text$) : Characters()\Pos\X=Val(Text$)
            ElseIf i=8
              Argument(Text$,1) : ClearString(Text$) : Characters()\Pos\Y=Val(Text$)
              ;On sort de la boucle
              Break
            EndIf
          EndIf
          i+1
        ForEver
      Else
        ;Cas gnral pour toutes les autres factions
        Repeat
          Text$=StringField(String$,i,",")
          ClearString(Text$)
          If i=1 : Characters()\Name$=Text$
          ElseIf i=2 : StringToChar(Text$,Item) : Characters()\Type=Item
          ElseIf i=3 : If Text$="male" : Characters()\Sex=1 : EndIf
          ElseIf i=4
            If Text$="leader" Or Text$="heir"
              If Text$="leader" : Characters()\Leader=1 : Else : Characters()\Leader=2 : EndIf
            Else
              Argument(Text$,3) : ClearString(Text$) : Characters()\Age=Val(Text$)
            EndIf
          EndIf
          If Characters()\Leader=0
            If i=5
              Argument(Text$,1) : ClearString(Text$) : Characters()\Pos\X=Val(Text$)
            ElseIf i=6
              Argument(Text$,1) : ClearString(Text$) : Characters()\Pos\Y=Val(Text$)
              ;On sort de la boucle
              Break
            EndIf
          Else
            If i=5
              Argument(Text$,3) : ClearString(Text$) : Characters()\Age=Val(Text$)
            ElseIf i=6
              Argument(Text$,1) : ClearString(Text$) : Characters()\Pos\X=Val(Text$)
            ElseIf i=7
              Argument(Text$,1) : ClearString(Text$) : Characters()\Pos\Y=Val(Text$)
              ;On sort de la boucle
              Break
            EndIf
          EndIf
          i+1
        ForEver
      EndIf
    ElseIf Left(String$,16)="character_record"
      AddElement(Characters())
      ChangeCurrentElement(Factions(),*Faction)
      Characters()\Faction$=Factions()\Name\In$
      Characters()\Offmap=1
      Argument(String$,16)
      For i=1 To 5
        Text$=StringField(String$,i,",")
        ClearString(Text$)
        Select i
          Case 1 : Characters()\Name$=Text$
          Case 2 : If Text$="male" : Characters()\Sex=1 : EndIf
          Case 3 : Argument(Text$,3) : ClearString(Text$) : Characters()\Age=Val(Text$)
          Case 4
            If Text$="alive" : Characters()\Death=-1
            ElseIf Text$="off_map" : Characters()\Death=-2
            Else : Argument(Text$,4) : Characters()\Death=Val(Text$) : EndIf
          Case 5 : If Text$="current_leader" : Characters()\Leader=1 : EndIf
        EndSelect
      Next i
    ElseIf Left(String$,6)="traits"
      Argument(String$,6)
      Characters()\Traits$=String$
    ElseIf Left(String$,11)="ancillaries"
      Argument(String$,11)
      Characters()\Ancil$=String$
    ElseIf Left(String$,4)="unit"
      ;Vrification du nombre d'units dj prsentes
      If Characters()\Army=20 : FatalError("Le personnage "+Characters()\Name$+" ("+Characters()\Faction$+") possde une arme de plus de 20 units !") : EndIf
      Argument(String$,4)
      ;Nom de l'unit
      Item=FindString(String$,"exp",1)-1
      Characters()\Units[Characters()\Army]\Name$=Trim(Left(String$,Item))
      ;Caractristiques de l'unit
      Argument(String$,Item)
      Characters()\Units[Characters()\Army]\Exp=Val(StringField(String$,2," "))
      Characters()\Units[Characters()\Army]\Armour=Val(StringField(String$,4," "))
      Characters()\Units[Characters()\Army]\Weapon=Val(StringField(String$,6," "))
      Characters()\Army+1 ;Unit ajoute
    ElseIf Left(String$,8)="relative"
      ;Arbre gnaologique ici !!!
      Argument(String$,8)
      ChangeCurrentElement(Factions(),*Faction)
      If Factions()\Relative=20 : FatalError("L'arbre gnalogique de la faction '"+Factions()\Name\Out$+"' est trop grand et ne peut pas tre trait.") : EndIf
      Factions()\Tree[Factions()\Relative]\Number=CountString(String$,",")
      If Factions()\Tree[Factions()\Relative]\Number>7 Or Factions()\Tree[Factions()\Relative]\Number<2 : FatalError("L'arbre gnalogique de la faction '"+Factions()\Name\Out$+"' est trop complexe et ne peut pas tre trait.") : EndIf
      For i=1 To Factions()\Tree[Factions()\Relative]\Number
        Factions()\Tree[Factions()\Relative]\Member$[i-1]=Trim(StringField(String$,i,","))
      Next i
      Factions()\Relative+1
    EndIf
  EndIf
  
  ;- > > War & peace
  If Type=9
    ;Etat des relations entre les factions
    If Left(String$,17)="faction_standings"
      Argument(String$,17)
      Text$=StringField(String$,1,",")
      ForEach Factions()
        If Text$=Factions()\Name\In$
          Com=ListIndex(Factions())
          Break
        EndIf
      Next
      String$=Trim(StringField(String$,2,","))
      Number=100*ValF(StringField(String$,1," "))
      String$=StringField(String$,2," ")
      Total=CountString(String$,",")+1
      For i=1 To Total
        Text$=StringField(String$,i,",")
        ForEach Factions()
          If Factions()\Name\In$=Text$
            Item=ListIndex(Factions())
            Standings(Com,Item)=Number
            Standings(Item,Com)=Number
            Break
          EndIf
        Next
      Next i
    ;Etat de la guerre et des alliances officielles entre les factions
    ElseIf Left(String$,21)="faction_relationships"
      Argument(String$,21)
      Text$=StringField(String$,1,",")
      ForEach Factions()
        If Text$=Factions()\Name\In$
          Com=ListIndex(Factions())
          Break
        EndIf
      Next
      String$=Trim(StringField(String$,2,","))
      If StringField(String$,1," ")="at_war_with"
        Number=-1 : Argument(String$,11)
      ElseIf StringField(String$,1," ")="allied_to"
        Number=1 : Argument(String$,9)
      EndIf
      Total=CountString(String$,",")+1
      For i=1 To Total
        Text$=StringField(String$,i,",")
        ForEach Factions()
          If Factions()\Name\In$=Text$
            Item=ListIndex(Factions())
            Relationships(Com,Item)=Number
            Relationships(Item,Com)=Number
            Break
          EndIf
        Next
      Next i
    ElseIf Left(String$,6)="region"
    ElseIf String$="script"
      Type=10
      Continue
    EndIf
  EndIf
  
  ;- > > Script
  If Type=10
    Campaign\Script$=String$
    ;Le script est considr comme la fin du fichier
    Break
  EndIf
  
Wend

CloseFile(#DescrStrat)

;}

;-Image files
;{

SetGadgetState(#DrawMap,3)
UpdateDrawingFeatures(#Region)

;LoadImage et CreateImage/CopyImage inversent la gestion de la coordonne Y
;On charge donc les images d'une manire spciale pour homogniser la gestion des coordonnes
;Par rapport aux futures images cres
For i=0 To 4
  SetProgress(24+i*2)
  ;Chargement de l'image
  LoadImage(#Generic,Path$+Files(i+#MapClimates))
  ;Copie de l'image charge
  CreateImage(i+#OriClimate,ImageWidth(#Generic),ImageHeight(#Generic),32)
  If StartDrawing(ImageOutput(i+#OriClimate))
    DrawImage(ImageID(#Generic),0,0)
  StopDrawing() : EndIf
  ;Libration de l'image charge
  FreeImage(#Generic)
Next

GetObject_(ImageID(#OriClimate),SizeOf(BITMAP),@OriClimate)
GetObject_(ImageID(#OriGroundType),SizeOf(BITMAP),@OriGroundType)
GetObject_(ImageID(#OriHeight),SizeOf(BITMAP),@OriHeight)
GetObject_(ImageID(#OriRegion),SizeOf(BITMAP),@OriRegion)
GetObject_(ImageID(#OriFeature),SizeOf(BITMAP),@OriFeature)

;********************************************************************************************************
;-Cities and ports

SetProgress(36)

;Cration de l'image des villes et ports
CreateImage(#OriCity,OriRegion\bmWidth,OriRegion\bmHeight,32)
GetObject_(ImageID(#OriCity),SizeOf(BITMAP),@OriCity)

;Boucle parcourant toute la carte
For Y=0 To OriRegion\bmHeight-1
  For X=0 To OriRegion\bmWidth-1
    
    ;Rcupration mmoire de la couleur du point
    Color=PeekL(OriRegion\bmBits+X*4+Y*OriRegion\bmWidthBytes)
    Color=ReverseRGB(Color)
    
    ;C'est une ville
    If Color=#Black
      ;Rcupration de la couleur de la rgion
      Color=SubColor(X,Y)
      ;Effaage du point noir sur la carte
      PokeL(OriRegion\bmBits+X*4+Y*OriRegion\bmWidthBytes,Color)
      PokeL(OriCity\bmBits+X*4+Y*OriCity\bmWidthBytes,#Black)
      ;Recherche de la rgion grce  sa couleur
      ForEach Regions()
        If Regions()\Color=ReverseRGB(Color)
          Regions()\City\X=X
          Regions()\City\Y=Y
          Break
        EndIf
      Next
    ;C'est un port
    ElseIf Color=#White
      ;Mme procdure que ci-dessus
      Color=SubColor(X,Y)
      PokeL(OriRegion\bmBits+X*4+Y*OriRegion\bmWidthBytes,Color)
      PokeL(OriCity\bmBits+X*4+Y*OriCity\bmWidthBytes,#White)
      ForEach Regions()
        If Regions()\Color=ReverseRGB(Color)
          Regions()\Port\X=X
          Regions()\Port\Y=Y
          Break
        EndIf
      Next
    Else
      ;Coloration de l'image en gris
      PokeL(OriCity\bmBits+X*4+Y*OriCity\bmWidthBytes,#Gray)
    EndIf
    
  Next X
  
  SetProgress(36+63*Y/OriRegion\bmHeight)
  
Next Y

;********************************************************************************************************
;-Resource map

CreateImage(#OriResource,OriRegion\bmWidth,OriRegion\bmHeight,32)
GetObject_(ImageID(#OriResource),SizeOf(BITMAP),@OriResource)

ForEach Resources()
  PokeL(OriResource\bmBits+(Resources()\X)*4+(Resources()\Y)*OriResource\bmWidthBytes,$404040)
Next

;********************************************************************************************************
;-Characters' map

CreateImage(#OriArmy,OriRegion\bmWidth,OriRegion\bmHeight,32)
GetObject_(ImageID(#OriArmy),SizeOf(BITMAP),@OriArmy)

ForEach Characters()
  If Not Characters()\Offmap
    PokeL(OriArmy\bmBits+(Characters()\Pos\X)*4+(Characters()\Pos\Y)*OriArmy\bmWidthBytes,#DarkBlue)
  EndIf
Next

SetProgress(100)

;MJ de la barre d'tat
StatusBarText(#Status,0,"")

;}

; IDE Options = PureBasic 4.10 (Windows - x86)
; CursorPosition = 2
; Folding = 9