
Procedure.b SelectRegion(*Address)
  Protected Text$,Item.b,i.b,Total.b,Option.b
  
  If *Address
    ChangeCurrentElement(Regions(),*Address)
    Option=1
  ElseIf SelectedRegion=-1
    Option=2
  Else
    ForEach Regions()
      If Regions()\Color=SelectedRegion
        Option=1
        Break
      EndIf
    Next
  EndIf
  
  Select Option
    Case 0
      Error("La rgion spcifie est introuvable dans la base de donnes.")
      ProcedureReturn #False
    Case 1
      
      ;Mise  jour de la slection
      SelectedRegion=Regions()\Color
      
      ;Champs classiques
      SetGadgetText(#TextRegionIn,Regions()\Province\In$)
      SetGadgetText(#TextRegionOut,Regions()\Province\Out$)
      SetGadgetText(#TextCityIn,Regions()\City\In$)
      SetGadgetText(#TextCityOut,Regions()\City\Out$)
      SetGadgetText(#CoordCityX,Str(Regions()\City\X))
      SetGadgetText(#CoordCityY,Str(Regions()\City\Y))
      SetGadgetText(#CoordPortX,Str(Regions()\Port\X))
      SetGadgetText(#CoordPortY,Str(Regions()\Port\Y))
      SetGadgetState(#VictoryRegion,Regions()\Victory)
      SetGadgetState(#AgricultureRegion,Regions()\Agriculture)
      SetGadgetState(#SpinRed,Red(SelectedRegion))
      SetGadgetState(#SpinGreen,Green(SelectedRegion))
      SetGadgetState(#SpinBlue,Blue(SelectedRegion))
      SetGadgetColor(#ColorContainer,#PB_Gadget_BackColor,SelectedRegion)
      
      ;Gestion des factions
      SetGadgetState(#OriFactionRegion,-1)
      For i=0 To CountGadgetItems(#OriFactionRegion)-1
        ChangeCurrentElement(Factions(),GetGadgetItemData(#OriFactionRegion,i))
        If Factions()\Name\In$=Regions()\OriFaction$
          SetGadgetState(#OriFactionRegion,i)
          Break
        EndIf
      Next i
      SetGadgetState(#FactionRegion,-1)
      For i=0 To CountGadgetItems(#FactionRegion)-1
        ChangeCurrentElement(Factions(),GetGadgetItemData(#FactionRegion,i))
        If Factions()\Name\In$=Regions()\Faction$
          SetGadgetState(#FactionRegion,i)
          Break
        EndIf
      Next i
      
      ;Gestion des rebelles
      For i=0 To CountGadgetItems(#RebelsRegion)-1
        ChangeCurrentElement(RebelFactions(),GetGadgetItemData(#RebelsRegion,i))
        If RebelFactions()\In$=Regions()\Rebels$
          SetGadgetState(#RebelsRegion,i)
          Break
        EndIf
      Next i
      
      ;Gestion des mercenaires
      If Regions()\Pool$=""
        SetGadgetState(#MercRegion,0)
      Else
        For i=0 To CountGadgetItems(#MercRegion)-1
          If Regions()\Pool$=GetGadgetItemText(#MercRegion,i)
            SetGadgetState(#MercRegion,i)
            Break
          EndIf
        Next i
      EndIf
      
      ;Gestion de la musique
      If Regions()\Music$=""
        SetGadgetState(#MusicRegion,-1)
      Else
        For i=0 To CountGadgetItems(#MusicRegion)-1
          If Regions()\Music$=GetGadgetItemText(#MusicRegion,i)
            SetGadgetState(#MusicRegion,i)
            Break
          EndIf
        Next i
      EndIf
      
      ;Zone de dessin
      If GetGadgetState(#DrawMap)=3
        SetGadgetState(#DrawElement,4)
        DrawColor=SelectedRegion
        SetGadgetText(#DrawRed,Str(Red(DrawColor)))
        SetGadgetText(#DrawGreen,Str(Green(DrawColor)))
        SetGadgetText(#DrawBlue,Str(Blue(DrawColor)))
        SetGadgetColor(#DrawColor,#PB_Gadget_BackColor,DrawColor)
      EndIf
      
      ;Nombre d'habitants et niveau de la communaut
      SetGadgetState(#TownSize,Regions()\City\Population)
      SetGadgetState(#TownLevel,Regions()\City\Level)
      If Regions()\City\Castle
        SetGadgetText(#Castle,"Chteau")
      Else
        SetGadgetText(#Castle,"Ville")
      EndIf
      
      ;Gestion des btiments
      Text$=Regions()\City\Buildings$ ;Liste des btiments dans une chane
      ClearGadgetItemList(#ListBuildings) ;Initialisation de la liste
      If Text$<>""
        Item=CountString(Text$,Chr(9))+1 ;Nombre de btiments
        For i=1 To Item ;Ajout des lments
          AddGadgetItem(#ListBuildings,-1,Trim(StringField(Text$,i,Chr(9))))
        Next i
      EndIf
      
      ;Gestion des ressources
      SetGadgetText(#ResourcesRegion,"")
      Text$=Regions()\Resources$ ;Liste des ressources dans une chane
      ClearGadgetItemList(#ListResources) ;Initialisation de la liste
      If Text$<>"none" ;Aucun lment s'il n'y a pas de ressource
        Item=CountString(Text$,",")+1 ;Nombre de ressources
        For i=1 To Item ;Ajout des lments
          AddGadgetItem(#ListResources,-1,Trim(StringField(Text$,i,",")))
        Next
      EndIf
      
      ;Gestion des religions
      For i=0 To CountList(Religions())-1
        SetGadgetState(#SpinA+i*2,Regions()\Religions[i])
        Total+Regions()\Religions[i]
      Next
      If Total=100 : SetGadgetColor(#TotalReligion,#PB_Gadget_FrontColor,#Black) : Else : SetGadgetColor(#TotalReligion,#PB_Gadget_FrontColor,#Rouge) : EndIf
      SetGadgetText(#TotalReligion,Str(Total))
      
      ;Boutons valides
      DisableGadget(#Unselect,0)
      DisableGadget(#Validate,0)
      DisableGadget(#Suppr,0)
      DisableGadget(#BuildingsAdd,0)
      DisableGadget(#BuildingsSuppr,0)
      DisableGadget(#ResourcesAdd,0)
      DisableGadget(#ResourcesSuppr,0)
      DisableGadget(#Up,0)
      DisableGadget(#Down,0)
      DisableGadget(#Castle,0)
      
      ;Mise  jour des cartes
      ResizeWorld()
      
    Case 2
      ;Mise  jour de la dslection, voire la la procdure de slection ci-dessus pour les dtails
      SelectedRegion=-1
      SetGadgetState(#ListRegion,-1)
      SetGadgetText(#TextRegionIn,"")
      SetGadgetText(#TextRegionOut,"")
      SetGadgetText(#TextCityIn,"")
      SetGadgetText(#TextCityOut,"")
      SetGadgetText(#CoordCityX,"0")
      SetGadgetText(#CoordCityY,"0")
      SetGadgetText(#CoordPortX,"0")
      SetGadgetText(#CoordPortY,"0")
      SetGadgetState(#VictoryRegion,0)
      SetGadgetState(#AgricultureRegion,0)
      SetGadgetState(#SpinRed,0)
      SetGadgetState(#SpinGreen,0)
      SetGadgetState(#SpinBlue,0)
      SetGadgetColor(#ColorContainer,#PB_Gadget_BackColor,0)
      SetGadgetState(#OriFactionRegion,-1)
      SetGadgetState(#FactionRegion,-1)
      SetGadgetState(#RebelsRegion,-1)
      SetGadgetState(#MercRegion,0)
      SetGadgetState(#MusicRegion,-1)
      SetGadgetState(#TownSize,400)
      SetGadgetState(#TownLevel,-1)
      SetGadgetText(#Castle,"(Aucun)")
      ClearGadgetItemList(#ListBuildings)
      ClearGadgetItemList(#ListResources)
      For i=0 To CountList(Religions())-1
        SetGadgetState(#SpinA+i*2,0)
      Next
      DisableGadget(#Unselect,1)
      DisableGadget(#Validate,1)
      DisableGadget(#Suppr,1)
      DisableGadget(#BuildingsAdd,1)
      DisableGadget(#BuildingsSuppr,1)
      DisableGadget(#ResourcesAdd,1)
      DisableGadget(#ResourcesSuppr,1)
      DisableGadget(#Up,1)
      DisableGadget(#Down,1)
      DisableGadget(#Castle,1)
      
  EndSelect
  
  SetGadgetState(#CoordCityButton,0)
  SetGadgetState(#CoordPortButton,0)
  SetGadgetState(#DrawButton,0)
  SetGadgetState(#DrawFill,0)
  SetGadgetState(#DrawSample,0)
  Cursor=#MouseArrow
  
  ProcedureReturn #True
  
EndProcedure

Procedure.b UpdateRegion(Option.b)
  Protected Quit.b,*Address,Text$,Number.b,i.b,State.w
  
  If Option<1 And SelectedRegion=-1
    Error("Aucune rgion n'est slectionne !")
    ProcedureReturn #False
  EndIf
  
  Select Option
    ;Suppression d'une rgion
    Case -1
      ;Il doit toujours y avoir au moins une rgion !!!
      If CountList(Regions())=1 : Error("Vous ne pouvez pas supprimer la dernire rgion !") : ProcedureReturn #False : EndIf
      ;Recherche de la rgion
      ForEach Regions() : If Regions()\Color=SelectedRegion : Quit=1 : Break : EndIf : Next
      If Not Quit : FatalError("La rgion slectionne est introuvable, suppression impossible !") : Else : Quit=0 : EndIf
      ;Suppression de la ville et du port
      PokeL(OriCity\bmBits+(Regions()\City\X)*4+(Regions()\City\Y)*OriCity\bmWidthBytes,#Gray)
      PokeL(OriCity\bmBits+(Regions()\Port\X)*4+(Regions()\Port\Y)*OriCity\bmWidthBytes,#Gray)
      DeleteElement(Regions(),1)
      ;Coloriage de toutes les zones de l'ancienne couleur SelectedRegion
      ;Avec celle de la nouvelle rgion courante
      ChangeColor(-Regions()\Color)
      ;Mise  jour de la liste
      State=GetGadgetState(#ListRegion)
      RemoveGadgetItem(#ListRegion,State)
      State-1 : SetGadgetState(#ListRegion,State)
      If GetGadgetState(#ListRegion)=-1 : State+1 : SetGadgetState(#ListRegion,State) : EndIf
      ;Slection de la nouvelle rgion fusionne, mise  jour de la variable SelectedRegion
      SelectRegion(GetGadgetItemData(#ListRegion,State))
      
    ;Mise  jour des donnes d'une rgion
    Case 0
      ;Recherche de la rgion
      ForEach Regions() : If Regions()\Color=SelectedRegion : Quit=1 : Break : EndIf : Next
      If Not Quit : FatalError("La rgion slectionne est introuvable, mise  jour impossible !") : Else : Quit=0 : EndIf
      *Address=@Regions()
      ;Identifiants internes
      Text$=GetGadgetText(#TextRegionIn)
      ForEach Regions()
        If *Address<>@Regions() : If Regions()\Province\In$=Text$ : Quit=1 : Break : EndIf : EndIf
      Next
      If Quit : Error("L'identifiant "+Text$+" est dj attribu  une autre rgion !") : ProcedureReturn #False : EndIf
      Text$=GetGadgetText(#TextCityIn)
      ForEach Regions()
        If *Address<>@Regions() : If Regions()\City\In$=Text$ : Quit=1 : Break : EndIf : EndIf
      Next
      If Quit : Error("L'identifiant "+Text$+" est dj attribu  une autre ville !") : ProcedureReturn #False : EndIf
      ;Noms externes
      Text$=GetGadgetText(#TextRegionOut)
      ForEach Regions()
        If *Address<>@Regions() : If Regions()\Province\Out$=Text$ : Quit=1 : Break : EndIf : EndIf
      Next
      If Quit : Error("Une autre rgion s'appelle dj '"+Text$+"' !") : ProcedureReturn #False : EndIf
      Text$=GetGadgetText(#TextCityOut)
      ForEach Regions()
        If *Address<>@Regions() : If Regions()\City\Out$=Text$ : Quit=1 : Break : EndIf : EndIf
      Next
      If Quit : Error("Une autre ville s'appelle dj '"+Text$+"' !") : ProcedureReturn #False : EndIf
      
      ;Mise  jour effective
      ChangeCurrentElement(Regions(),*Address)
      Regions()\Province\In$=GetGadgetText(#TextRegionIn)
      Regions()\City\In$=GetGadgetText(#TextCityIn)
      Regions()\City\Out$=GetGadgetText(#TextCityOut)
      Regions()\Province\Out$=GetGadgetText(#TextRegionOut)
      State=GetGadgetState(#ListRegion)
      SetGadgetItemText(#ListRegion,State,Regions()\Province\Out$)
      SetGadgetState(#ListRegion,State)
      ;Champs classiques
      Regions()\Victory=GetGadgetState(#VictoryRegion)
      Regions()\Agriculture=GetGadgetState(#AgricultureRegion)
      ;Gestion des factions
      ChangeCurrentElement(Factions(),GetGadgetItemData(#OriFactionRegion,GetGadgetState(#OriFactionRegion)))
      Regions()\OriFaction$=Factions()\Name\In$
      ChangeCurrentElement(Factions(),GetGadgetItemData(#FactionRegion,GetGadgetState(#FactionRegion)))
      Regions()\Faction$=Factions()\Name\In$
      ;Gestion des rebelles
      ChangeCurrentElement(RebelFactions(),GetGadgetItemData(#RebelsRegion,GetGadgetState(#RebelsRegion)))
      Regions()\Rebels$=RebelFactions()\In$
      ;Gestion des mercenaires
      Text$=GetGadgetText(#MercRegion)
      If Text$="(Aucun)" : Regions()\Pool$="" : Else : Regions()\Pool$=Text$ : EndIf
      ;Gestion de la musique
      Regions()\Music$=GetGadgetText(#MusicRegion)
      ;Nombre d'habitants et niveau de la communaut
      Regions()\City\Population=GetGadgetState(#TownSize)
      Regions()\City\Level=GetGadgetState(#TownLevel)
      Text$=GetGadgetText(#Castle)
      If Text$="Chteau"
        Regions()\City\Castle=1
      ElseIf Text$="Ville"
        Regions()\City\Castle=0
      EndIf
      ;Gestion des btiments
      Number=CountGadgetItems(#ListBuildings)
      If Number=0 : Text$="" : Else : Text$=GetGadgetItemText(#ListBuildings,0)
        For i=1 To Number-1
          Text$+Chr(9)+GetGadgetItemText(#ListBuildings,i)
        Next i
      EndIf
      Regions()\City\Buildings$=Text$
      ;Gestion des ressources
      Number=CountGadgetItems(#ListResources)
      If Number=0 : Text$="none" : Else : Text$=GetGadgetItemText(#ListResources,0)
        For i=1 To Number-1
          Text$+", "+GetGadgetItemText(#ListResources,i)
        Next i
      EndIf
      Regions()\Resources$=Text$
      ;Gestion des religions
      For i=0 To CountList(Religions())-1
        Regions()\Religions[i]=GetGadgetState(#SpinA+i*2)
      Next
      MessageRequester("Information","Mise  jour effectue avec succs !")
      ProcedureReturn #True
      
    ;Rajout d'une rgion
    Case 1
      ;Recherche des nouvelles rgions qui doivent tre finies avant un nouvel ajout
      ForEach Regions()
        If Regions()\Province\In$="New_Province" Or Regions()\Province\Out$="Nouvelle rgion" Or Regions()\City\In$="New_City" Or Regions()\City\Out$="Nouvelle ville"
          Error("Vous devez ajouter les nouvelles rgions unes par unes !") : ProcedureReturn #False
        EndIf
      Next
      ;Nouvelle couleur
      SelectedRegion=ChangeColor(0)
      AddElement(Regions())
      Regions()\Color=SelectedRegion
      Regions()\Province\In$="New_Province"
      Regions()\Province\Out$="Nouvelle rgion"
      Regions()\City\In$="New_City"
      Regions()\City\Out$="Nouvelle ville"
      Regions()\Agriculture=1
      Regions()\Victory=5
      Regions()\City\Population=400
      Regions()\Resources$="none"
      FirstElement(RebelFactions()) : Regions()\Rebels$=RebelFactions()\In$
      FirstElement(Factions()) : Regions()\OriFaction$=Factions()\Name\In$ : Regions()\Faction$=Factions()\Name\In$
      Regions()\Music$=GetGadgetItemText(#MusicRegion,0)
      Regions()\Religions[0]=100
      AddGadgetItem(#ListRegion,-1,"Nouvelle rgion")
      SetGadgetState(#ListRegion,CountGadgetItems(#ListRegion)-1)
      SetGadgetItemData(#ListRegion,CountGadgetItems(#ListRegion)-1,@Regions())
      SelectRegion(@Regions())
      
      ;Pour dessiner la nouvelle rgion
      SetGadgetState(#DrawButton,1)
      Cursor=#MousePoint
      
  EndSelect
  
  ProcedureReturn #True
  
EndProcedure

; IDE Options = PureBasic 4.10 (Windows - x86)
; Folding = 9