
Procedure SaveRegion()
  Protected i.b,j.b,Type.b,Color.l,String$,Tab$,Music$,Length.w,*Address,*Religion
  Protected X.l,Y.l
  Protected Dim Eval.eval(CountList(Factions())-1)
  
  ;Apparence, bar de progression, etc.
  Progress("Sauvegarde...")
  
  SetProgress(1)
  
  ;Suppression des fichiers d'origine
  DeleteFile(Path$+"data\world\maps\base\map_heights.hgt")
  DeleteFile(Path$+"data\world\maps\base\map.rwm")
  
  ;********************************************************************************************************
  ;-Regions
  ;********************************************************************************************************
  
  ;Sauvegarde des rgions (fichiers principaux)
  
  ;Cration des fichiers
  CreateFile(#DescrRegions,Path$+Files(#DescrRegions))
  CreateFile(#Regions,Path$+Files(#Regions))
  
  ;Entte du fichier descr_regions.txt
  String$=Space(100) : ReplaceString(String$," ",";",2)
  WriteStringN(#DescrRegions,String$)
  WriteStringN(#DescrRegions,";")
  WriteStringN(#DescrRegions,"; Regions list"+#Tag$)
  WriteStringN(#DescrRegions,";")
  WriteStringN(#DescrRegions,String$)
  
  ;Entte du fichier binaire
  WriteWord(#Regions,2)
  WriteWord(#Regions,2048)
  WriteWord(#Regions,CountList(Regions())*2)
  WriteWord(#Regions,0)
  
  ;Boucle principale
  ForEach Regions()
    
    ;Ecriture d'un paragraphe sur descr_regions.txt
    WriteStringN(#DescrRegions,Regions()\Province\In$)
    WriteStringN(#DescrRegions,Chr(9)+Regions()\City\In$)
    WriteStringN(#DescrRegions,Chr(9)+Regions()\OriFaction$)
    WriteStringN(#DescrRegions,Chr(9)+Regions()\Rebels$)
    Color=Regions()\Color
    WriteStringN(#DescrRegions,Chr(9)+Str(Red(Color))+" "+Str(Green(Color))+" "+Str(Blue(Color)))
    WriteStringN(#DescrRegions,Chr(9)+Regions()\Resources$)
    WriteStringN(#DescrRegions,Chr(9)+Str(Regions()\Victory))
    WriteStringN(#DescrRegions,Chr(9)+Str(Regions()\Agriculture))
    
    ;Ecriture de la ligne de religion
    Type=0
    String$="religions {"
    ForEach Religions()
      String$+" "+Religions()\In$+" "+Str(Regions()\Religions[Type])
      Type+1
    Next
    String$+" }"
    WriteStringN(#DescrRegions,Chr(9)+String$)
    
    ;Ecriture des noms internes puis externes
    For Type=0 To 3
      Select Type
        Case 0 : String$=Regions()\Province\In$
        Case 1 : String$=Regions()\Province\Out$
        Case 2 : String$=Regions()\City\In$
        Case 3 : String$=Regions()\City\Out$
      EndSelect
      Length=Len(String$)*2
      *Address=@String$
      WriteWord(#Regions,Length/2)
      WriteData(#Regions,*Address,Length)
    Next Type
    
  Next
  
  ;Zro de fin du fichier binaire
  WriteWord(#Regions,0)
  
  ;Fermeture des fichiers
  CloseFile(#DescrRegions)
  CloseFile(#Regions)
  
  SetProgress(3)
  
  ;********************************************************************************************************
  ;-Image files
  ;********************************************************************************************************
  
  ;Sauvegarde des fichiers TGA
  
  ;Cration de l'image des rgions  sauvegarder
  CreateImage(#OriGeneric,OriRegion\bmWidth,OriRegion\bmHeight,32)
  
  ;Adresse de l'image des villes et des ports
  GetObject_(ImageID(#OriGeneric),SizeOf(BITMAP),@OriGeneric)
  
  ;Dessin des rgions
  If StartDrawing(ImageOutput(#OriGeneric))
    DrawImage(ImageID(#OriRegion),0,0)
  StopDrawing() : EndIf
  
  ;Dessin des villes et des ports
  For Y=0 To OriCity\bmHeight-1
    For X=0 To OriCity\bmWidth-1
      ;Couleur du pixel
      Color=PeekL(OriCity\bmBits+X*4+Y*OriCity\bmWidthBytes)
      ;S'il n'est pas gris, on dessine la ville ou le port
      If Color<>#Gray
        PokeL(OriGeneric\bmBits+X*4+Y*OriGeneric\bmWidthBytes,Color)
      EndIf
    Next X
  Next Y
  
  ;Sauvegarde de l'image
  SaveTGA(#OriGeneric,Path$+Files(#MapRegions),3,14) ;map_regions.tga
  ;Libration de l'image
  FreeImage(#OriGeneric)
  
  SetProgress(14)
  
  ;Sauvegarde des autres images
  SaveTGA(#OriClimate,Path$+Files(#MapClimates),14,40) ;map_climates.tga
  SaveTGA(#OriGroundType,Path$+Files(#MapGroundTypes),40,66) ;map_ground_types.tga
  SaveTGA(#OriHeight,Path$+Files(#MapHeights),66,91) ;map_heights.tga
  SaveTGA(#OriFeature,Path$+Files(#MapFeatures),91,97) ;map_features.tga
  
  ;********************************************************************************************************
  ;-Mercenaries
  ;********************************************************************************************************
  
  ;Le fichier des mercenaires
  
  CreateFile(#DescrMercenaries,Path$+Files(#DescrMercenaries))
  
  String$=Space(100) : ReplaceString(String$," ",";",2)
  WriteStringN(#DescrMercenaries,String$)
  WriteStringN(#DescrMercenaries,";")
  WriteStringN(#DescrMercenaries,"; Mercenary pools"+#Tag$)
  WriteStringN(#DescrMercenaries,";")
  WriteStringN(#DescrMercenaries,String$)
  WriteStringN(#DescrMercenaries,"")
  
  ForEach Mercenaries()
    Type=0
    ForEach Regions()
      If Regions()\Pool$=Mercenaries()\Pool$
        Type=1
        Break
      EndIf
    Next
    ;On vrifie qu'il y a bien au moins une rgion correspondant
    ; ce pool de mercenaires sinon on supprime le pool
    If Type
      ;Le pool de mercenaires
      WriteStringN(#DescrMercenaries,"pool "+Mercenaries()\Pool$)
      String$=Chr(9)+"regions"
      ;Les rgions du pool
      ForEach Regions()
        If Regions()\Pool$=Mercenaries()\Pool$
          String$+" "+Regions()\Province\In$
        EndIf
      Next
      WriteStringN(#DescrMercenaries,String$)
      ;Les units mercenaires
      For i=1 To CountString(Mercenaries()\Units$,Chr(9))+1
        String$=StringField(Mercenaries()\Units$,i,Chr(9))
        Tab((42-Len(String$))/8)
        WriteStringN(#DescrMercenaries,Chr(9)+"unit "+String$+Tab$+StringField(Mercenaries()\Features$,i,Chr(9)))
      Next i
      WriteStringN(#DescrMercenaries,"")
    EndIf
  Next
  
  CloseFile(#DescrMercenaries)
  
  SetProgress(98)
  
  ;********************************************************************************************************
  ;-Factions
  ;********************************************************************************************************
  
  CreateFile(#DescrSmFactions,Path$+Files(#DescrSmFactions))
  
  String$=Space(100) : ReplaceString(String$," ",";",2)
  WriteStringN(#DescrSmFactions,String$)
  WriteStringN(#DescrSmFactions,";")
  WriteStringN(#DescrSmFactions,"; Factions list"+#Tag$)
  WriteStringN(#DescrSmFactions,";")
  WriteStringN(#DescrSmFactions,String$)
  WriteStringN(#DescrSmFactions,"")
  
  ForEach Factions()
    
    ;Gnralits
    Tab(6) : String$="faction"+Tab$+Factions()\Name\In$
    If Factions()\Spawned$<>""
      String$+", "+Factions()\Spawned$
      If Factions()\Shadow$<>""
        String$+" "+Factions()\Shadow$
      EndIf
    EndIf
    WriteStringN(#DescrSmFactions,String$)
    WriteStringN(#DescrSmFactions,"culture"+Tab$+Factions()\Culture$)
    Tab(5) : WriteStringN(#DescrSmFactions,"religion"+Tab$+Factions()\Religion\In$)
    
    ;Type spcial de faction
    If Factions()\SpecialType$<>"" : Tab(4) : WriteStringN(#DescrSmFactions,"special_faction_type"+Tab$+Factions()\SpecialType$) : EndIf
    
    ;Donnes caches 1
    Tab(6) : WriteStringN(#DescrSmFactions,"symbol"+Tab$+Factions()\Hidden\Symbol$)
    Tab(5) : WriteStringN(#DescrSmFactions,"rebel_symbol"+Tab$+Factions()\Hidden\Rebel$)
    
    ;Couleurs
    String$="red "+Str(Red(Factions()\Color1))+", green "+Str(Green(Factions()\Color1))+", blue "+Str(Blue(Factions()\Color1))
    WriteStringN(#DescrSmFactions,"primary_colour"+Tab$+String$)
    String$="red "+Str(Red(Factions()\Color2))+", green "+Str(Green(Factions()\Color2))+", blue "+Str(Blue(Factions()\Color2))
    Tab(4) : WriteStringN(#DescrSmFactions,"secondary_colour"+Tab$+String$)
    
    ;Donnes caches 2
    Tab(5) : WriteStringN(#DescrSmFactions,"loading_logo"+Tab$+Factions()\Hidden\Loading$)
    WriteStringN(#DescrSmFactions,"standard_index"+Tab$+Str(Factions()\Hidden\Standard))
    WriteStringN(#DescrSmFactions,"logo_index"+Tab$+Factions()\Hidden\Logo$)
    Tab(4) : WriteStringN(#DescrSmFactions,"small_logo_index"+Tab$+Factions()\Hidden\SmallLogo$)
    Tab(5) : WriteStringN(#DescrSmFactions,"triumph_value"+Tab$+Str(Factions()\Hidden\Triumph))
    
    ;Caractristiques 1
    Tab(3) : ValToString(Factions()\Custom,String$) : WriteStringN(#DescrSmFactions,"custom_battle_availability"+Tab$+String$)
    
    ;Hordes
    If Factions()\Horde\Disband[0]>-1
      Tab(5) : WriteStringN(#DescrSmFactions,"horde_min_units"+Tab$+Str(Factions()\Horde\MinUnits))
      WriteStringN(#DescrSmFactions,"horde_max_units"+Tab$+Str(Factions()\Horde\MaxUnits))
      Tab(2) : WriteStringN(#DescrSmFactions,"horde_max_units_reduction_every_horde"+Tab$+Str(Factions()\Horde\Reduction))
      WriteStringN(#DescrSmFactions,"horde_unit_per_settlement_population"+Tab$+Str(Factions()\Horde\Population))
      Tab(3) : WriteStringN(#DescrSmFactions,"horde_max_percent_army_stack"+Tab$+Str(Factions()\Horde\Army))
      Tab(1)
      For Type=0 To 9
        If Factions()\Horde\Disband[Type]>-1
          WriteStringN(#DescrSmFactions,"horde_disband_percent_on_settlement_capture"+Tab$+Str(Factions()\Horde\Disband[Type]))
        Else
          Break
        EndIf
      Next Type
      Tab(5)
      For Type=1 To CountString(Factions()\Horde\Units$,Chr(9))+1
        WriteStringN(#DescrSmFactions,"horde_unit"+Tab$+StringField(Factions()\Horde\Units$,Type,Chr(9)))
      Next
    EndIf
    
    ;Caractristiques 2
    Tab(6) : ValToString(Factions()\Sap,String$) : WriteStringN(#DescrSmFactions,"can_sap"+Tab$+String$)
    Tab(4) : ValToString(Factions()\Naval,String$) : WriteStringN(#DescrSmFactions,"prefers_naval_invasions"+Tab$+String$)
    ValToString(Factions()\Princess,String$) : WriteStringN(#DescrSmFactions,"can_have_princess"+Tab$+String$)
    Tab(5) : ValToString(Factions()\Family,String$) : WriteStringN(#DescrSmFactions,"has_family_tree"+Tab$+String$)
    
    ;Caractristiques 3 (spcifique de Kingdoms)
    If Factions()\Plague>-1 : Tab(4) : ValToString(Factions()\Plague,String$) : WriteStringN(#DescrSmFactions,"can_transmit_plague"+Tab$+String$) : EndIf
    If Factions()\Disband>-1 : ValToString(Factions()\Disband,String$) : WriteStringN(#DescrSmFactions,"disband_to_pools"+Tab$+String$) : EndIf
    If Factions()\Tower>-1 : ValToString(Factions()\Tower,String$) : WriteStringN(#DescrSmFactions,"can_build_siege_towers"+Tab$+String$) : EndIf
    
    ;Sparateur
    String$=Space(100) : ReplaceString(String$," ",";",2)
    WriteStringN(#DescrSmFactions,"")
    WriteStringN(#DescrSmFactions,String$)
    WriteStringN(#DescrSmFactions,"")
    
  Next
  
  CloseFile(#DescrSmFactions)
  
  SetProgress(99)
  
  ;********************************************************************************************************
  ;-Musics
  ;********************************************************************************************************
  
  CreateFile(#DescrSoundsMusicTypes,Path$+Files(#DescrSoundsMusicTypes))
  
  String$=Space(100) : ReplaceString(String$," ",";",2)
  WriteStringN(#DescrSoundsMusicTypes,String$)
  WriteStringN(#DescrSoundsMusicTypes,";")
  WriteStringN(#DescrSoundsMusicTypes,"; Sounds and music types"+#Tag$)
  WriteStringN(#DescrSoundsMusicTypes,";")
  WriteString(#DescrSoundsMusicTypes,String$)
  
  For i=0 To CountGadgetItems(#MusicRegion)-1
    Music$=GetGadgetItemText(#MusicRegion,i)
    WriteStringN(#DescrSoundsMusicTypes,#CRLF$+#CRLF$+"music_type "+Music$)
    
    Type=0
    ForEach Regions()
      If Regions()\Music$=Music$
        If Type=0
          WriteString(#DescrSoundsMusicTypes,#CRLF$+"regions "+Regions()\Province\In$)
          Type+1
        ElseIf Type<4
          WriteString(#DescrSoundsMusicTypes," "+Regions()\Province\In$)
          Type+1
        Else
          WriteString(#DescrSoundsMusicTypes," "+Regions()\Province\In$)
          Type=0
        EndIf
      EndIf
    Next
    
    Type=0
    ForEach Factions()
      If Factions()\Music$=Music$
        If Type=0
          WriteString(#DescrSoundsMusicTypes,#CRLF$+#CRLF$+"factions "+Factions()\Name\In$)
          Type+1
        Else
          WriteString(#DescrSoundsMusicTypes," "+Factions()\Name\In$)
        EndIf
      EndIf
    Next
    
    WriteString(#DescrSoundsMusicTypes,"")
  Next i
  
  CloseFile(#DescrSoundsMusicTypes)
  
  ;********************************************************************************************************
  ;-Victory conditions
  ;********************************************************************************************************
  
  CreateFile(#DescrWinConditions,Path$+Files(#DescrWinConditions))
  
  ForEach Factions()
    ;Seulement si la faction est jouable ou dbloquable
    If Factions()\Status\Playable=1 Or Factions()\Status\Playable=2
      ;Conditions de victoire longues
      WriteStringN(#DescrWinConditions,Factions()\Name\In$)
      String$="hold_regions"
      If Factions()\Long\Hold$<>""
        For i=1 To CountString(Factions()\Long\Hold$,Chr(9))+2
          String$+" "+StringField(StringField(Factions()\Long\Hold$,i,Chr(9)),1,",")
          If Val(StringField(StringField(Factions()\Long\Hold$,i,Chr(9)),2,","))>0
            String$+" "+StringField(StringField(Factions()\Long\Hold$,i,Chr(9)),2,",")
          EndIf
        Next i
      EndIf
      WriteStringN(#DescrWinConditions,String$)
      WriteStringN(#DescrWinConditions,"take_regions "+Str(Factions()\Long\Take))
      If Factions()\Long\Outlive$<>"" : WriteStringN(#DescrWinConditions,"outlive "+Factions()\Long\Outlive$) : EndIf
      ;Conditions de victoire courtes
      WriteString(#DescrWinConditions,"short_campaign ")
      String$="hold_regions"
      If Factions()\Short\Hold$<>""
        For i=1 To CountString(Factions()\Short\Hold$,Chr(9))+2
          String$+" "+StringField(StringField(Factions()\Short\Hold$,i,Chr(9)),1,",")
          If Val(StringField(StringField(Factions()\Short\Hold$,i,Chr(9)),2,","))>0
            String$+" "+StringField(StringField(Factions()\Short\Hold$,i,Chr(9)),2,",")
          EndIf
        Next i
      EndIf
      WriteStringN(#DescrWinConditions,String$)
      WriteStringN(#DescrWinConditions,"take_regions "+Str(Factions()\Short\Take))
      If Factions()\Short\Outlive$<>"" : WriteStringN(#DescrWinConditions,"outlive "+Factions()\Short\Outlive$) : EndIf
      WriteStringN(#DescrWinConditions,"")
    EndIf
  Next
  
  CloseFile(#DescrWinConditions)
  
  ;********************************************************************************************************
  ;-Campaign
  ;********************************************************************************************************
  
  CreateFile(#DescrStrat,Path$+Files(#DescrStrat))
  
  WriteStringN(#DescrStrat,"; Campaign file"+#Tag$+#CRLF$)
  WriteStringN(#DescrStrat,"campaign"+Chr(9)+Chr(9)+"imperial_campaign")
  Tab(1)
  
  ;Jouabilit des factions
  For Type=1 To 3
    If Type=1 : WriteStringN(#DescrStrat,"playable")
    ElseIf Type=2 : WriteStringN(#DescrStrat,"unlockable")
    ElseIf Type=3 : WriteStringN(#DescrStrat,"nonplayable") : EndIf
    ForEach Factions()
      If Factions()\Status\Playable=Type
        WriteStringN(#DescrStrat,Tab$+Factions()\Name\In$)
      EndIf
    Next
    WriteStringN(#DescrStrat,"end")
  Next Type
  
  ;Dates
  WriteStringN(#DescrStrat,#CRLF$)
  WriteStringN(#DescrStrat,"start_date"+Tab$+Str(Campaign\StartDate\Year)+" "+Campaign\StartDate\Season$)
  WriteStringN(#DescrStrat,"end_date"+Tab$+Str(Campaign\EndDate\Year)+" "+Campaign\EndDate\Season$)
  WriteStringN(#DescrStrat,"timescale"+Tab$+StrF(Campaign\TimeScale,2))
  WriteStringN(#DescrStrat,#CRLF$)
  
  ;Options
  For Type=1 To CountString(Campaign\Options$,Chr(9))+1
    WriteStringN(#DescrStrat,StringField(Campaign\Options$,Type,Chr(9)))
  Next Type
  WriteStringN(#DescrStrat,"brigand_spawn_value "+Str(Campaign\Brigand))
  WriteStringN(#DescrStrat,"pirate_spawn_value "+Str(Campaign\Pirate))
  If Campaign\Upkeep>-1
    WriteStringN(#DescrStrat,"free_upkeep_forts "+Str(Campaign\Upkeep))
  EndIf
  
  ;Ressources
  WriteStringN(#DescrStrat,#CRLF$+ReplaceString(Space(165)," ",";",2))
  WriteStringN(#DescrStrat,"; >>>> start of resources section <<<<")
  
  ForEach Regions()
    Type=1
    ForEach Resources()
      Color=PeekL(OriRegion\bmBits+(Resources()\X)*4+(Resources()\Y)*OriRegion\bmWidthBytes)
      If ReverseRGB(Color)=Regions()\Color
        If Type
          WriteStringN(#DescrStrat,#CRLF$+";"+Regions()\Province\In$) : Type=0
        EndIf
        WriteStringN(#DescrStrat,"resource"+Tab$+Resources()\Name$+","+Tab$+Str(Resources()\X)+","+Tab$+Str(Resources()\Y))
      EndIf
    Next
  Next
  
  ;Factions
  WriteStringN(#DescrStrat,#CRLF$+ReplaceString(Space(165)," ",";",2))
  WriteStringN(#DescrStrat,"; >>>> start of factions section <<<<")
  
  ForEach Factions()
    If Factions()\Status\Playable>0
      Tab(1)
      WriteStringN(#DescrStrat,#CRLF$+"faction"+Tab$+Factions()\Name\In$+", "+Factions()\Status\EconomicAI$+" "+Factions()\Status\MilitaryAI$)
      WriteStringN(#DescrStrat,"ai_label"+Tab$+Tab$+Factions()\Status\LabelAI$)
      If Factions()\Status\Undiscovered : WriteStringN(#DescrStrat,"undiscovered") : EndIf
      If Factions()\Status\Spawning=1 : WriteStringN(#DescrStrat,"dead_until_resurrected") : EndIf
      If Factions()\Status\Spawning=2 : WriteStringN(#DescrStrat,"dead_until_emerged") : EndIf
      If Factions()\Status\Reemergent : WriteStringN(#DescrStrat,"re_emergent") : EndIf
      WriteStringN(#DescrStrat,"denari"+Tab$+Str(Factions()\Status\Money))
      WriteStringN(#DescrStrat,"denari_kings_purse"+Tab$+Str(Factions()\Status\KingsPurse))
      Tab(1)
      ;Les communauts de cette faction
      ForEach Regions()
        If Regions()\Faction$=Factions()\Name\In$
          WriteString(#DescrStrat,"settlement")
          If Regions()\City\Castle : WriteString(#DescrStrat," castle") : EndIf
          WriteStringN(#DescrStrat,"")
          WriteStringN(#DescrStrat,"{")
          LevelToString(Regions()\City\Level,String$)
          WriteStringN(#DescrStrat,Tab$+"level "+String$)
          WriteStringN(#DescrStrat,Tab$+"region "+Regions()\Province\In$+#CRLF$)
          WriteStringN(#DescrStrat,Tab$+"year_founded 0")
          WriteStringN(#DescrStrat,Tab$+"population "+Str(Regions()\City\Population))
          WriteStringN(#DescrStrat,Tab$+"plan_set default_set")
          WriteStringN(#DescrStrat,Tab$+"faction_creator "+Regions()\OriFaction$)
          If Regions()\City\Buildings$<>""
            For Type=1 To CountString(Regions()\City\Buildings$,Tab$)+1
              WriteStringN(#DescrStrat,Tab$+"building")
              WriteStringN(#DescrStrat,Tab$+"{")
              WriteStringN(#DescrStrat,Tab$+Tab$+"type "+StringField(Regions()\City\Buildings$,Type,Tab$))
              WriteStringN(#DescrStrat,Tab$+"}")
            Next Type
          EndIf
          WriteStringN(#DescrStrat,"}"+#CRLF$)
        EndIf
      Next
      ;character, tous les personnages prsents sur la carte de campagne et appartenant  cette faction
      ForEach Characters()
        If Characters()\Faction$=Factions()\Name\In$ And Not Characters()\Offmap
          ;Caractristiques principales du personnages
          CharToString(Characters()\Type,String$)
          If Characters()\Faction$="slave"
            String$="character"+Chr(9)+"sub_faction "+Characters()\SubFaction$+", "+Characters()\Name$+", "+String$
          Else
            String$="character"+Chr(9)+Characters()\Name$+", "+String$
          EndIf
          ;Le sexe du personnage
          If Characters()\Sex=1
            String$+", male"
          Else
            String$+", female"
          EndIf
          ;Est-il le chef ou l'hritier de faction ?
          If Characters()\Leader=1
            String$+", leader"
          ElseIf Characters()\Leader=2
            String$+", heir"
          EndIf
          ;L'ge et la position du personnage
          String$+", age "+Str(Characters()\Age)+", x "+Str(Characters()\Pos\X)+", y "+Str(Characters()\Pos\Y)+" "
          WriteStringN(#DescrStrat,String$)
          ;Traits de caractres et suite
          If Characters()\Traits$<>"" : WriteStringN(#DescrStrat,"traits "+Characters()\Traits$+" ") : EndIf
          If Characters()\Ancil$<>"" : WriteStringN(#DescrStrat,"ancillaries "+Characters()\Ancil$) : EndIf
          ;Arme et units
          If Characters()\Army>0
            WriteStringN(#DescrStrat,"army")
            For i=0 To Characters()\Army-1
              String$="unit"+Chr(9)+Chr(9)+Characters()\Units[i]\Name$
              Tab((47-Len(Characters()\Units[i]\Name$))/8)
              WriteStringN(#DescrStrat,String$+Tab$+"exp "+Str(Characters()\Units[i]\Exp)+" armour "+Str(Characters()\Units[i]\Armour)+" weapon_lvl "+Str(Characters()\Units[i]\Weapon))
            Next i
          EndIf
          WriteStringN(#DescrStrat,"")
        EndIf
      Next
      ;character_record, tous les personnages absents de la carte de campagne et appartenant  cette faction
      ForEach Characters()
        If Characters()\Faction$=Factions()\Name\In$ And Characters()\Offmap
          String$="character_record"+Chr(9)+Chr(9)+Characters()\Name$+", "+Chr(9)
          ;Le sexe du personnage
          If Characters()\Sex=1 : String$+"male, age "+Str(Characters()\Age)+", "
          Else : String$+"female, age "+Str(Characters()\Age)+", " : EndIf
          ;Le personnage est-il en vie ? mort ? en dehors de la carte ?
          If Characters()\Death=-1 : String$+"alive, "
          ElseIf Characters()\Death=-2 : String$+"off_map, "
          Else : String$+"dead "+Str(Characters()\Death)+", " : EndIf
          ;Le personnage est-il le chef de faction ?
          If Characters()\Leader=1 : String$+"current_leader"
          Else : String$+"never_a_leader"
          EndIf
          WriteStringN(#DescrStrat,String$)
        EndIf
      Next
      WriteStringN(#DescrStrat,"")
      ;L'arbre gnalogique de la faction
      For i=0 To Factions()\Relative-1
        String$="relative "+Chr(9)
        For j=0 To Factions()\Tree[i]\Number-1
          String$+Factions()\Tree[i]\Member$[j]+","+Chr(9)
        Next j
        WriteStringN(#DescrStrat,String$+"end")
      Next i
    EndIf
  Next
  
  ;Diplomatie
  WriteStringN(#DescrStrat,#CRLF$+ReplaceString(Space(165)," ",";",2))
  WriteStringN(#DescrStrat,"; >>>> start of diplomacy section <<<<")
  WriteStringN(#DescrStrat,"")
  
  FirstElement(Factions())
  Repeat
    If Factions()\Status\Playable>0
      ;Initialisation du tableau d'valuation des relations
      *Address=@Factions()
      ForEach Factions() : Eval(ListIndex(Factions()))\Text$=Factions()\Name\In$ : Next
      ChangeCurrentElement(Factions(),*Address)
      ;Remplissage du tableau d'valuation
      For i=0 To CountList(Factions())-1 : Eval(i)\Point=Standings(ListIndex(Factions()),i) : Next i
      ;Rangement du tableau
      SortStructuredArray(Eval(),1,OffsetOf(eval\Point),#PB_Sort_Byte)
      ;Procdure complexe pour la cration des
      ;Chanes de caractres dcrivant les relations
      ;Entre factions
      i=0
      Repeat 
        If Eval(i)\Point<>0
          Type=Eval(i)\Point
          Tab((30-Len(Factions()\Name\In$))/8)
          String$="faction_standings"+Chr(9)+Factions()\Name\In$+","+Tab$+StrF(Type/100,2)+Chr(9)+Eval(i)\Text$
          j=i
          Repeat
            j+1
            If j=CountList(Factions()) : Break : EndIf
            If Eval(j)\Point=Type
              String$+", "+Eval(j)\Text$
            Else
              Break
            EndIf
          ForEver
          i=j
          WriteStringN(#DescrStrat,String$)
        Else
          i+1
        EndIf
        If i=CountList(Factions()) : Break : EndIf
      ForEver
    EndIf
    ;Sortie de la boucle une fois que toutes les factions ont t examines
    If NextElement(Factions())=0 : Break : EndIf
  ForEver
  WriteStringN(#DescrStrat,"")
  
  FirstElement(Factions())
  Repeat
    If Factions()\Status\Playable>0
      ;Initialisation du tableau d'valuation des relations
      *Address=@Factions()
      ForEach Factions() : Eval(ListIndex(Factions()))\Text$=Factions()\Name\In$ : Next
      ChangeCurrentElement(Factions(),*Address)
      ;Remplissage du tableau d'valuation
      For i=0 To CountList(Factions())-1 : Eval(i)\Point=Relationships(ListIndex(Factions()),i) : Next i
      ;Rangement du tableau
      SortStructuredArray(Eval(),1,OffsetOf(eval\Point),#PB_Sort_Byte)
      ;Procdure complexe pour la cration des
      ;Chanes de caractres dcrivant les relations
      ;Entre factions
      i=0
      Repeat 
        If Eval(i)\Point<>0
          Type=Eval(i)\Point
          If Type=1 : String$="allied_to " : ElseIf Type=-1 : String$="at_war_with " : EndIf
          String$="faction_relationships "+Chr(9)+Factions()\Name\In$+", "+String$+Chr(9)+Eval(i)\Text$
          j=i
          Repeat
            j+1
            If j=CountList(Factions()) : Break : EndIf
            If Eval(j)\Point=Type
              String$+", "+Eval(j)\Text$
            Else
              Break
            EndIf
          ForEver
          i=j
          WriteStringN(#DescrStrat,String$)
        Else
          i+1
        EndIf
        If i=CountList(Factions()) : Break : EndIf
      ForEver
    EndIf
    ;Sortie de la boucle une fois que toutes les factions ont t examines
    If NextElement(Factions())=0 : Break : EndIf
  ForEver
  
  ;Rgions
  WriteStringN(#DescrStrat,#CRLF$+ReplaceString(Space(165)," ",";",2))
  WriteStringN(#DescrStrat,"; >>>> start of regions section <<<<")
  
  If Campaign\Script$<>""
    WriteStringN(#DescrStrat,"")
    WriteStringN(#DescrStrat,"script")
    WriteStringN(#DescrStrat,Campaign\Script$)
  EndIf
  
  CloseFile(#DescrStrat)
  
  SetProgress(100)
  
EndProcedure

; IDE Options = PureBasic 4.10 (Windows - x86)
; CursorPosition = 333
; FirstLine = 327
; Folding = -