
Procedure About()
  Protected String$
  
  ;Dsactivation de la fentre principale
  DisableWindow(#Win,1)
  
  ;Cration de la fentre de l' propos
  If OpenWindow(#WinAbout,0,0,280,225," propos",#PB_Window_SystemMenu|#PB_Window_WindowCentered,WindowID(#Win))
    If CreateGadgetList(WindowID(#WinAbout))
      String$="Geomod v0.2."+Str(#PB_Editor_BuildCount)+" est un logiciel de modding"
      String$+#CRLF$+"pour le jeu Medieval II : Total War."+#CRLF$
      String$+#CRLF$+"Licence : logiciel gratuit et libre (copyleft)."+#CRLF$
      String$+#CRLF$+"Utilisation : vous utilisez ce logiciel  vos risques et prils. Les auteurs, contributeurs et distributeurs ne peuvent tre tenus responsables de problmes lis  l'utilisation de ce logiciel."+#CRLF$
      String$+#CRLF$+"Site web :"
      TextGadget(#TextAbout,10,10,260,145,String$,#PB_Text_Center)
      HyperLinkGadget(#HttpAbout,70,155,140,14,"http://www.universtotalwar.fr",RGB(0,128,255),#PB_HyperLink_Underline)
      SetGadgetColor(#HttpAbout,#PB_Gadget_FrontColor,RGB(0,0,255))
      ButtonGadget(#QuitAbout,110,190,60,25,"OK",#PB_Button_Default)
    Else
      FatalError("Impossible de crer les lments de la fentre de l' propos.")
    EndIf
  Else
    FatalError("Impossible d'afficher la fentre de l' propos.")
  EndIf
  
  ;Boucle des vnements
  Repeat
    Select WaitWindowEvent()
      Case #PB_Event_Gadget
        Select EventGadget()
          Case #HttpAbout
            RunProgram("http://www.universtotalwar.fr")
          Case #QuitAbout
            ;Sortie de la boucle
            Break
        EndSelect
      Case #PB_Event_CloseWindow
        ;Sortie de la boucle
        Break
    EndSelect
  ForEver
  
  ;Retour au programme principal
  DisableWindow(#Win,0) : CloseWindow(#WinAbout)
  
EndProcedure

Procedure Progress(Text$)
  
  ;Mise  jour de la fentre principale
  UpdateWindow_(#Win)
  
  ;Dsactivation de la fentre principale
  DisableWindow(#Win,1)
  
  ;Cration de la fentre de l' propos
  If OpenWindow(#WinProgress,0,0,240,75,Text$,#PB_Window_WindowCentered,WindowID(#Win))
    If CreateGadgetList(WindowID(#WinProgress))
      ProgressBarGadget(#Progress,10,10,220,30,0,100)
      TextGadget(#ProgressText,10,50,220,14,"0 %",#PB_Text_Center)
    Else
      FatalError("Impossible de crer les lments de la fentre de progression.")
    EndIf
  Else
    FatalError("Impossible d'afficher la fentre de progression.")
  EndIf
  
EndProcedure

Procedure Error(Text$)
  MessageRequester("Erreur !",Text$)
EndProcedure

Procedure FatalError(Text$)
  
  MessageRequester("Erreur fatale !",Text$+#CRLF$+#CRLF$+"Le programme va s'arrter.")
  End
  
  ;Dsactivation de la fentre principale
  If IsWindow(#Win) : DisableWindow(#Win,1) : EndIf
  
  If IsWindow(#Win)
    If OpenWindow(#WinError,0,0,200,120,"Erreur fatale !",#PB_Window_SystemMenu|#PB_Window_WindowCentered,WindowID(#Win))
      If CreateGadgetList(WindowID(#WinError))
        TextGadget(#TextError,10,10,180,65,Text$+#CRLF$+#CRLF$+"Le programme va s'arrter.",#PB_Text_Center)
        ButtonGadget(#QuitError,70,85,60,25,"OK")
      Else
        End
      EndIf
    Else
      End
    EndIf
  Else
    If OpenWindow(#WinError,0,0,200,120,"Erreur fatale !",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
      If CreateGadgetList(WindowID(#WinError))
        TextGadget(#TextError,10,10,180,65,Text$+#CRLF$+#CRLF$+"Le programme va s'arrter.",#PB_Text_Center)
        ButtonGadget(#QuitError,70,85,60,25,"OK")
      Else
        End
      EndIf
    Else
      End
    EndIf
  EndIf
  
  ;Boucle des vnements
  Repeat
    Select WaitWindowEvent()
      Case #PB_Event_Gadget
        Select EventGadget()
          Case #QuitError
            Break
        EndSelect
      Case #PB_Event_CloseWindow
        Break
    EndSelect
  ForEver
  
  ;Fin du programme!
  End
  
EndProcedure

Procedure AddBuilding(Text$)
  Protected i.w,State.b
  
  ;Dsactivation de la fentre principale
  DisableWindow(#Win,1)
  
  ;Cration de la fentre d'ajout
  If OpenWindow(#WinBuilding,0,0,270,70,"Ajouter un btiment  "+Text$,#PB_Window_SystemMenu|#PB_Window_WindowCentered,WindowID(#Win))
    If CreateGadgetList(WindowID(#WinBuilding))
      ComboBoxGadget(#FirstBuild,10,10,180,0)
      ComboBoxGadget(#SecondBuild,10,40,180,0)
      ButtonGadget(#OKBuild,200,10,60,50,"OK") : DisableGadget(#OKBuild,1)
    Else
      FatalError("Impossible de crer les lments de la fentre d'ajout de btiments.")
    EndIf
  Else
    FatalError("Impossible d'afficher la fentre d'ajout de btiments.")
  EndIf
  
  ;Remplissage de la premire liste (types)
  ResetList(Buildings())
  For i=0 To CountList(Buildings())-1
    NextElement(Buildings())
    AddGadgetItem(#FirstBuild,i,Buildings()\Type$)
    SetGadgetItemData(#FirstBuild,i,@Buildings())
  Next i
  If CountList(Buildings())>10
    ResizeGadget(#FirstBuild,#PB_Ignore,#PB_Ignore,#PB_Ignore,200)
  Else
    ResizeGadget(#FirstBuild,#PB_Ignore,#PB_Ignore,#PB_Ignore,20*CountList(Buildings()))
  EndIf
  
  ;Boucle des vnements
  Repeat
    Select WaitWindowEvent()
      Case #PB_Event_Gadget
        Select EventGadget()
          Case #FirstBuild
            If GetGadgetState(#FirstBuild)<>State
              State=GetGadgetState(#FirstBuild)
              If State>-1
                ChangeCurrentElement(Buildings(),GetGadgetItemData(#FirstBuild,State))
                ClearGadgetItemList(#SecondBuild)
                For i=1 To CountString(Buildings()\Levels$," ")+1
                  AddGadgetItem(#SecondBuild,-1,StringField(Buildings()\Levels$,i," "))
                Next i
                ResizeGadget(#SecondBuild,#PB_Ignore,#PB_Ignore,#PB_Ignore,20*i)
                DisableGadget(#OKBuild,1)
              EndIf
            EndIf
          Case #SecondBuild
            If GetGadgetState(#SecondBuild)>-1 : DisableGadget(#OKBuild,0) : EndIf
          Case #OKBuild
            ;Si on ajoute effectivement un btiment
            AddGadgetItem(#ListBuildings,-1,GetGadgetItemText(#FirstBuild,GetGadgetState(#FirstBuild))+" "+GetGadgetItemText(#SecondBuild,GetGadgetState(#SecondBuild)))
            ;Sortie de la boucle
            Break
        EndSelect
      Case #PB_Event_CloseWindow
        ;Sortie de la boucle
        Break
    EndSelect
  ForEver
  
  ;Retour au programme principal
  DisableWindow(#Win,0) : CloseWindow(#WinBuilding)
  
EndProcedure

Procedure CreateCursor()
  Protected ErrorFile$,ErrorLoad$,File$,Text$,Sprite.b,i.b
  
  ;Curseur souris
  Restore Cursor
  If FileSize("media")=-2
    For i=0 To 5
      Read Sprite : Read File$
      If FileSize(File$)>0
        If Not LoadSprite(Sprite,File$)
          ErrorLoad$+#CRLF$+File$
        EndIf
      Else
        ErrorFile$+#CRLF$+File$
      EndIf
    Next i
    If ErrorFile$<>"" : ErrorFile$="Les fichiers suivants sont introuvables :"+ErrorFile$ : Text$=ErrorFile$ : EndIf
    If ErrorLoad$<>"" : ErrorLoad$="Les fichiers suivants sont corrompus :"+ErrorLoad$ : Text$=ErrorLoad$ : EndIf
    If ErrorFile$<>"" And ErrorLoad$<>"" : Text$=ErrorFile$+#CRLF$+#CRLF$+ErrorLoad$ : EndIf
    If Text$<>"" : FatalError(Text$) : EndIf
  Else
    FatalError("Le dossier 'media' est introuvable !")
  EndIf
  
EndProcedure

Procedure.b UpdateDrawingFeatures(Map.b)
  Protected i.b
  
  ClearGadgetItemList(#DrawElement)
  Select Map
    Case 0
      HideGadget(#DrawElement,0)
      HideGadget(#DrawTrack,1)
      For i=0 To 9
        AddGadgetItem(#DrawElement,i,Climate(i)\Name$)
        SetGadgetItemData(#DrawElement,i,Climate(i)\Color)
      Next i
      SetGadgetState(#DrawElement,0)
      SetGadgetColor(#DrawColor,#PB_Gadget_BackColor,GetGadgetItemData(#DrawElement,0))
    Case 1
      HideGadget(#DrawElement,0)
      HideGadget(#DrawTrack,1)
      For i=0 To 14
        AddGadgetItem(#DrawElement,i,Ground(i)\Name$)
        SetGadgetItemData(#DrawElement,i,Ground(i)\Color)
      Next i
      SetGadgetState(#DrawElement,0)
      SetGadgetColor(#DrawColor,#PB_Gadget_BackColor,GetGadgetItemData(#DrawElement,0))
    Case 2
      HideGadget(#DrawElement,1)
      HideGadget(#DrawTrack,0)
      SetGadgetState(#DrawTrack,100)
      SetGadgetColor(#DrawColor,#PB_Gadget_BackColor,0)
    Case 3
      HideGadget(#DrawElement,0)
      HideGadget(#DrawTrack,1)
        AddGadgetItem(#DrawElement,0,"Mer")
        SetGadgetItemData(#DrawElement,0,#Sea)
        AddGadgetItem(#DrawElement,1,"Lac")
        SetGadgetItemData(#DrawElement,1,#Lake)
        AddGadgetItem(#DrawElement,2,"Mer caspienne")
        SetGadgetItemData(#DrawElement,2,#Caspian)
        AddGadgetItem(#DrawElement,3,"Mer rouge")
        SetGadgetItemData(#DrawElement,3,#Erythrea)
        AddGadgetItem(#DrawElement,4,"Rgion")
        SetGadgetItemData(#DrawElement,4,0)
      If CountList(Regions())>0
        If ListIndex(Regions())<0 : FirstElement(Regions()) : EndIf
        SetGadgetItemData(#DrawElement,4,Regions()\Color)
      EndIf
      SetGadgetState(#DrawElement,0)
      SetGadgetColor(#DrawColor,#PB_Gadget_BackColor,GetGadgetItemData(#DrawElement,0))
    Case 4
      HideGadget(#DrawElement,0)
      HideGadget(#DrawTrack,1)
        AddGadgetItem(#DrawElement,0,"Rivire")
        SetGadgetItemData(#DrawElement,0,#River)
        AddGadgetItem(#DrawElement,1,"Source")
        SetGadgetItemData(#DrawElement,1,#Source)
        AddGadgetItem(#DrawElement,2,"Pont")
        SetGadgetItemData(#DrawElement,2,#Bridge)
        AddGadgetItem(#DrawElement,3,"Volcan")
        SetGadgetItemData(#DrawElement,3,#Volcano)
        AddGadgetItem(#DrawElement,4,"Falaise")
        SetGadgetItemData(#DrawElement,4,#Cliff)
        AddGadgetItem(#DrawElement,5,"Passage")
        SetGadgetItemData(#DrawElement,5,#Passage)
        AddGadgetItem(#DrawElement,6,"(Effacer)")
        SetGadgetItemData(#DrawElement,6,#Black)
      SetGadgetState(#DrawElement,0)
      SetGadgetColor(#DrawColor,#PB_Gadget_BackColor,GetGadgetItemData(#DrawElement,0))
    Default
      ProcedureReturn #False
  EndSelect
  
  DrawColor=GetGadgetColor(#DrawColor,#PB_Gadget_BackColor)
  SetGadgetText(#DrawRed,Str(Red(DrawColor)))
  SetGadgetText(#DrawGreen,Str(Green(DrawColor)))
  SetGadgetText(#DrawBlue,Str(Blue(DrawColor)))
  ResizeGadget(#DrawElement,#PB_Ignore,#PB_Ignore,#PB_Ignore,20*CountGadgetItems(#DrawElement))
  
  ProcedureReturn #True
  
EndProcedure

Procedure UpdateStatus(Event.l)
  Protected Color.l,i.b,String$
  
  If IsScreenActive() ;Test si l'cran est actif, obligatoire !!!
    ;Barre de statut
    StatusBarText(#Status,0,"Position : "+Str(Position\X)+", "+Str(Position\Y))
    StatusBarText(#Status,1,"Vertex : "+Str(Vertex\X)+", "+Str(Vertex\Y))
    Select Map
      Case 0
        If InMap(OriClimate,Vertex\X,Vertex\Y)
          Color=PeekL(OriClimate\bmBits+(Vertex\X)*4+(Vertex\Y)*OriClimate\bmWidthBytes)
          Color=ReverseRGB(Color)
          For i=0 To 9
            If Climate(i)\Color=Color
              StatusBarText(#Status,2,"Climat : "+Climate(i)\Name$)
              Break
            EndIf
          Next i
        Else
          StatusBarText(#Status,2,"")
        EndIf
      Case 1
        If InMap(OriGroundType,Vertex\X,Vertex\Y)
          Color=PeekL(OriGroundType\bmBits+(Vertex\X)*4+(Vertex\Y)*OriGroundType\bmWidthBytes)
          Color=ReverseRGB(Color)
          For i=0 To 14
            If Ground(i)\Color=Color
              StatusBarText(#Status,2,"Terrain : "+Ground(i)\Name$)
              Break
            EndIf
          Next i
        Else
          StatusBarText(#Status,2,"")
        EndIf
      Case 2
        If InMap(OriHeight,Vertex\X,Vertex\Y)
          Color=PeekL(OriHeight\bmBits+(Vertex\X)*4+(Vertex\Y)*OriHeight\bmWidthBytes)
          If Blue(Color)=Red(Color) : Color=Blue(Color) : Else : Color=Red(Color)-256 : EndIf
          StatusBarText(#Status,2,"Hauteur : "+Str(Color))
        Else
          StatusBarText(#Status,2,"")
        EndIf
      Case 3
        If InMap(OriRegion,Position\X,Position\Y)
          Color=PeekL(OriRegion\bmBits+(Position\X)*4+(Position\Y)*OriRegion\bmWidthBytes)
          Color=ReverseRGB(Color)
          ForEach Regions()
            If Regions()\Color=Color
              StatusBarText(#Status,2,"Rgion : "+Regions()\Province\Out$)
              Color=0
              Break
            EndIf
          Next
          If Color
            If Color=#Sea : StatusBarText(#Status,2,"Rgion : Mer")
            ElseIf Color=#Lake : StatusBarText(#Status,2,"Rgion : Lac")
            ElseIf Color=#Caspian : StatusBarText(#Status,2,"Rgion : Mer caspienne")
            ElseIf Color=#Erythrea : StatusBarText(#Status,2,"Rgion : Mer rouge") : EndIf
          EndIf
        Else
          StatusBarText(#Status,2,"")
        EndIf
    EndSelect
    StatusBarText(#Status,3,"")
    ;Affichage des ressources au passage de la souris
    If GetGadgetState(#Resource)
      If InMap(OriResource,Position\X,Position\Y)
        If PeekL(OriResource\bmBits+(Position\X)*4+(Position\Y)*OriResource\bmWidthBytes)=$404040
          ForEach Resources()
            If Resources()\X=Position\X And Resources()\Y=Position\Y
              StatusBarText(#Status,3,"Ressource : "+Resources()\Name$)
              Break
            EndIf
          Next
        EndIf
      EndIf
    EndIf
    ;Affichage des personnages au passage de la souris
    If GetGadgetState(#Army)
      If InMap(OriArmy,Position\X,Position\Y)
        If PeekL(OriArmy\bmBits+(Position\X)*4+(Position\Y)*OriArmy\bmWidthBytes)=#DarkBlue
          ForEach Characters()
            If Not Characters()\Offmap
              If Characters()\Pos\X=Position\X And Characters()\Pos\Y=Position\Y
                ;Le type de personnage
                Select Characters()\Type
                  Case #Named : String$="Gnral"
                  Case #General : String$="Capitaine"
                  Case #Admiral : String$="Amiral"
                  Case #Diplomat : String$="Diplomate"
                  Case #Princess : String$="Princesse"
                  Case #Spy : String$="Espion"
                  Case #Assassin : String$="Assassin"
                  Case #Merchant : String$="Marchand"
                  Case #Priest : String$="Prtre"
                  Case #Witch : String$="Sorcire"
                  Case #Heretic : String$="Hrtique"
                  Case #Inquisitor : String$="Inquisiteur"
                EndSelect
                String$+" : "+Characters()\Name$
                ;Description du nombre d'units composant l'arme s'il y en a
                If Characters()\Type<#Diplomat : If Characters()\Army<2 : String$+", "+Str(Characters()\Army)+" unit" : Else : String$+", "+Str(Characters()\Army)+" units" : EndIf : EndIf
                ;Faction
                String$+" ("+Characters()\Faction$+")"
                ;Affichage du rsultat
                StatusBarText(#Status,3,String$)
                ;Fin de la boucle
                Break
              EndIf
            EndIf
          Next
        EndIf
      EndIf
    EndIf
  EndIf
  
EndProcedure

;**********************************************************************************************************
;-Main window
;**********************************************************************************************************

If OpenWindow(#Win,0,0,#TotalWidth,#Screen+#Offset+50,"Geomod v0.2."+Str(#PB_Editor_BuildCount)+" (bta) - diteur de Campagne",#PB_Window_SystemMenu|#PB_Window_MinimizeGadget|#PB_Window_ScreenCentered)
  
  ;Polices spciales
  If Not LoadFont(#Symbol,"Symbol",8)
    FatalError("Le chargement de la police 'Symbol' a chou.")
  EndIf
  If Not LoadFont(#DrawFont,"Arial",6)
    FatalError("Le chargement de la police 'Arial' a chou.")
  EndIf
  
  ;Tous les gadgets !!!
  If CreateGadgetList(WindowID(#Win))
    
    ;Les onglets
    PanelGadget(#Panel,#Width,#Offset,#PanelWidth,#Screen)
    
    ;La gestion des cartes
    AddGadgetItem(#Panel,-1,"Cartes")
    
    ;L'affichage
    Frame3DGadget(#Display,10,10,#PanelWidth-25,75,"Affichage :")
    ButtonGadget(#Zoom,20,30,60,20,"Zoomer",#PB_Button_Toggle)
    ButtonGadget(#UnZoom,20,55,60,20,"Dzoomer")
    ButtonGadget(#OptionVertex,85,30,90,20,"Grille de vertex",#PB_Button_Toggle)
    ButtonGadget(#OptionPosition,85,55,90,20,"Grille de position",#PB_Button_Toggle)
    
    ;Les options
    Frame3DGadget(#BackRegionText,10,90,#HalfPanel,125,"Carte principale :")
    OptionGadget(#Climate,20,110,#HalfPanel-20,20,"Climats")
    OptionGadget(#GroundType,20,135,#HalfPanel-20,20,"Terrains")
    OptionGadget(#Height,20,160,#HalfPanel-20,20,"Hauteurs")
    OptionGadget(#Region,20,185,#HalfPanel-20,20,"Rgions")
    
    Frame3DGadget(#FrontRegionText,#HalfPanel+21,90,#HalfPanel,125,"Calques secondaires :")
    CheckBoxGadget(#Feature,#HalfPanel+31,110,#HalfPanel-20,20,"lments")
    CheckBoxGadget(#City,#HalfPanel+31,135,#HalfPanel-20,20,"Cits et ports")
    CheckBoxGadget(#Resource,#HalfPanel+31,160,#HalfPanel-20,20,"Ressources")
    CheckBoxGadget(#Army,#HalfPanel+31,185,#HalfPanel-20,20,"Personnages")
    
    ;Zone de dessin
    Frame3DGadget(#DrawFrame,10,220,#PanelWidth-25,125,"Dessins :")
    ComboBoxGadget(#DrawMap,105,240,70,100) : ComboBoxGadget(#DrawElement,180,240,110,0) : TrackBarGadget(#DrawTrack,180,240,110,20,0,355)
    ButtonGadget(#DrawButton,20,240,80,20,"Dessiner",#PB_Button_Toggle)
    ButtonGadget(#DrawBrush,20,265,80,20,"Peindre",#PB_Button_Toggle) : DisableGadget(#DrawBrush,1)
    ButtonGadget(#DrawFill,20,290,80,20,"Remplir",#PB_Button_Toggle)
    ButtonGadget(#DrawSample,20,315,80,20,"Prlever",#PB_Button_Toggle)
    ContainerGadget(#DrawColor,105,265,70,70,#PB_Container_Double) : SetGadgetColor(#DrawColor,#PB_Gadget_BackColor,0) : CloseGadgetList()
    TextGadget(#DrawRedText,180,268,45,14,"Rouge :") : StringGadget(#DrawRed,230,265,40,20,"",#PB_String_ReadOnly)
    TextGadget(#DrawGreenText,180,293,45,14,"Vert :") : StringGadget(#DrawGreen,230,290,40,20,"",#PB_String_ReadOnly)
    TextGadget(#DrawBlueText,180,318,45,14,"Bleu :") : StringGadget(#DrawBlue,230,315,40,20,"",#PB_String_ReadOnly)
    
    AddGadgetItem(#DrawMap,-1,"Climats")
    AddGadgetItem(#DrawMap,-1,"Terrains")
    AddGadgetItem(#DrawMap,-1,"Hauteurs")
    AddGadgetItem(#DrawMap,-1,"Rgions")
    AddGadgetItem(#DrawMap,-1,"lments")
    
    ;La gestion des rgions
    AddGadgetItem(#Panel,-1,"Rgions")
    ListViewGadget(#ListRegion,10,10,#PanelList,120)
    ButtonGadget(#Unselect,#PanelList+20,10,#PanelButton,20,"Dslectionner") : DisableGadget(#Unselect,1)
    ButtonGadget(#New,#PanelList+20,35,#PanelButton,20,"Nouveau")
    ButtonGadget(#Validate,#PanelList+20,60,#PanelButton,20,"Valider") : DisableGadget(#Validate,1)
    ButtonGadget(#Suppr,#PanelList+20,85,#PanelButton,20,"Supprimer") : DisableGadget(#Suppr,1)
    ButtonGadget(#Up,#PanelList+20,110,(#PanelButton-5)/2,20,"") : DisableGadget(#Up,1) : SetGadgetFont(#Up,FontID(#Symbol))
    ButtonGadget(#Down,#PanelList+20+(#PanelButton-5)/2+5,110,(#PanelButton-5)/2,20,"") : DisableGadget(#Down,1) : SetGadgetFont(#Down,FontID(#Symbol))
    
    ;Nouveau panneau interne
    PanelGadget(#InnerPanel,10,140,#PanelWidth-25,#Screen-175)
    
    AddGadgetItem(#InnerPanel,-1,"Province")
      
      Frame3DGadget(#TextRegion,10,10,#PanelWidth-50,50,"Nom :")
      StringGadget(#TextRegionIn,20,30,115,20,"")
      TextGadget(#Slash1,140,33,10,14,"/")
      StringGadget(#TextRegionOut,150,30,115,20,"")
      
      Frame3DGadget(#TextColor,10,65,#PanelWidth-50,100,"Couleur :")
      
      TextGadget(#TextRed,20,88,45,14,"Rouge :")
      SpinGadget(#SpinRed,65,85,35,20,0,255,#PB_Spin_Numeric) : SetGadgetState(#SpinRed,0)
      
      TextGadget(#TextGreen,20,113,45,14,"Vert :")
      SpinGadget(#SpinGreen,65,110,35,20,0,255,#PB_Spin_Numeric) : SetGadgetState(#SpinGreen,0)
      
      TextGadget(#TextBlue,20,138,45,14,"Bleu :")
      SpinGadget(#SpinBlue,65,135,35,20,0,255,#PB_Spin_Numeric) : SetGadgetState(#SpinBlue,0)
      
      ContainerGadget(#ColorContainer,110,85,70,70,#PB_Container_Double) : SetGadgetColor(#ColorContainer,#PB_Gadget_BackColor,0) : CloseGadgetList()
      ButtonGadget(#AleaColor,190,85,#PanelWidth-50-190,30,"Alatoire")
      ButtonGadget(#ChangeColor,190,125,#PanelWidth-50-190,30,"Appliquer")
      
      Frame3DGadget(#TextEco,10,170,#PanelWidth-50,50,"conomie :")
      TextGadget(#TextAgriculture,20,193,65,14,"Agriculture :")
      SpinGadget(#AgricultureRegion,85,190,35,20,0,20,#PB_Spin_Numeric) : SetGadgetState(#AgricultureRegion,0)
      TextGadget(#TextVictory,150,193,50,14,"Victoire :")
      SpinGadget(#VictoryRegion,200,190,35,20,0,20,#PB_Spin_Numeric) : SetGadgetState(#VictoryRegion,0)
      
    AddGadgetItem(#InnerPanel,-1,"Communaut")
      
      Frame3DGadget(#TextCity,10,10,#PanelWidth-50,50,"Nom :")
      StringGadget(#TextCityIn,20,30,115,20,"")
      TextGadget(#Slash2,140,33,10,14,"/")
      StringGadget(#TextCityOut,150,30,115,20,"")
      
      Frame3DGadget(#TextCoord,10,65,#PanelWidth-50,80,"Coordonnes :")
      
      TextGadget(#TextCoordCity,20,88,50,14,"Ville :")
      TextGadget(#CoordCityXText,70,88,20,14,"X = ")
      StringGadget(#CoordCityX,90,85,30,20,"0",#PB_String_Numeric|#PB_String_ReadOnly)
      TextGadget(#CoordCityYText,135,88,20,14,"Y = ")
      StringGadget(#CoordCityY,155,85,30,20,"0",#PB_String_Numeric|#PB_String_ReadOnly)
      ButtonGadget(#CoordCityButton,200,85,65,20,"Dplacer",#PB_Button_Toggle)
      
      TextGadget(#TextCoordPort,20,118,30,14,"Port :")
      TextGadget(#CoordPortXText,70,118,20,14,"X = ")
      StringGadget(#CoordPortX,90,115,30,20,"0",#PB_String_Numeric|#PB_String_ReadOnly)
      TextGadget(#CoordPortYText,135,118,20,14,"Y = ")
      StringGadget(#CoordPortY,155,115,30,20,"0",#PB_String_Numeric|#PB_String_ReadOnly)
      ButtonGadget(#CoordPortButton,200,115,65,20,"Dplacer",#PB_Button_Toggle)
      
    AddGadgetItem(#InnerPanel,-1,"Dveloppement")
      
      Frame3DGadget(#TextSize,10,10,#PanelWidth-50,50,"Taille :")
      TextGadget(#TownSizeText,20,33,60,14,"Population :")
      
      SpinGadget(#TownSize,80,30,50,20,0,0,#PB_Spin_Numeric)
      SendMessage_(FindWindowEx_(GetWindowLong_(GadgetID(#TownSize),#GWL_HWNDPARENT),GadgetID(#TownSize),#Null,#Null),#UDM_SETRANGE32,400,72000)
      SetGadgetState(#TownSize,400)
      
      TextGadget(#TownLevelText,143,33,40,14,"Niveau :")
      ComboBoxGadget(#TownLevel,188,30,80,120)
      
      For i=0 To 5 : LevelToString(i,Text$) : AddGadgetItem(#TownLevel,-1,Text$) : Next i
      
      Frame3DGadget(#TextBuildings,10,65,#PanelWidth-50,130,"Btiments :")
      TextGadget(#CastleText,20,88,30,14,"Type :")
      ButtonGadget(#Castle,60,85,60,20,"(Aucun)") : DisableGadget(#Castle,1)
      ListViewGadget(#ListBuildings,20,115,#PanelWidth-70,70)
      ButtonGadget(#BuildingsAdd,(#PanelWidth-20)/2,85,50,20,"Ajouter") : DisableGadget(#BuildingsAdd,1)
      ButtonGadget(#BuildingsSuppr,(#PanelWidth-20)/2+60,85,60,20,"Supprimer") : DisableGadget(#BuildingsSuppr,1)
      
      Frame3DGadget(#TextResources,10,200,#PanelWidth-50,86,"Ressources :")
      ListViewGadget(#ListResources,20,220,(#PanelWidth-80)/2,56)
      StringGadget(#ResourcesRegion,(#PanelWidth-20)/2,220,(#PanelWidth-80)/2,20,"")
      ButtonGadget(#ResourcesAdd,(#PanelWidth-20)/2,250,50,27,"Ajouter") : DisableGadget(#ResourcesAdd,1)
      ButtonGadget(#ResourcesSuppr,(#PanelWidth-20)/2+60,250,60,27,"Supprimer") : DisableGadget(#ResourcesSuppr,1)
      
    AddGadgetItem(#InnerPanel,-1,"Divers")
      
      TextGadget(#TextOriFaction,10,13,100,14,"Faction d'origine :")
      ComboBoxGadget(#OriFactionRegion,110,10,140,0)
      
      TextGadget(#TextFaction,10,43,100,14,"Faction actuelle :")
      ComboBoxGadget(#FactionRegion,110,40,140,0)
      
      TextGadget(#TextRebels,10,73,100,14,"Rebelles :")
      ComboBoxGadget(#RebelsRegion,110,70,140,0)
      
      TextGadget(#TextMerc,10,103,100,14,"Mercenaires :")
      ComboBoxGadget(#MercRegion,110,100,140,0)
      
      TextGadget(#TextMusic,10,133,100,14,"Type de musique :")
      ComboBoxGadget(#MusicRegion,110,130,140,0)
      
    ;La gestion des factions
    AddGadgetItem(#Panel,-1,"Factions")
      
      ListViewGadget(#ListFaction,10,10,#PanelList,70)
      ButtonGadget(#UnselectFaction,#PanelList+20,10,#PanelButton,20,"Dslectionner") : DisableGadget(#UnselectFaction,1)
      ButtonGadget(#CancelFaction,#PanelList+20,35,#PanelButton,20,"Annuler") : DisableGadget(#CancelFaction,1)
      ButtonGadget(#ValidateFaction,#PanelList+20,60,#PanelButton,20,"Valider") : DisableGadget(#ValidateFaction,1)
      PanelGadget(#FactionPanel,10,90,#PanelWidth-25,#Screen-125)
      
      AddGadgetItem(#FactionPanel,-1,"Gnralits")
        
        TextGadget(#FReligionText,10,13,100,14,"Religion :")
        ComboBoxGadget(#FReligion,110,10,140,0)
        
        TextGadget(#FMusicText,10,38,100,14,"Musique :")
        ComboBoxGadget(#FMusic,110,35,140,0)
        
        CheckBoxGadget(#SpecialTypeText,10,63,90,14,"Type spcial :")
        StringGadget(#SpecialType,110,60,140,20,"") : DisableGadget(#SpecialType,1)
        
        CheckBoxGadget(#CustomBattle,10,88,200,14,"Disponible en batailles personnalises")
        CheckBoxGadget(#NavalInvasion,10,112,200,14,"Prfrence pour les invasions navales")
        CheckBoxGadget(#HasPrincess,10,136,200,14,"Princesses sur la carte de campagne")
        CheckBoxGadget(#FamilyTree,10,160,120,14,"Arbre gnalogique :")
        OptionGadget(#FamilyTreeNormal,135,160,52,14,"Normal") : DisableGadget(#FamilyTreeNormal,1)
        OptionGadget(#FamilyTreeTeutonic,195,160,75,14,"Teutonique") : DisableGadget(#FamilyTreeTeutonic,1)
        CheckBoxGadget(#CanDeath,10,184,170,14,"Sensible  la peste :") : OptionGadget(#CanDeathYes,185,184,45,14,"Oui") : OptionGadget(#CanDeathNo,230,184,45,14,"Non") : DisableGadget(#CanDeathYes,1) : DisableGadget(#CanDeathNo,1)
        CheckBoxGadget(#DisbandPool,10,208,170,14,"Dmobilisation des units :") : OptionGadget(#DisbandPoolYes,185,208,45,14,"Oui") : OptionGadget(#DisbandPoolNo,230,208,45,14,"Non") : DisableGadget(#DisbandPoolYes,1) : DisableGadget(#DisbandPoolNo,1)
        CheckBoxGadget(#BuildTower,10,232,170,14,"Tours de sige en campagne :") : OptionGadget(#BuildTowerYes,185,232,45,14,"Oui") : OptionGadget(#BuildTowerNo,230,232,45,14,"Non") : DisableGadget(#BuildTowerYes,1) : DisableGadget(#BuildTowerNo,1)
        
        Frame3DGadget(#FPrimaryText,10,255,#HalfPanel-12,100,"Couleur primaire :")
        ContainerGadget(#FPrimaryColor,20,275,70,70,#PB_Container_Double) : SetGadgetColor(#FPrimaryColor,#PB_Gadget_BackColor,0) : CloseGadgetList()
        SpinGadget(#FPrimaryRed,95,275,35,20,0,255,#PB_Spin_Numeric) : SetGadgetState(#FPrimaryRed,0)
        SpinGadget(#FPrimaryGreen,95,300,35,20,0,255,#PB_Spin_Numeric) : SetGadgetState(#FPrimaryGreen,0)
        SpinGadget(#FPrimaryBlue,95,325,35,20,0,255,#PB_Spin_Numeric) : SetGadgetState(#FPrimaryBlue,0)
        
        Frame3DGadget(#FSecondaryText,#HalfPanel+8,255,#HalfPanel-12,100,"Couleur secondaire :")
        ContainerGadget(#FSecondaryColor,#HalfPanel+18,275,70,70,#PB_Container_Double) : SetGadgetColor(#FSecondaryColor,#PB_Gadget_BackColor,0) : CloseGadgetList()
        SpinGadget(#FSecondaryRed,#HalfPanel+93,275,35,20,0,255,#PB_Spin_Numeric) : SetGadgetState(#FSecondaryRed,0)
        SpinGadget(#FSecondaryGreen,#HalfPanel+93,300,35,20,0,255,#PB_Spin_Numeric) : SetGadgetState(#FSecondaryGreen,0)
        SpinGadget(#FSecondaryBlue,#HalfPanel+93,325,35,20,0,255,#PB_Spin_Numeric) : SetGadgetState(#FSecondaryBlue,0)
        
      AddGadgetItem(#FactionPanel,-1,"Campagne")
        
        TextGadget(#PlayabilityText,10,13,100,14,"Jouabilit :")
        ComboBoxGadget(#Playability,110,10,140,80)
        AddGadgetItem(#Playability,-1,"Absente")
        AddGadgetItem(#Playability,-1,"Jouable")
        AddGadgetItem(#Playability,-1,"Dbloquable")
        AddGadgetItem(#Playability,-1,"Injouable")
        
        TextGadget(#LabelAIText,10,38,100,14,"IA stratgique :")
        StringGadget(#LabelAI,110,35,140,20,"")
        
        TextGadget(#EconomicAIText,10,63,100,14,"IA conomique :")
        StringGadget(#EconomicAI,110,60,140,20,"")
        
        TextGadget(#MilitaryAIText,10,88,100,14,"IA militaire :")
        StringGadget(#MilitaryAI,110,85,140,20,"")
        
        TextGadget(#MoneyText,10,113,100,14,"Argent de dpart :")
        SpinGadget(#Money,110,110,55,20,0,0,#PB_Spin_Numeric)
        SendMessage_(FindWindowEx_(GetWindowLong_(GadgetID(#Money),#GWL_HWNDPARENT),GadgetID(#Money),#Null,#Null),#UDM_SETRANGE32,0,999999)
        
        TextGadget(#KingsPurseText,10,138,100,14,"Trsor royal :")
        SpinGadget(#KingsPurse,110,135,55,20,0,0,#PB_Spin_Numeric)
        SendMessage_(FindWindowEx_(GetWindowLong_(GadgetID(#KingsPurse),#GWL_HWNDPARENT),GadgetID(#KingsPurse),#Null,#Null),#UDM_SETRANGE32,0,999999)
        
      AddGadgetItem(#FactionPanel,-1,"Personnages")
        
      AddGadgetItem(#FactionPanel,-1,"Horde")
        
        CheckBoxGadget(#CanHordeText,10,13,165,14,"Possibilit de former une horde")
        Frame3DGadget(#CanHorde,10,35,#PanelWidth-50,175,"Nomadisme :")
        ScrollAreaGadget(#CanHordeScroll,20,55,#PanelWidth-70,145,#PanelWidth-91,165,100)
          
          TextGadget(#HordeMinUnitsText,10,13,170,14,"Minimum d'units par horde :")
          SpinGadget(#HordeMinUnits,180,10,40,20,1,20,#PB_Spin_Numeric)
          DisableGadget(#HordeMinUnits,1)
          
          TextGadget(#HordeMaxUnitsText,10,38,170,14,"Maximum d'units par horde :")
          SpinGadget(#HordeMaxUnits,180,35,40,20,1,20,#PB_Spin_Numeric)
          DisableGadget(#HordeMaxUnits,1)
          
          TextGadget(#HordeReductionText,10,63,170,14,"Rduction maximale par horde :")
          SpinGadget(#HordeReduction,180,60,40,20,1,20,#PB_Spin_Numeric)
          DisableGadget(#HordeReduction,1)
          
          TextGadget(#HordePopulationText,10,88,170,14,"Nombre d'habitants par unit :")
          SpinGadget(#HordePopulation,180,85,40,20,1,9999,#PB_Spin_Numeric)
          DisableGadget(#HordePopulation,1)
          
          TextGadget(#HordeCharacterText,10,113,170,14,"Nombre minimum de gnraux :")
          SpinGadget(#HordeCharacter,180,110,40,20,1,20,#PB_Spin_Numeric)
          DisableGadget(#HordeCharacter,1)
          
          TextGadget(#HordeArmyText,10,138,170,14,"Pourcentage maximum de soldats :")
          SpinGadget(#HordeArmy,180,135,40,20,0,100,#PB_Spin_Numeric)
          DisableGadget(#HordeArmy,1)
          
        CloseGadgetList()
        
        Frame3DGadget(#EmergingFrame,10,215,#PanelWidth-50,125,"mergence :")
        TextGadget(#EmergingText,20,238,100,14,"Type d'mergence :")
        ComboBoxGadget(#Emerging,130,235,140,80)
        AddGadgetItem(#Emerging,-1,"(Aucun)")
        AddGadgetItem(#Emerging,-1,"spawned_on_event")
        AddGadgetItem(#Emerging,-1,"shadowed_by")
        AddGadgetItem(#Emerging,-1,"shadowing")
        SetGadgetState(#Emerging,0)
        TextGadget(#EmergingSecondaryText,20,263,100,14,"Faction jumelle :")
        ComboBoxGadget(#EmergingSecondary,130,260,140,20)
        DisableGadget(#EmergingSecondary,1)
        CheckBoxGadget(#Reemergent,20,288,170,14,"Faction pouvant rmerger")
        CheckBoxGadget(#Undiscovered,20,313,170,14,"Faction non encore dcouverte")
        
    ;La campagne (arme, personnages, etc.)
    AddGadgetItem(#Panel,-1,"Options")
      
      TextGadget(#StartDateText,10,13,110,14,"Dbut de campagne :")
      SpinGadget(#StartDateSpin,120,10,50,20,-32768,32767,#PB_Spin_Numeric)
      ButtonGadget(#StartDateSeason,180,10,50,20,"")
      
      TextGadget(#EndDateText,10,38,110,14,"Fin de campagne :")
      SpinGadget(#EndDateSpin,120,35,50,20,-32768,32767,#PB_Spin_Numeric)
      ButtonGadget(#EndDateSeason,180,35,50,20,"Hiver")
      
      TextGadget(#TimeScaleText,10,63,95,14,"chelle temporelle :")
      SpinGadget(#TimeScale,110,60,45,20,0,10)
      TextGadget(#TimeScaleUnit,160,63,80,14,"anne(s) par tour")
      
      TextGadget(#BrigandText,10,88,105,14,"Taux de brigandage :")
      SpinGadget(#Brigand,120,85,35,20,0,999,#PB_Spin_Numeric)
      
      TextGadget(#PirateText,10,113,105,14,"Taux de piraterie :")
      SpinGadget(#Pirate,120,110,35,20,0,999,#PB_Spin_Numeric)
      
      CheckBoxGadget(#UpkeepText,10,138,235,14,"Units entrenues gratuitement dans les forts :")
      SpinGadget(#Upkeep,245,135,30,20,0,20,#PB_Spin_Numeric)
      
      TextGadget(#ScriptText,10,163,110,14,"Script de campagne :")
      StringGadget(#ScriptFile,120,160,155,20,"")
      
      Frame3DGadget(#OptionFrame,10,185,#PanelWidth-25,125,"Options avances :")
      StringGadget(#OptionText,20,205,#PanelWidth-115,20,"")
      ListViewGadget(#ListOption,20,230,#PanelWidth-115,70)
      ButtonGadget(#OptionAdd,#PanelWidth-90,205,65,45,"Ajouter")
      ButtonGadget(#OptionSuppr,#PanelWidth-90,255,65,45,"Supprimer")
      
      ButtonGadget(#ValidateAll,(#PanelWidth-140)/2,360,60,30,"Valider")
      ButtonGadget(#CancelAll,(#PanelWidth-140)/2+80,360,60,30,"Annuler")
      
    ;Fermeture de la liste
    CloseGadgetList()
    
  EndIf
  
  ;La barre de statut
  If CreateStatusBar(#Status,WindowID(#Win))
    AddStatusBarField((20+#Screen)/4)
    AddStatusBarField((20+#Screen)/4)
    AddStatusBarField((20+#Screen)/2)
    AddStatusBarField(#TotalWidth-#Screen-20)
  Else
    FatalError("Impossible d'initialiser la barre d'tat.")
  EndIf
  
  ;Le menu principal
  If CreateMenu(#Menu,WindowID(#Win))
    MenuTitle("&Projet")
      MenuItem(#Renew,"&Redmarrer..."+Chr(9)+"Ctrl+R") : AddKeyboardShortcut(#Win,#PB_Shortcut_Control|#PB_Shortcut_R,#Renew)
      MenuItem(#Save,"&Enregistrer"+Chr(9)+"Ctrl+S") : AddKeyboardShortcut(#Win,#PB_Shortcut_Control|#PB_Shortcut_S,#Save)
      MenuBar()
      MenuItem(#Quit,"&Quitter"+Chr(9)+"Ctrl+Q") : AddKeyboardShortcut(#Win,#PB_Shortcut_Control|#PB_Shortcut_Q,#Quit)
    MenuTitle("&Outils")
      MenuItem(#MapGen,"&Gnrateur de cartes..."+Chr(9)+"Ctrl+G") : AddKeyboardShortcut(#Win,#PB_Shortcut_Control|#PB_Shortcut_G,#MapGen)
      MenuItem(#BinEditor,"Lancer le &BinEditor...")
    MenuTitle("Optio&ns")
      MenuItem(#BackColor,"Co&uleur d'arrire-plan...")
    MenuTitle("&?")
      MenuItem(#Help,"&Aide..."+Chr(9)+"F1") : AddKeyboardShortcut(#Win,#PB_Shortcut_F1,#Help) : DisableMenuItem(#Menu,#Help,1)
      MenuItem(#About," &propos de...")
  Else
    FatalError("Impossible d'initialiser le menu.")
  EndIf
  
  ;L'cran fentr
  If OpenWindowedScreen(WindowID(#Win),#Offset,#Offset,#Screen,#Screen,0,0,0) : Else : FatalError("Impossible d'ouvrir l'cran fentr") : EndIf
  
  ;Cration du curseur
  CreateCursor()
  
Else
  FatalError("Impossible d'initialiser l'interface utilisateur.")
EndIf

;Initialisation de la souris
ReleaseMouse(#True) : InScreen=#False : SetCursorPos_(WindowX(#Win)+400+(#Screen+#Offset)/2,WindowY(#Win)+(#Screen+#Offset+50)/2)

;Initialisation des gadgets (cf. prfrences)

SetGadgetState(Map,1)

If Scale=1 : DisableGadget(#Unzoom,1) : EndIf
If Scale=16 : DisableGadget(#Zoom,1) : EndIf

; IDE Options = PureBasic 4.10 (Windows - x86)
; CursorPosition = 421
; Folding = A9
; DisableDebugger