
; Owner drawn button example
; netmaestro 2009


If InitNetwork() And ReceiveHTTPFile("http://purebasic.developpez.com/sources/images/buttons.png", GetTemporaryDirectory()+"buttons.png")
Else
  Debug "could not download button graphics"
  End
EndIf

Prototype AlphaBlend(hdcDest,DestX,DestY,DestW,DestH,hdcSrc,SrcX,SrcY,SrcW,SrcH,BLENDFUNCTION)
msimg32 = OpenLibrary(#PB_Any, "msimg32.dll")
Global AlphaBlend_.AlphaBlend = GetFunction(msimg32, "AlphaBlend")

Global MyButton

Enumeration
  #allbuttons
  #state_normal
  #state_pressed
  #state_disabled
EndEnumeration

UsePNGImageDecoder()
UsePNGImageEncoder()
LoadImage(#allbuttons, GetTemporaryDirectory()+"buttons.png")
SaveImage(#allbuttons, "l:\buttons.png", #PB_ImagePlugin_PNG)
GrabImage(#allbuttons, #state_normal, 0,0,64,64)
GrabImage(#allbuttons, #state_pressed, 64,0,64,64)
GrabImage(#allbuttons, #state_disabled, 128,0,64,64)

Procedure WinProc(hwnd, msg, wparam, lparam)
  result = #PB_ProcessPureBasicEvents

  Select msg
    Case #WM_DRAWITEM
      *dis.DRAWITEMSTRUCT = lparam
      Select *dis\CtlID
        Case MyButton
          If *dis\itemState & #ODS_SELECTED ; Button is pressed
            hdc = *dis\hDC
            hdcin = StartDrawing(ImageOutput(#state_pressed))
              AlphaBlend_(hdc, 0,0,64,64,hdcin,0,0,64,64,$1FF0000)
            StopDrawing()
          Else
            If *dis\itemState & #ODS_DISABLED
              hdc = *dis\hDC
              hdcin = StartDrawing(ImageOutput(#state_disabled))
                AlphaBlend_(hdc, 0,0,64,64,hdcin,0,0,64,64,$1FF0000)
              StopDrawing()
            Else
              hdc = *dis\hDC
              hdcin = StartDrawing(ImageOutput(#state_normal))
                AlphaBlend_(hdc, 0,0,64,64,hdcin,0,0,64,64,$1FF0000)
              StopDrawing()
            EndIf
         EndIf     
     EndSelect
     
  EndSelect
  ProcedureReturn result
EndProcedure

OpenWindow(0,0,0,320,240,"Ownerdrawn Button Sample",#PB_Window_ScreenCentered|#PB_Window_SystemMenu)
SetWindowCallback(@WinProc())
ContainerGadget(0, 120,50,68,68)
hRgn = CreateEllipticRgn_(0,0,68,68)
SetWindowRgn_(GadgetID(0),hRgn, 1)
  MyButton = ButtonGadget(#PB_Any, 1,1,64,64,"",#BS_OWNERDRAW)
CloseGadgetList()
ButtonGadget(1, 110,200,110,20,"Dis/Enable TEST")

state=0
Repeat
  EventID = WaitWindowEvent()
 
  Select EventID
    Case #PB_Event_Gadget
      Select EventGadget()
        Case MyButton
          Debug "Test pushed"
        Case 1
          state=1-state
          DisableGadget(MyButton, state)
      EndSelect
  EndSelect   

Until EventID=#PB_Event_CloseWindow

CloseLibrary(msimg32)

End

; IDE Options = PureBasic 4.51 (Windows - x64)
; CursorPosition = 25
; Folding = -
; EnableXP