XIncludeFile "IA.pbi"

Procedure NewIAObject()
  Protected *object.s_IA
  Define i
  
  ;Attempt To allocate memory For a new class template.
  *object = AllocateMemory(SizeOf(s_IA))
  If *object
    ;Make sure the *vTable field points to our virtual table.
    *object\vTable = ?VTable_IAClass
  EndIf
  ;Return a pointer to our object.
  ProcedureReturn *object
EndProcedure

Procedure IAClass_Destroy(*This.s_IA)
  FreeMemory(*This)
EndProcedure

Procedure IAclass_calcScore(*This.s_IA, cntpion, cntjoueur)

  ;On regarde le nombre de pions

  Select cntpion
    
    Case 1
      ProcedureReturn 10*cntjoueur
    Case 2
      ProcedureReturn 30*cntjoueur
    Default
      ProcedureReturn 0
  EndSelect  
EndProcedure

Procedure IAClass_evalue(*This.s_IA, *jeu.i_Jeu)

  Define score=0

  Define cntjoueur, cntpion
  Define i, j

  ;Si le jeu est fini
  If *jeu\getFini()
 
    ;Si l'IA a gagn, on retourn 1000 - le nombre de pions
    If *jeu\getTypeGagne() = *This\joueurCourant
        
      ProcedureReturn 1000-IAClass_comptePions(*This, *jeu)
        
    ElseIf *jeu\getTypeGagne() = #Vide
    
      ;Egalite -> on retourne 0
      ProcedureReturn 0
	    
    Else
	  
	    ;Si l'IA a perdu, on retourne -1000 + le nombre de pions
	    ProcedureReturn -1000+IAClass_comptePions(*This, *jeu)
		    
    EndIf
 
 EndIf
 

  ;Diagonale 1
  cntpion=0
  cntjoueur=0
  ;On regarde chaque Case
  For i=0 To 2
      
    ;Si la Case n'est pas vide
    If Not *jeu\estVide(i,i)
        
      ;On incrmente d'un pion
      cntpion + 1
      ;Si c'est le mme type du joueur courant
      If *jeu\getCase(i,i)=*This\joueurCourant
		    ;On incrmente le compteur
        cntjoueur + 1
      Else
 	      ;On dcrmente le compteur
        cntjoueur - 1
      EndIf  
          
    EndIf   
  
  Next i 

  ;On ajoute au score cette nouvelle participation
  score + IAclass_calcScore(*This, cntpion, cntjoueur)

  ;Diagonale 2
  cntpion=0
  cntjoueur=0
  For i=0 To 2
     
    If Not *jeu\estVide(i,2-i)
      cntpion + 1
      If *jeu\getCase(i,2-i)=*This\joueurCourant
        cntjoueur + 1
      Else
        cntjoueur - 1
      EndIf
    EndIf   
  Next i

  ;On ajoute au score cette nouvelle participation
  score +  IAclass_calcScore(*This, cntpion, cntjoueur)

    ;Lignes
    For i=0 To 2
        
      cntpion = 0
      cntjoueur = 0
      For j=0 To 2
          
        If *jeu\getCase(i,j)<>#Vide
            
            cntpion + 1
            If *jeu\getCase(i,j)=*This\joueurCourant
                cntjoueur + 1
            Else
                cntjoueur - 1
            EndIf
        EndIf
      Next j   
  
      score + IAclass_calcScore(*This, cntpion, cntjoueur)
   Next i

  ;Colonnes
  For i=0 To 2
      
    cntpion = 0
    cntjoueur = 0
    For j=0 To 2
        
      If *jeu\getCase(j,i)<>#Vide
          
        cntpion + 1
        If *jeu\getCase(j,i)=*This\joueurCourant
          cntjoueur + 1
        Else
          cntjoueur - 1
        EndIf
       EndIf   
    Next j
  
    score + IAclass_calcScore(*This, cntpion, cntjoueur)
  Next i

    ProcedureReturn score
EndProcedure

Procedure IAClass_comptePions(*This.s_IA, *jeu.i_Jeu)

  Define i,j,cnt=0
  For i=0 To 2
    For j=0 To 2
      If *jeu\getCase(i,j)<>#Vide
        cnt + 1
      EndIf
    Next j
   Next i       
  ProcedureReturn cnt
EndProcedure

Procedure IAClass_calcIA(*This.s_IA,  *jeu.i_Jeu, prof)

  Define i,j,tmp
  Define maxi=-1, maxj=-1
  Define alpha = #MINEVAL
  Define beta = #MAXEVAL

  ;Mettre le compteur  zro
  *this\evalue_cnt = 0
        
  ;On met en place le joueur courant
  *This\joueurCourant = *jeu\getTour()
  
  ;Si la profondeur est nulle ou la partie est finie,
  ;on ne fait pas le calcul
  If prof<>0 Or Not *jeu\getFini()
    
    ;On parcourt les cases du morpion
    For i=0 To 2
      For j=0 To 2
        
        ;Si la Case est vide
        If *jeu\estVide(i,j)
            
          ;On simule qu'on joue cette case
          *jeu\joue(i,j)
          ;On appelle la fonction calcMin pour lancer l'IA
          tmp = IAClass_calcMin(*This, *jeu, prof-1, alpha, beta)

          ;Si ce score est plus grand
          If alpha<tmp 
            ;On le choisit
            alpha = tmp
            maxi = i
            maxj = j
          EndIf    
      
          ;On annule le coup
          *jeu\annuleCoup(i,j)
        EndIf
      Next j
    Next i   
  EndIf

  ;On jouera le coup maximal
  *jeu\joue(maxi, maxj)
EndProcedure
  
Procedure IAclass_calcMin(*This.s_IA, *jeu.i_Jeu, prof, alpha, beta)

  Define i, j, tmp

  ;Si on est  la profondeur voulue, on retourne l'valuation
  If prof=0
    tmp = IAClass_evalue(*This, *jeu)
    ProcedureReturn tmp
  EndIf  

  ;Si la partie est finie, on retourne l'valuation de jeu
  If *jeu\getFini()
    tmp = IAClass_evalue(*This, *jeu)
    ProcedureReturn tmp
  EndIf

 
  ;On parcourt le plateau de jeu et on le joue si la Case est vide
  For i=0 To 2
    For j=0 To 2
            
      If *jeu\estVide(i,j)
                
		    ;On joue le coup
        *jeu\joue(i,j)
        tmp = IAClass_calcMax(*This, *jeu, prof-1, alpha, beta)
				;On annule le coup
        *jeu\annuleCoup(i,j)

		    ;Mis a jour de beta
		    If beta>tmp
		      beta = tmp
		    EndIf

		    If beta<=alpha
				  ProcedureReturn beta
			  EndIf
			  
      EndIf 
           
    Next j
  Next i         
  ProcedureReturn beta
EndProcedure

Procedure IAClass_calcMax(*This.s_IA, *jeu.i_Jeu, prof, alpha, beta)

  Define i, j, tmp

  ;Si on est  la profondeur voulue, on retourne l'valuation
  If prof=0
    tmp = IAClass_evalue(*This, *jeu)
    ProcedureReturn tmp
  EndIf 
  
  ;Si la partie est finie, on retourne l'valuation de jeu
  If *jeu\getFini()
    tmp = IAClass_evalue(*This, *jeu)
    ProcedureReturn tmp
  EndIf   
  
  ;On parcourt le plateau de jeu et on le joue si la Case est vide
  For i=0 To 2
    For j=0 To 2
            
      If *jeu\estVide(i,j)
            
        ;On joue le coup    
        *jeu\joue(i,j)
        tmp = IAClass_calcMin(*This, *jeu, prof-1, alpha, beta)
		    ;On annule le coup
        *jeu\annuleCoup(i,j)
			
		    ;Mis a jour de la valeur de alpha
		    If alpha<tmp
		      alpha = tmp
		    EndIf    

		    If beta <= alpha
		      ProcedureReturn alpha
		    EndIf    
      
      EndIf
     
    Next j
  Next i          
    
  ProcedureReturn alpha
EndProcedure
; IDE Options = PureBasic 4.30 (Windows - x86)
; CursorPosition = 232
; FirstLine = 229
; Folding = --
; EnableXP