; /*
; Copyright (C) 2006 BEYLER Jean Christophe
; 
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; As published by the Free Software Foundation; either version 2
; of the License, Or (at your option) any later version.
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY Or FITNESS For A PARTICULAR PURPOSE.  See the
; GNU General Public License For more details.
; 
; You should have received a copy of the GNU General Public License
; along With this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
; */

XIncludeFile "Jeu.pbi"
XIncludeFile "Objet.pb"

Procedure NewJeuObject()
  Protected *object.s_Jeu
  Define i
  
  ;Attempt To allocate memory For a new class template.
  *object = AllocateMemory(SizeOf(s_Jeu))
  If *object
    ;Make sure the *vTable field points to our virtual table.
    *object\vTable = ?VTable_JeuClass
    
    For i=0 To 8
      *object\Plateau[i] = NewObjetObject() 
    Next i
      
    ;Vider jeu
    JeuClass_videJeu(*object)
    
    ;Valeur par dfaut pour les surfaces
    *object\o=#Null
    *object\x=#Null
    *object\gagneo=#Null
    *object\gagnex=#Null
    *object\bg=#Null
    
    ;Type des joueurs
    *object\j2 = #Humain
    *object\j1 = #Difficile    
  EndIf
  ;Return a pointer to our object.
  ProcedureReturn *object
EndProcedure


Procedure JeuClass_Destroy(*This.s_Jeu)
  Define i
  ;On libre les surfaces 
  If IsSprite(*This\vide) : FreeSprite(*This\vide) : *This\vide = #Null : EndIf
  If IsSprite3D(0) : FreeSprite3D(0) : EndIf
  If IsSprite(*This\o) : FreeSprite(*This\o) : *This\o = #Null : EndIf
  If IsSprite(*This\bg): FreeSprite(*This\bg): *This\bg = #Null : EndIf
  If IsSprite(*This\x) : FreeSprite(*This\x) : *This\x = #Null : EndIf
  If IsSprite(*This\gagnex) : FreeSprite(*This\gagnex) : *This\gagnex = #Null : EndIf 
  If IsSprite(*This\gagneo) : FreeSprite(*This\gagneo) : *This\gagneo = #Null : EndIf
  For i=0 To 8
    *This\Plateau[i]\Destroy()
  Next i
  FreeMemory(*This)      
EndProcedure

Procedure JeuClass_init(*This.s_Jeu, file.s)
  Define r.s_rect
  Define n, fichier
  Define nom.s
  Define i
  
  ;Ouverture du fichier de paramtrage
   fichier = ReadFile(0, file)

  ;Test sur l'ouverture de la fonction
  If fichier = #Null
    MessageRequester("Erreur", "Erreur dans l'ouverture de " + file, #PB_MessageRequester_Ok)
    ProcedureReturn #False
  EndIf 

  ;Vrification de l'allocation des surfaces
  If *This\vide<>#Null
    FreeSprite(*This\vide)
    *This\vide = #Null
  EndIf 
  
  If *This\o<>#Null
    FreeSprite(*This\o)
    *This\o = #Null
  EndIf 

  If *This\x<>#Null
    FreeSprite(*This\x)
    *This\x = #Null
  EndIf 
  
  If *This\bg<>#Null
    FreeSprite(*This\bg)
    *This\bg = #Null
  EndIf 

  If *This\gagneo<>#Null
    FreeSprite(*This\gagneo)
    *This\gagneo = #Null
  EndIf 

  If *This\gagnex<>#Null
    FreeSprite(*This\gagnex)
    *This\gagnex = #Null
  EndIf 

    
  ;On charge toutes les images dans les surfaces associes
  nom = ReadString(0)
  *This\bg = LoadSprite(#PB_Any, nom)
  nom = ReadString(0)
  *This\vide = LoadSprite(#PB_Any, nom, #PB_Sprite_Texture) 
  nom = ReadString(0)
  *This\o = LoadSprite(#PB_Any, nom)
  nom = ReadString(0)
  *This\x = LoadSprite(#PB_Any, nom)
  nom = ReadString(0)
  *This\gagneo = LoadSprite(#PB_Any, nom)
  nom = ReadString(0)
  *This\gagnex = LoadSprite(#PB_Any, nom)
		
  ;On teste le retour du chargement
  If (*This\vide=#Null) Or (*This\o=#Null) Or (*This\x=#Null) Or (*This\bg=#Null) Or (*This\gagneo=#Null) Or (*This\gagnex=#Null)
    CloseFile(0)	
  	MessageRequester("Erreur", "Probleme de chargement de la case vide, du O, du X, de l'image de fond et des surfaces gagnees", #PB_MessageRequester_Ok)
   	ProcedureReturn #False
  EndIf 
    
  ;On initialise le premier tour: ce sera Rond qui commencera
  *This\tour = #Rond
 
  ;Mis en place de la transparence
  TransparentSpriteColor(*This\vide,$FFFFFF) ; adapter selon le fond transparent des sprites
 
  ;Cration d'un sprite 3d pour la case vide, la transparence est plus rapide avec ce type de sprite
  CreateSprite3D(0,*This\vide)  

  ;Dbut du code d'initialisation 
  ;Mettre en place la largeur et la hauteur d'une Case     
  nom = ReadString(0)
  r\w = Val(StringField(nom,1," "))
  r\h = Val(StringField(nom,2," "))


  ;Initialisation de chaque Case
  For i=0 To 8
    nom = ReadString(0)
    r\x = Val(StringField(nom,1," "))
    r\y = Val(StringField(nom,2," "))

	  ;On initialise les positions de chaque Case
	  *This\plateau[i]\setPos(@r)
	  ;On initialise les images de chaque Case
    *This\plateau[i]\setImage(*This\vide, *This\o, *This\x, *This\gagneo, *This\gagnex)
	Next i
	
	CloseFile(0)	
	    
  ProcedureReturn #True
EndProcedure

Procedure JeuClass_videJeu(*This.s_Jeu)

  Define i

  ;On met toutes les cases  Vide
  For i=0 To 8
    *This\plateau[i]\init()
  Next i        

  ;On commence par Rond
  *This\tour = #Rond

  ;On met fini  false
  *This\fini = #False
EndProcedure

Procedure Jeuclass_clic(*This.s_Jeu, x, y)

  Define n
  Define trouve=#False
  
  ;Si le jeu n'est pas fini 
  If Not *This\fini
        
		
    ;On parcourt tout le plateau pour trouver la Case associe
    While Not trouve And n<9 
  
      ;Si le clic a touch cette Case
      If *This\plateau[n]\estDedans(x,y)
        
        ;Si la Case est vide
        If *This\plateau[n]\estVide()
    	    
    	    ;On met le type  jour
          *This\plateau[n]\setType(*This\tour)
          
          ;On met  jour le tour
          If *This\tour=#Rond
            *This\tour = #Croix
          Else
            *This\tour = #Rond
          EndIf
      
        EndIf
  	    
  	    ;On dit qu'on a trouv la case associ
        trouve = #True
   
      EndIf
      
      n + 1    

    Wend
    
  EndIf
      
  ;Si le clic a touch une Case, il faudra vrifier si la partie est termine
  If trouve
    verifFini(*This)
  EndIf
         
EndProcedure
                        
Procedure JeuClass_aff(*This.s_Jeu)

  Define n
  
  ;Dessiner le fond d'ecran
  DisplaySprite(*This\bg,0,0)

  ;Dessiner chaque case
  For n=0 To 8
    *This\plateau[n]\affiche()
  Next n
EndProcedure

;Fonction qui retourne le joueur courant
Procedure Jeuclass_getTypeGagne(*This.s_Jeu)
  ProcedureReturn *This\typegagne
EndProcedure

Procedure JeuClass_getTour(*This.s_Jeu)
  ProcedureReturn *This\tour
EndProcedure

Procedure JeuClass_getFini(*This.s_Jeu)
  ProcedureReturn *This\fini
EndProcedure

Procedure verifFini(*This.s_Jeu)

	Define casevide = #False
	Define i, j

  ;Remet cette variable  zro
  *This\typegagne = #Vide
  *This\fini = #False

	;Lignes
	For i=0 To 2
	
		If *This\plateau[i*3+0]\estVide()=0 

			If *This\plateau[i*3+0]\memeType(*This\plateau[i*3+1]) And *This\plateau[i*3+0]\memeType(*This\plateau[i*3+2])
        
  				
				*This\fini = #True
				*This\typegagne = *This\plateau[i*3]\getType()
				*This\plateau[i*3+0]\setType(#Gagne)
				*This\plateau[i*3+1]\setType(#Gagne)
				*This\plateau[i*3+2]\setType(#Gagne)

			EndIf
		Else
			casevide = #True
		EndIf	
	Next i

	;Colonnes
	For i=0 To 2
	
		If Not *This\plateau[0*3+i]\estVide() 

			If *This\plateau[0*3+i]\memeType(*This\plateau[1*3+i]) And *This\plateau[0*3+i]\memetype(*This\plateau[2*3+i])
				
				*This\fini = #True
				*This\typegagne = *This\plateau[0*3+i]\getType()
				*This\plateau[0*3+i]\setType(#Gagne)
				*This\plateau[1*3+i]\setType(#Gagne)
				*This\plateau[2*3+i]\setType(#Gagne)
				
			EndIf
		Else
			casevide = #True
		EndIf	
	Next i

	;Diagonales
	If Not *This\plateau[0*3+0]\estVide()
		
			If *This\plateau[0*3+0]\memeType(*This\plateau[1*3+1]) And *This\plateau[0*3+0]\memeType(*This\plateau[2*3+2])
			
				*This\fini = #True
				*This\typegagne = *This\plateau[0*3+0]\getType()
				*This\plateau[0*3+0]\setType(#Gagne)
				*This\plateau[1*3+1]\setType(#Gagne)
				*This\plateau[2*3+2]\setType(#Gagne)
			
		  EndIf
	Else
		casevide = #True
	EndIf 	

	If Not *This\plateau[2*3+0]\estVide()
		
			If *This\plateau[2*3+0]\memeType(*This\plateau[1*3+1]) And *This\plateau[2*3+0]\memeType(*This\plateau[0*3+2])
			
				*This\fini = #True
				*This\typegagne = *This\plateau[2*3+0]\getType()
				*This\plateau[2*3+0]\setType(#Gagne)
				*This\plateau[1*3+1]\setType(#Gagne)
				*This\plateau[0*3+2]\setType(#Gagne)
			EndIf
		
	Else
		casevide = #True
  EndIf
  
	;Dernires cases  vrifier pour le boolen casevide
	If *This\plateau[1*3+1]\estVide() Or *This\plateau[1*3+2]\estVide() Or *This\plateau[2*3+1]\estVide() Or *This\plateau[2*3+2]\estVide()
		casevide = #True
  EndIf
  
  If casevide = #False
    *This\fini = #True
  EndIf

EndProcedure

;Fonctions pour l'IA
;Est-ce que le joueur courant est humain
Procedure Jeuclass_estHumain(*This.s_Jeu)

  If *This\tour=#Rond
    If *This\j1=#Humain
      ProcedureReturn #True
    Else
      ProcedureReturn #False
    EndIf
  Else
    If *This\j2=#Humain
      ProcedureReturn #True
    Else
      ProcedureReturn #False
    EndIf
  EndIf    
EndProcedure

;Fonction qui retourne le type du joueur
Procedure JeuClass_getTypeJoueur(*This.s_Jeu)

	If *This\tour=#Rond
		ProcedureReturn *This\j1
	Else
		ProcedureReturn *This\j2
	EndIf	
EndProcedure

;Fonction qui retourne l'tat de la case
Procedure JeuClass_estVide(*This.s_Jeu, i, j)
  ProcedureReturn *This\plateau[i*3+j]\estVide()
EndProcedure

Procedure Jeuclass_getCase(*This.s_Jeu, i, j)
  ProcedureReturn *This\plateau[i*3+j]\getType()
EndProcedure

;Fonction qui joue la Case (i,j)
Procedure JeuClass_joue(*This.s_Jeu, i, j)
  *This\plateau[i*3+j]\setType(*This\tour)
  If *This\tour=#Rond
    *This\tour = #Croix
  Else
    *This\tour = #Rond
  EndIf

  verifFini(*This)
EndProcedure

Procedure Jeuclass_annuleCoup(*This.s_Jeu, a, b)
  Define i, j
  
  *This\plateau[a*3+b]\setType(#Vide)
  For i=0 To 8
    *This\plateau[i]\setType(*This\plateau[i]\getType())
  Next i  
  If *This\tour=#Rond
    *This\tour = #Croix
  Else
    *This\tour = #Rond
  EndIf

  verifFini(*This)
EndProcedure

;Fonction qui met en place le type des joueurs
Procedure JeuClass_setTypeJoueur(*This.s_Jeu, i, type)

	If i=1
		
		*This\j1 = type
		
	Else
		
		*This\j2 = type
	EndIf
EndProcedure

; IDE Options = PureBasic 4.30 (Windows - x86)
; CursorPosition = 330
; FirstLine = 297
; Folding = ---
; EnableXP