; /*
; Copyright (C) 2006 BEYLER Jean Christophe
; 
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; As published by the Free Software Foundation; either version 2
; of the License, Or (at your option) any later version.
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY Or FITNESS For A PARTICULAR PURPOSE.  See the
; GNU General Public License For more details.
; 
; You should have received a copy of the GNU General Public License
; along With this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
; */

XIncludeFile "Define.pbi"
XIncludeFile "Objet.pbi"

Enumeration 
 #Humain
 #Facile
 #Moyen
 #Difficile
EndEnumeration

Interface i_Jeu
  Destroy()              ;Destructeur 
  init(file.s)           ;Fonction d'initialisation (chargement des surfaces)
  clic(x, y)             ;Gestion du jeu lors d'un clic
  aff()                  ;Fonction d'affichage
  videJeu()              ;Fonction qui vide le plateau de jeu  
  getFini()              ;Fonction qui retourne la valeur de fini   
  getTour()              ;Fonction qui retourne le joueur courant  
  getTypeGagne()         ;Fonction qui retourne qui a gagn 
  getCase(i, j)          ;Fonction qui retourne le type de la Case 
  estHumain()            ;Fonction qui retourne si le joueur courant est un humain  
  getTypeJoueur()        ;Fonction qui retourne le type du joueur courant 
  estVide(i, j)          ;Fonction qui retourne l'tat de la case 
  joue(i, j)             ;Fonction qui joue la Case (i,j)  
  annuleCoup(a, b)       ;Fonction qui annule le dernier coup 
  setTypeJoueur(i, type) ;Fonction qui met en place le type des joueurs    
EndInterface

Structure s_Jeu
  *vTable  
  plateau.i_Objet[9] ;Le plateau jeu
  vide.i       ;Surfaces de la Case vide, d'un rond, d'une croix, d'un fond et les surfaces gagnantes  
  o.i          
  x.i
  bg.i 
  gagneo.i
  gagnex.i
  tour.i       ;Variables pour un tour et pour savoir qui a gagn
  typegagne.i
  fini.i       ;Variable pour savoir si la partie est termine
  j1.i         ;Type des joueurs (humain/ordi)
  j2.i  
EndStructure

Declare verifFini(*This.s_Jeu)           ; Fonction pour vrifier si la partie est termine
Declare JeuClass_Destroy(*This.s_Jeu)
Declare JeuClass_init(*This.s_Jeu, file.s)
Declare JeuClass_clic(*This.s_Jeu, x, y)
Declare JeuClass_aff(*This.s_Jeu)
Declare JeuClass_videJeu(*This.s_Jeu)
Declare JeuClass_getFini(*This.s_Jeu)
Declare JeuClass_getTour(*This.s_Jeu)                ;Fonction qui retourne le joueur courant  
Declare JeuClass_getTypeGagne(*This.s_Jeu)           ;Fonction qui retourne qui a gagn 
Declare JeuClass_getCase(*This.s_Jeu, i, j)          ;Fonction qui retourne le type de la Case 
Declare JeuClass_estHumain(*This.s_Jeu)              ;Fonction qui retourne si le joueur courant est un humain  
Declare JeuClass_getTypeJoueur(*This.s_Jeu)          ;Fonction qui retourne le type du joueur courant 
Declare JeuClass_estVide(*This.s_Jeu, i, j)          ;Fonction qui retourne l'tat de la case 
Declare JeuClass_joue(*This.s_Jeu, i, j)             ;Fonction qui joue la Case (i,j)  
Declare JeuClass_annuleCoup(*This.s_Jeu, a, b)       ;Fonction qui annule le dernier coup 
Declare JeuClass_setTypeJoueur(*This.s_Jeu, i, type) ;Fonction qui met en place le type des joueurs  

DataSection
  VTable_JeuClass: 
  Data.i @JeuClass_Destroy()         ;Destructeur 
  Data.i @JeuClass_init()            ;Fonction d'initialisation (chargement des surfaces)
  Data.i @JeuClass_clic()            ;Gestion du jeu lors d'un clic
  Data.i @JeuClass_aff()             ;Fonction d'affichage
  Data.i @JeuClass_videJeu()         ;Fonction qui vide le plateau de jeu
  Data.i @JeuClass_getFini()         ;Fonction qui retourne la valeur de fini 
  Data.i @JeuClass_getTour()         ;Fonction qui retourne le joueur courant  
  Data.i @JeuClass_getTypeGagne()    ;Fonction qui retourne qui a gagn 
  Data.i @JeuClass_getCase()         ;Fonction qui retourne le type de la Case 
  Data.i @JeuClass_estHumain()       ;Fonction qui retourne si le joueur courant est un humain  
  Data.i @JeuClass_getTypeJoueur()   ;Fonction qui retourne le type du joueur courant 
  Data.i @JeuClass_estVide()         ;Fonction qui retourne l'tat de la case 
  Data.i @JeuClass_joue()            ;Fonction qui joue la Case (i,j)  
  Data.i @JeuClass_annuleCoup()      ;Fonction qui annule le dernier coup 
  Data.i @JeuClass_setTypeJoueur()   ;Fonction qui met en place le type des joueurs         
EndDataSection       
; IDE Options = PureBasic 4.30 (Windows - x86)
; CursorPosition = 76
; FirstLine = 40
; Folding = -
; EnableXP