; /*
; Copyright (C) 2006 BEYLER Jean Christophe
; 
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; As published by the Free Software Foundation; either version 2
; of the License, Or (at your option) any later version.
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY Or FITNESS For A PARTICULAR PURPOSE.  See the
; GNU General Public License For more details.
; 
; You should have received a copy of the GNU General Public License
; along With this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
; */
; 
; /*
;  * Fichier de base pour ouvrir une fenetre SDL, si l'utilisateur appuie sur 'q', on quitte le programme
;  */

EnableExplicit

XIncludeFile "Main.pbi"
XIncludeFile "Moteur.pb"

moteur = NewMoteurObject()
  
main()

End

Procedure main()

  ;Initialisation 
  If InitSprite()=0 Or InitSprite3D()=0 Or InitKeyboard()=0 
    MessageRequester("Erreur", "Probleme pour initialiser directx", #PB_MessageRequester_Ok)
    End
  EndIf


  ;Ouvrerture d'une surface pour l'affichage de la fentre
  If OpenWindow(0, 0, 0, #WIDTH, #HEIGHT, "Morpion Version 1.0")=0
    MessageRequester("Erreur", "Erreur  l'ouverture d'une fentre", #PB_MessageRequester_Ok)
    End
  EndIf
  
  If OpenWindowedScreen(WindowID(0),0, 0, #WIDTH, #HEIGHT, 1, 0, 0) = 0
    MessageRequester("Erreur", "Erreur  l'ouverture d'un cran", #PB_MessageRequester_Ok)
    End  
  EndIf

  KeyboardMode(#PB_Keyboard_International) 
  ;Dclaration des variables
  Define event, done = 0

  ;Initialiser le jeu
  If moteur\init()=0
    ProcedureReturn 1
  EndIf      
        
  ;Boucle generale
  While done=0

    ;Traiter les vnements
    
    Repeat
      
      Event = WindowEvent()
      
      Select event
      
        ;Si on veut quitter, done=1 suffira
        Case #PB_Event_CloseWindow
          done=1
        Case #WM_LBUTTONUP 
          moteur\clic(WindowMouseX(0), WindowMouseY(0))   
      EndSelect
  
    Until Event=0         
    
    
    If ExamineKeyboard()
    
      If KeyboardReleased(#PB_Key_Escape)
        moteur\echangeFonctions()
      ElseIf KeyboardReleased(#PB_Key_Q)
        moteur\fin()   
      EndIf
   
    EndIf
   
    moteur\aff()
    moteur\verif()
    FlipBuffers()
    
    Delay(20)
        
  Wend
  
  Moteur\Destroy()
  
EndProcedure




; IDE Options = PureBasic 4.30 (Windows - x86)
; CursorPosition = 56
; FirstLine = 51
; Folding = -
; EnableXP