XIncludeFile "Menu.pbi"

Procedure NewMenuObject()
  Protected *object.s_Menu
  Define i
  
  ;Attempt To allocate memory For a new class template.
  *object = AllocateMemory(SizeOf(s_Menu))
  If *object
    ;Make sure the *vTable field points to our virtual table.
    *object\vTable = ?VTable_MenuClass

  	For i=0 To 3
  		*object\images[i] = #Null
  	Next i	
	  For i=0 To 3
		  *object\typejoueur[i] = #Null
    Next i
	  *object\txtj[0] = #Null
	  *object\txtj[1] = #Null
	  ;Par dfaut, le joueur 1 est humain et le joueur 2 est de niveau moyen
	  *object\typej1=0
	  *object\typej2=1  	
  EndIf
  ;Return a pointer to our object.
  ProcedureReturn *object
EndProcedure

Procedure MenuClass_Destroy(*This.s_Menu)
	Define i
	For i=0 To 3
	  If IsSprite(*This\images[i]) : FreeSprite(*This\images[i]) : EndIf
		*This\images[i] = #Null
  Next i
  

	For i=0 To 3
	  If IsSprite(*This\typejoueur[i]) : FreeSprite(*This\typejoueur[i]) : EndIf
		*This\typejoueur[i] = #Null		
	Next i
	If IsSprite(*This\txtj[0]) : FreeSprite(*This\txtj[0]) : EndIf
	*This\txtj[0] = #Null	
	If IsSprite(*This\txtj[1]) : FreeSprite(*This\txtj[1]) : EndIf
	*This\txtj[1] = #Null	
	  
	FreeMemory(*This)
EndProcedure

;Fonction affichage erreur lors de l'init
Procedure ErreurInit(fichier, message.s)
  CloseFile(fichier)
  MessageRequester("Erreur", message, #PB_MessageRequester_Ok)
EndProcedure

;Fonction d'initialisation
Procedure  Menuclass_init(*This.s_Menu, file.s)
  
  Define i
	Define fichier
	;Ouverture du fichier de paramétrage
	fichier = ReadFile(0, file)

	;Test si le fichier s'est bien ouvert
	If fichier= #Null
 	  MessageRequester("Erreur", "Erreur dans l'ouverture du fichier " + file, #PB_MessageRequester_Ok)
	  ProcedureReturn #False
  EndIf

	Define nom.s
	
	;Rcupration du nom de l'image pour le menu
	nom = ReadString(0)
	;On charge l'image de fond
	*This\images[0] = LoadSprite(#PB_Any, nom)
	
	;On rcupre la surface de l'image "Titre"
	nom = ReadString(0)
	*This\images[1] = LoadSprite(#PB_Any, nom)
	
	;Initialisation des positions du menu
	nom = ReadString(0)
	*This\titre\x = Val(StringField(nom,1," "))
	*This\titre\y = Val(StringField(nom,2," "))

	;On rcupre la surface de l'image "Nouveau"
	nom = ReadString(0)
	*This\images[2] = LoadSprite(#PB_Any, nom)
	
	;Initialisation de la position du bouton nouveau
	nom = ReadString(0)
	*This\nouveau\x = Val(StringField(nom,1," "))
	*This\nouveau\y = Val(StringField(nom,2," "))

	;On rcupre la surface de l'image "Quitter"
	nom = ReadString(0)
	*This\images[3] = LoadSprite(#PB_Any, nom)

	;Initialisation de la position du bouton quitter
	nom = ReadString(0)
	*This\quitter\x = Val(StringField(nom,1," "))
	*This\quitter\y = Val(StringField(nom,2," "))

	;On teste le retour du chargement
	Define i
	For i=0 To 3
		If *This\images[i]=#Null
    	ErreurInit(0, "Probleme de chargement d'une des images du menu")
    	ProcedureReturn #False
		EndIf
	Next i	    	

	;Mise en place de la transparence	
  ;TransparentSpriteColor() ; adapter selon le fond transparent des sprites  
		
	;On rcupre la taille des images
	*This\nouveau\w = SpriteWidth(*This\images[2])
	*This\nouveau\h = SpriteHeight(*This\images[2])
	
	*This\quitter\w = SpriteWidth(*This\images[3])
	*This\quitter\h = SpriteHeight(*This\images[3])

  ;On rcupre les surfaces des positions textes pour le joueur 1 et pour le joueur 2
		nom = ReadString(0)
	*This\txtj[0] = LoadSprite(#PB_Any, nom)
	nom = ReadString(0)
	*This\postxtj1\x = Val(StringField(nom,1," "))
	*This\postxtj1\y = Val(StringField(nom,2," "))

		nom = ReadString(0)
	*This\txtj[1] = LoadSprite(#PB_Any, nom)
	nom = ReadString(0)
	*This\postxtj2\x = Val(StringField(nom,1," "))
	*This\postxtj2\y = Val(StringField(nom,2," "))

	;Chargement des images pour le type des joueurs et leur position
	For i=0 To 3
	  nom = ReadString(0)

	  *This\typejoueur[i] = LoadSprite(#PB_Any, nom)

		;Test sur le chargement
		If *This\typejoueur[i]=#Null
      ErreurInit(0, "Probleme de chargement d'une image typejoueur")
      ProcedureReturn #False
    EndIf
	Next i
	
	nom = ReadString(0)
	*This\postypej1\x = Val(StringField(nom,1," "))
	*This\postypej1\y = Val(StringField(nom,2," "))
	nom = ReadString(0)
	*This\postypej2\x = Val(StringField(nom,1," "))
	*This\postypej2\y = Val(StringField(nom,2," "))		

	;Ferme le fichier
	CloseFile(0)
	
	;On retourne vrai
	ProcedureReturn #True
EndProcedure

;Gestion du clic
Procedure MenuClass_clic(*This.s_Menu, x, y)
  ;Est-ce qu'on est dans le bouton nouveau?
  If (*This\nouveau\x<x)And(*This\nouveau\x+*This\nouveau\w>x)And(*This\nouveau\y<y)And(*This\nouveau\y+*This\nouveau\h>y)
  
  	moteur\initJeu()
  	moteur\setFonctionsJeu();

  ;Est-ce qu'on est dans le bouton quitter?
  ElseIf (*This\quitter\x<x)And(*This\quitter\x+*This\quitter\w>x)And(*This\quitter\y<y)And(*This\quitter\y+*This\quitter\h>y)
  	moteur\fin()
  ;Est-ce qu'on est dans le bouton type joueur1?
  ElseIf (*This\postypej1\x<x)And(*This\postypej1\x+ SpriteWidth(*This\typejoueur[*This\typej1])>x)And(*This\postypej1\y<y)And(*This\postypej1\y+SpriteHeight(*This\typejoueur[*This\typej1])>y)
	  
	  *This\typej1 = (*This\typej1+1)%4
  ;Est-ce qu'on est dans le bouton type joueur2?
  ElseIf (*This\postypej2\x<x)And(*This\postypej2\x+SpriteWidth(*This\typejoueur[*This\typej2])>x)And(*This\postypej2\y<y)And(*This\postypej2\y+SpriteHeight(*This\typejoueur[*This\typej2])>y)
	
	*This\typej2= (*This\typej2+1)%4
	  	
  EndIf	
EndProcedure

;Fonction retourne le type des joueurs
Procedure MenuClass_getType(*This.s_Menu, i)
	If i=1
		ProcedureReturn *This\typej1
	Else
		ProcedureReturn *This\typej2
	EndIf	
EndProcedure

;Fonction d'affichage
Procedure MenuClass_aff(*This.s_Menu)
	;Si on a une image, on l'affiche
	If *This\images[0] And *This\images[1] And *This\images[2] And *This\images[3] And *This\txtj[0] And *This\txtj[1] And *This\typejoueur[*This\typej1] And *This\typejoueur[*This\typej2]
		DisplayTransparentSprite(*This\images[0], 0, 0)
		DisplayTransparentSprite(*This\images[1], *This\titre\x, *This\titre\y)
		DisplayTransparentSprite(*This\images[2], *This\nouveau\x, *This\nouveau\y)
    DisplayTransparentSprite(*This\images[3], *This\quitter\x, *This\quitter\y)
    DisplayTransparentSprite(*This\txtj[0]  , *This\postxtj1\x, *This\postxtj1\y)
    DisplayTransparentSprite(*This\txtj[1]  , *This\postxtj2\x, *This\postxtj2\y)
    DisplayTransparentSprite(*This\typejoueur[*This\typej1] , *This\postypej1\x, *This\postypej1\y)
    DisplayTransparentSprite(*This\typejoueur[*This\typej2] , *This\postypej2\x, *This\postypej2\y)    
	EndIf
EndProcedure
; IDE Options = PureBasic 4.30 (Windows - x86)
; CursorPosition = 137
; FirstLine = 134
; Folding = --
; EnableXP