; /*
; Copyright (C) 2006 BEYLER Jean Christophe
; 
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; As published by the Free Software Foundation; either version 2
; of the License, Or (at your option) any later version.
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY Or FITNESS For A PARTICULAR PURPOSE.  See the
; GNU General Public License For more details.
; 
; You should have received a copy of the GNU General Public License
; along With this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
; */

XIncludeFile "Moteur.pbi"


Procedure NewMoteurObject()
  Protected *object.s_Moteur
  Define i
  
  ;Attempt To allocate memory For a new class template.
  *object = AllocateMemory(SizeOf(s_Moteur))
  If *object
    ;Make sure the *vTable field points to our virtual table.
    *object\vTable = ?VTable_MoteurClass
    ;Cration du jeu et du menu
    *object\jeu  = NewJeuObject()
    *object\menu = NewMenuObject()
	  *object\ia   = NewIAObject()
	  ;Initialisation du boolen dansMenu
	  *object\dansMenu = #True    
  EndIf
  ;Return a pointer to our object.
  ProcedureReturn *object
EndProcedure

Procedure MoteurClass_Destroy(*This.s_Moteur)
  *This\jeu\Destroy()
  *This\menu\Destroy()
  *This\ia\Destroy()
  FreeMemory(*This)
EndProcedure

Procedure MoteurClass_init(*This.s_Moteur)

  Define fichier
	;Ouverture du fichier de paramtrage
	fichier = ReadFile(0,"data/input.txt")

	If fichier
		
		Define s1.s, s2.s
		;On rcupre les noms des fichiers pour paramtrer le jeu et le menu
		s1 = ReadString(0)
		s2 = ReadString(0)

    CloseFile(0)
    
		If *This\jeu\init(s1) And *This\menu\init(s2)
		  ProcedureReturn #True
		Else
		  ProcedureReturn #False
		EndIf 
  Else

    MessageRequester("Erreur", "Erreur dans l'ouverture de Data/input.txt", #PB_MessageRequester_Ok)    
	EndIf
		
	ProcedureReturn #False
EndProcedure

Procedure MoteurClass_clic(*This.s_Moteur,  x, y)

	;Si on est dans le menu
	If *This\dansMenu
		*This\menu\clic(x,y)
	Else
		If *This\jeu\getFini()
			*This\jeu\videJeu()
		Else
			*This\jeu\clic(x,y)
		EndIf
  EndIf			
EndProcedure

Procedure MoteurClass_aff(*This.s_Moteur)

	;Si on est dans le menu
	If *This\dansMenu
		
		*This\menu\aff()
		
	Else
		
		*This\jeu\aff()

  EndIf		
EndProcedure

Procedure MoteurClass_initJeu(*This.s_Moteur)
	*This\jeu\videJeu()
EndProcedure

Procedure MoteurClass_echangeFonctions(*This.s_Moteur)
	*This\dansMenu = 1-*This\dansMenu
	MoteurClass_misAJourTypeJoueurs(*This)
EndProcedure


Procedure MoteurClass_setFonctionsJeu(*This.s_Moteur)
	;On met dansMenu  false
	*This\dansMenu = #False
	MoteurClass_misAJourTypeJoueurs(*This)
EndProcedure

Procedure MoteurClass_setFonctionsMenu(*This.s_Moteur)
  ;On met dansMenu  true
	*This\dansMenu = #True
EndProcedure

Procedure MoteurClass_fin(*This.s_Moteur)

	;Le jeu est fini, on va mettre un vnement SDL_QUIT
	;On pourrait mettre une phase de sauvegarde ici.

  SendMessage_(WindowID(0),#WM_CLOSE,0,0)

EndProcedure

Procedure MoteurClass_verif(*This.s_Moteur)
  
  If Not *This\dansMenu
        
    If Not *This\jeu\getFini()
      
   
      ;On vrifie si c'est un ordi le joueur courant
      If Not *This\jeu\estHumain()

        Select *This\jeu\getTypeJoueur()

            
          Case #Facile
            *This\ia\calcIA(*This\jeu, 3)
  
          Case #Moyen
            *This\ia\calcIA(*This\jeu, 5)
  
          Case #Difficile
 
            *This\ia\calcIA(*This\jeu, 9)
  
        EndSelect
      EndIf
    
    EndIf

  EndIf
EndProcedure

;Fonction qui met  jour le type des joueurs
Procedure MoteurClass_misAJourTypeJoueurs(*This.s_Moteur)

	*This\jeu\setTypeJoueur(1, *This\menu\getType(1))
	*This\jeu\setTypeJoueur(2,*This\menu\getType(2))
EndProcedure








; IDE Options = PureBasic 4.30 (Windows - x86)
; CursorPosition = 110
; FirstLine = 98
; Folding = ---
; EnableXP
; DisableDebugger