; /*
; Copyright (C) 2006 BEYLER Jean Christophe
; 
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; As published by the Free Software Foundation; either version 2
; of the License, Or (at your option) any later version.
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY Or FITNESS For A PARTICULAR PURPOSE.  See the
; GNU General Public License For more details.
; 
; You should have received a copy of the GNU General Public License
; along With this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
; */

XIncludeFile "Objet.pbi"

;Constructeur
Procedure NewObjetObject()
  Protected *object.s_Objet
  Define i.i
  
  ;Attempt To allocate memory For a new class template.
  *object = AllocateMemory(SizeOf(s_Objet))
  If *object
    ;Make sure the *vTable field points to our virtual table.
    *object\vTable = ?VTable_ObjetClass
  	For i=0 To 4
  		*object\images[i] = #Null
  	Next i	
  	*object\curimage = 0
  	*object\pos\x = 0
  	*object\pos\y = 0
  	*object\pos\w = 0
  	*object\pos\h = 0
  EndIf
  ;Return a pointer to our object.
  ProcedureReturn *object
EndProcedure

;Destructeur
Procedure ObjetClass_Destroy(*This.s_Objet)
  FreeMemory(*This)
EndProcedure

;Fonction d'initialisation
Procedure ObjetClass_init(*This.s_Objet)
	;On met l'image  zro et le type est Vide
	*This\curimage = 0
	*This\type = #Vide
EndProcedure

;Mise en place de la position de l'objet
Procedure ObjetClass_setPos(*This.s_Objet, *p.s_rect)
  *This\pos\x=*p\x
  *This\pos\y=*p\y
  *This\pos\w=*p\w
  *This\pos\h=*p\h    
EndProcedure

;Mise en place des surfaces
Procedure Objetclass_setImage(*This.s_Objet, vide, o, x, gagneo, gagnex)
	*This\images[0] = vide
	*This\images[1] = o
	*This\images[2] = x
	*This\images[3] = gagneo
	*This\images[4] = gagnex
EndProcedure

;Fonction d'affichage
Procedure ObjetClass_affiche(*This.s_Objet)

	If *This\images[*This\curimage]
		If *This\curimage = #Vide
		  ;Utilisation d'un sprite 3D pour la transparence, c'est plus rapide  l'affichage
		  Start3D()
		    DisplaySprite3D(0, *This\pos\x, *This\pos\y, 180)
		  Stop3D()
		  ;DisplaySprite(*This\images[*This\curimage], *This\pos\x, *This\pos\y)
		Else
		  DisplayTransparentSprite(*This\images[*This\curimage], *This\pos\x, *This\pos\y)
		EndIf
		
	EndIf
		
EndProcedure

;Est-ce que (x,y) est dans la Case?
Procedure ObjetClass_estDedans(*This.s_Objet, x,  y)
	If ((x>*This\pos\x)And(x<*This\pos\x+*This\pos\w)And(y>*This\pos\y)And(y<*This\pos\y+*This\pos\h))
	  ProcedureReturn #True
	Else
	  ProcedureReturn #False
	EndIf   
EndProcedure

;Est-ce que la Case est vide?
Procedure ObjetClass_estVide(*This.s_Objet)
  If *This\type = #Vide
    ProcedureReturn #True
  Else
    ProcedureReturn #False
  EndIf     
EndProcedure

Procedure ObjetClass_getType(*This.s_Objet)
  ProcedureReturn *This\type
EndProcedure

;On met en place le type de la Case
Procedure Objetclass_setType(*This.s_Objet, t)
	Select t
		Case #Vide
			*This\type=t
			*This\curimage = t
		Case #Rond
			*This\type=t
			*This\curimage = t
		Case #Croix
			*This\type=t
			*This\curimage = t
		Case #Gagne
			*This\curimage = *This\type+2
  EndSelect
EndProcedure

;Est-ce que l'objet est du mme type?
Procedure ObjetClass_memeType(*This.s_Objet, *obj.s_Objet)
	If *obj\type = *This\type
	  ProcedureReturn #True
	Else
	  ProcedureReturn #False
	EndIf    
EndProcedure



; IDE Options = PureBasic 4.30 (Windows - x86)
; CursorPosition = 17
; Folding = --
; EnableXP