; /*
; Copyright (C) 2006 BEYLER Jean Christophe
; 
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; As published by the Free Software Foundation; either version 2
; of the License, Or (at your option) any later version.
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY Or FITNESS For A PARTICULAR PURPOSE.  See the
; GNU General Public License For more details.
; 
; You should have received a copy of the GNU General Public License
; along With this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
; */

;#include <vector>

XIncludeFile  "Define.pbi"

;Type d'une case
Enumeration 
  #Vide
  #Rond
  #Croix
  #Gagne
EndEnumeration

Structure s_Objet
  *vTable
  images.i[5]  ;Les surfaces des cases
  curimage.i   ;l'image  afficher 
	type.i       ;Type de la case
	pos.s_rect   ;Position de la Case
EndStructure

Interface i_Objet
  Destroy()                           ;Destructeur 
  init()                              ;Fonction d'initialisation et remise  zro
  setPos(*p.s_rect)                   ;Mise en place de la Case
  setImage(vide, o, x, gagneo, gagnex);Mise en place des images
  affiche()                           ;Fonction d'affichage
  estDedans(x, y)                     ;Est la position (x,y) est dans la Case?
  memeType(*obj.s_Objet)              ;Est-ce l'objet obj est du mme type?
  getType()                           ;On rcupre le type de l'objet
  setType(t)                          ;Mise en place du type
  estVide()                           ;Est-ce que la Case est vide?
EndInterface

Declare ObjetClass_Destroy(*This.s_Objet)               ;Destructeur 
Declare ObjetClass_init(*This.s_Objet)                  ;Fonction d'initialisation et remise  zro
Declare ObjetClass_setPos(*This.s_Objet, *p.s_rect)     ;Mise en place de la Case
Declare ObjetClass_setImage(*This.s_Objet,vide, o, x, gagneo, gagnex);Mise en place des images
Declare ObjetClass_affiche(*This.s_Objet)               ;Fonction d'affichage
Declare ObjetClass_estDedans(*This.s_Objet, x, y)       ;Est la position (x,y) est dans la Case?
Declare ObjetClass_memeType(*This.s_Objet, *obj.s_Objet);Est-ce l'objet obj est du mme type?
Declare ObjetClass_getType(*This.s_Objet)               ;On rcupre le type de l'objet
Declare ObjetClass_setType(*This.s_Objet, t)            ;Mise en place du type
Declare ObjetClass_estVide(*This.s_Objet)               ;Est-ce que la Case est vide?
  
DataSection
  VTable_ObjetClass: 
  Data.i @ObjetClass_Destroy()         ;Destructeur 
  Data.i @ObjetClass_init()            ;Fonction d'initialisation et remise  zro
  Data.i @ObjetClass_setPos()          ;Mise en place de la Case
  ;Data.i @ObjetClass_getPos()          ;Rcupration de la position
  Data.i @ObjetClass_setImage()        ;Mise en place des images
  Data.i @ObjetClass_affiche()         ;Fonction d'affichage
  Data.i @ObjetClass_estDedans()       ;Est la position (x,y) est dans la Case?
  Data.i @ObjetClass_memeType()        ;Est-ce l'objet obj est du mme type?
  Data.i @ObjetClass_getType()         ;On rcupre le type de l'objet
  Data.i @ObjetClass_setType()         ;Mise en place du type
  Data.i @ObjetClass_estVide()           ;Est-ce que la Case est vide?
EndDataSection


; #ifndef H_OBJET
; #define H_OBJET
; 
; #include <vector>
; 
; #include "Define.h"
; 
; //Type d'une case
; enum Case {
; 		Vide=0,
; 		Rond,
; 		Croix,
; 		Gagne
; 	    };
; 
; class Objet
; {
; 	private:
; 		//Les surfaces des cases
; 		std::vector<SDL_Surface *> images;
; 
; 		//L'image à afficher 
; 		int curimage;
; 
; 		//Type de la Case
; 		Case type;
; 
; 		//Position de la Case
; 		SDL_Rect pos;
; 
; 	public:
; 		//Constructeur/Destructeur
; 		Objet();
; 		~Objet();
; 
; 		//Fonction d'initialisation et remise à zéro
; 		void init();
; 
; 		//Mise en place de la Case
; 		void setPos(SDL_Rect *p);
; 		//Récupération de la position
; 		SDL_Rect *getPos();
; 
; 		//Mise en place des images
; 		void setImage(SDL_Surface *,	SDL_Surface *, 	SDL_Surface *, 	SDL_Surface *, 	SDL_Surface *);
; 
; 		//Fonction d'affichage
; 		void affiche(SDL_Surface *dest);
; 
; 		//Est la position (x,y) est dans la Case?
; 		bool estDedans(int x, int y);
; 
; 		//Est-ce l'objet obj est du même type?
; 		bool memeType(Objet &obj);
; 
; 		//On récupère le type de l'objet
; 		Case getType();
; 
; 		//Mise en place du type
; 		void setType(Case t);
; 
; 		//Est-ce que la case est vide?
; 		bool estVide();
; };
; #endif

; IDE Options = PureBasic 4.30 (Windows - x86)
; CursorPosition = 77
; FirstLine = 21
; Folding = -
; EnableXP