﻿EnableExplicit

XIncludeFile "..\RichEdit.pbi"

Enumeration ; images
  #ico_New
  #ico_Open
  #ico_Save
  #ico_Print
  #ico_Font
  #ico_Search
  #ico_Cut
  #ico_Copy
  #ico_Paste
  #ico_Undo
  #ico_Redo
  #ico_Bold
  #ico_Italic
  #ico_Underline
  #ico_Left
  #ico_Center
  #ico_Right
  #ico_SelectAll
  #ico_Indent
  #ico_Outdent
  #ico_List
EndEnumeration

Enumeration ; toolbaritems
  #mnu_New
  #mnu_Open
  #mnu_Save
  #mnu_Print
  #mnu_Font
  #mnu_Search
  #mnu_Cut
  #mnu_Copy
  #mnu_Paste
  #mnu_Undo
  #mnu_Redo
  #mnu_Bold
  #mnu_Italic
  #mnu_Underline
  #mnu_Left
  #mnu_Center
  #mnu_Right
  #mnu_SelectAll
  #mnu_Indent
  #mnu_Outdent
  #mnu_List
  #mnu_linespacing_1
  #mnu_linespacing_1_5
  #mnu_linespacing_2_0 
  #mnu_pct_10
  #mnu_pct_25
  #mnu_pct_50
  #mnu_pct_75
  #mnu_pct_100
  #mnu_pct_125
  #mnu_pct_150
  #mnu_pct_200
  #mnu_pct_400
EndEnumeration

Global.RichEdit Edit; Objectvariable für unser RTF-Control
Define.s File
Define.i Result, i, mx, my, align

Global Dim Lang.s(29)
Select GetUserDefaultLangID_()
  Case 1031 : Restore german
  Default : Restore english
EndSelect

For i = 0 To 29
  Read.s Lang(i)
Next

CatchImage(#ico_New, ?ico_new)
CatchImage(#ico_Open, ?ico_open)
CatchImage(#ico_Save, ?ico_save)
CatchImage(#ico_Print, ?ico_print)
CatchImage(#ico_Font, ?ico_font)
CatchImage(#ico_Search, ?ico_search)
CatchImage(#ico_Cut, ?ico_cut)
CatchImage(#ico_Copy, ?ico_copy)
CatchImage(#ico_Paste, ?ico_paste)
CatchImage(#ico_Undo, ?ico_undo)
CatchImage(#ico_Redo, ?ico_redo)
Select GetUserDefaultLangID_()
  Case 1031 ; german
    CatchImage(#ico_Bold, ?ico_bold_de)
    CatchImage(#ico_Italic, ?ico_italic_de)
  Default
    CatchImage(#ico_Bold, ?ico_bold)
    CatchImage(#ico_Italic, ?ico_italic)
EndSelect
CatchImage(#ico_Underline, ?ico_underline)
CatchImage(#ico_Left, ?ico_left)
CatchImage(#ico_Center, ?ico_center)
CatchImage(#ico_Right, ?ico_right)
CatchImage(#ico_SelectAll, ?ico_selectall)
CatchImage(#ico_Indent, ?ico_indent)
CatchImage(#ico_Outdent, ?ico_outdent)
CatchImage(#ico_List, ?ico_list)

Procedure AddMenuBearbeiten()
  MenuItem(#mnu_Search, Lang(14), ImageID(#ico_Search))
  MenuBar()
  MenuItem(#mnu_Cut, Lang(15), ImageID(#ico_Cut))
  MenuItem(#mnu_Copy, Lang(16), ImageID(#ico_Copy))
  MenuItem(#mnu_Paste, Lang(17), ImageID(#ico_Paste))
  MenuBar()
  MenuItem(#mnu_SelectAll, Lang(27), ImageID(#ico_SelectAll))
  MenuBar()
  MenuItem(#mnu_linespacing_1  , Lang(28) + " 1.0")
  MenuItem(#mnu_linespacing_1_5, Lang(28) + " 1.5")
  MenuItem(#mnu_linespacing_2_0, Lang(28) + " 2.0")
EndProcedure

Procedure AddMenuZoom()
  MenuItem(#mnu_pct_10, "10%")
  MenuItem(#mnu_pct_25, "25%")
  MenuItem(#mnu_pct_50, "50%")
  MenuItem(#mnu_pct_75, "75%")
  MenuItem(#mnu_pct_100, "100%")
  MenuItem(#mnu_pct_125, "125%")
  MenuItem(#mnu_pct_150, "150%")
  MenuItem(#mnu_pct_200, "200%")
  MenuItem(#mnu_pct_400, "400%")
EndProcedure

Procedure SetStatusbarText()
  If Edit
    StatusBarText(0, 0, " " + Lang(0) + " " + Str(Edit\GetCursorY()))
    StatusBarText(0, 1, " " + Lang(1) + " " + Str(Edit\GetCursorX()))
    StatusBarText(0, 4, " Count: " + Str(Edit\CountWords()))
    StatusBarText(0, 5, Edit\GetFont() + "("+Str(Edit\GetFontSize())+")")
  Else
    StatusBarText(0, 0, " " + Lang(0) + " 1")
    StatusBarText(0, 1, " " + Lang(1) + " 1")
    StatusBarText(0,2, " Word: ")
    StatusBarText(0, 3, " Zoom: 100%")
    StatusBarText(0, 4, " Words: 0 Lines: 0")
    StatusBarText(0, 5, " ")  
  EndIf
EndProcedure

Macro UpdateToolbar()
  SetToolBarButtonState(0, #mnu_Bold,     Edit\GetFontStyle() & #PB_Font_Bold)
  SetToolBarButtonState(0, #mnu_Italic,   Edit\GetFontStyle() & #PB_Font_Italic)
  SetToolBarButtonState(0, #mnu_Underline,Edit\GetFontStyle() & #PB_Font_Underline)  
  
  SetToolBarButtonState(0, #mnu_Left, Edit\IsAlignLeft() )
  SetToolBarButtonState(0, #mnu_Center, Edit\IsAlignCenter() )
  SetToolBarButtonState(0, #mnu_Right, Edit\IsAlignRight() )
EndMacro

OpenWindow(0, #PB_Ignore, #PB_Ignore, 800, 600, "PurePad", #PB_Window_SystemMenu | #PB_Window_SizeGadget)
If CreateImageMenu(0, WindowID(0))
  MenuTitle(Lang(2))
  MenuItem(#mnu_New, Lang(3), ImageID(#ico_New))
  MenuItem(#mnu_Open, Lang(4), ImageID(#ico_Open))
  MenuItem(#mnu_Save, Lang(5), ImageID(#ico_Save))
  MenuBar()
  MenuItem(#mnu_Print, Lang(6), ImageID(#ico_Print))
  MenuItem(#mnu_Font, Lang(7), ImageID(#ico_Font))
  MenuTitle(Lang(8))
  AddMenuBearbeiten()
  MenuTitle("Zoom")
  AddMenuZoom()
EndIf
If CreatePopupImageMenu(1, WindowID(0))
  AddMenuBearbeiten()
  MenuBar()
  AddMenuZoom()
EndIf
If CreateToolBar(0, WindowID(0))
  ToolBarImageButton(#mnu_New, ImageID(#ico_New))
  ToolBarToolTip(0, #mnu_New, Lang(9)) 
  ToolBarImageButton(#mnu_Open, ImageID(#ico_Open))
  ToolBarToolTip(0, #mnu_Open, Lang(10)) 
  ToolBarImageButton(#mnu_Save, ImageID(#ico_Save))
  ToolBarToolTip(0, #mnu_Save, Lang(11)) 
  ToolBarSeparator()
  ToolBarImageButton(#mnu_Print, ImageID(#ico_Print))
  ToolBarToolTip(0, #mnu_Print, Lang(12)) 
  ToolBarImageButton(#mnu_Font, ImageID(#ico_Font))
  ToolBarToolTip(0, #mnu_Font, Lang(13))
  ToolBarImageButton(#mnu_Search, ImageID(#ico_Search))
  ToolBarToolTip(0, #mnu_Search, Lang(14))
  ToolBarSeparator()
  ToolBarImageButton(#mnu_Cut, ImageID(#ico_Cut))
  ToolBarToolTip(0, #mnu_Cut, Lang(15)) 
  ToolBarImageButton(#mnu_Copy, ImageID(#ico_Copy))
  ToolBarToolTip(0, #mnu_Copy, Lang(16)) 
  ToolBarImageButton(#mnu_Paste, ImageID(#ico_Paste))
  ToolBarToolTip(0, #mnu_Paste, Lang(17))
  ToolBarSeparator()
  ToolBarImageButton(#mnu_SelectAll, ImageID(#ico_SelectAll))
  ToolBarToolTip(0, #mnu_SelectAll, Lang(27))
  ToolBarSeparator()
  ToolBarImageButton(#mnu_Undo, ImageID(#ico_Undo))
  ToolBarToolTip(0, #mnu_Undo, Lang(18))
  DisableToolBarButton(0, #mnu_Undo, #True)
  ToolBarImageButton(#mnu_Redo, ImageID(#ico_Redo))
  ToolBarToolTip(0, #mnu_Redo, Lang(19))
  DisableToolBarButton(0, #mnu_Redo, #True)  
  ToolBarSeparator()
  ToolBarImageButton(#mnu_Bold, ImageID(#ico_Bold), #PB_ToolBar_Toggle)
  ToolBarToolTip(0, #mnu_Bold, Lang(20)) 
  ToolBarImageButton(#mnu_Italic, ImageID(#ico_Italic), #PB_ToolBar_Toggle)
  ToolBarToolTip(0, #mnu_Italic, Lang(21)) 
  ToolBarImageButton(#mnu_Underline, ImageID(#ico_Underline), #PB_ToolBar_Toggle)
  ToolBarToolTip(0, #mnu_Underline, Lang(22))
  ToolBarSeparator()
  ToolBarImageButton(#mnu_Left, ImageID(#ico_Left))
  ToolBarImageButton(#mnu_Center, ImageID(#ico_Center))
  ToolBarImageButton(#mnu_Right, ImageID(#ico_Right))
  ToolBarSeparator()
  ToolBarImageButton(#mnu_Indent, ImageID(#ico_Indent))
  ToolBarImageButton(#mnu_Outdent, ImageID(#ico_Outdent))
  ToolBarSeparator()
  ToolBarImageButton(#mnu_List, ImageID(#ico_List))
  ToolBarToolTip(0, #mnu_List, Lang(29))
EndIf

If CreateStatusBar(0, WindowID(0))
  AddStatusBarField(80)
  AddStatusBarField(80)
  AddStatusBarField(200)
  AddStatusBarField(80)
  AddStatusBarField(140)
  AddStatusBarField(#PB_Ignore)
  SetStatusbarText()
EndIf

Edit = New_RichEdit(0, 0, 0, 0); die grösse können wir ignorieren, passt sich im SizeEvent an!
Edit\SetLeftMargin(5)
Edit\SetRightMargin(5)
Edit\SetInterface()

Repeat
  Select WaitWindowEvent()
    Case #PB_Event_CloseWindow
      Break
    
    Case #PB_Event_SizeWindow
      Edit\Resize(0, ToolBarHeight(0), WindowWidth(0), WindowHeight(0) - ToolBarHeight(0) - StatusBarHeight(0) - MenuHeight())
    
    Case #WM_LBUTTONUP
      If GetActiveGadget() = Edit\GetID()
        SetStatusbarText()
        UpdateToolbar()
      EndIf

    Case #WM_MOUSEMOVE
      mx = WindowMouseX(0) - GadgetX(Edit\GetID())
      my = WindowMouseY(0) - GadgetY(Edit\GetID())
      StatusBarText(0, 2, " Word: " + Edit\GetWordUnderMouse(mx,my))
          
    Case #WM_RBUTTONDOWN
      If GetActiveGadget() = Edit\GetID()
        DisplayPopupMenu(1, WindowID(0))
      EndIf

    Case #PB_Event_Gadget
      Select EventGadget()
        Case Edit\GetID()
          If EventType() = #PB_EventType_Change; wird vom normalem EditorGadget nicht unterstützt
            SetStatusbarText()
            DisableToolBarButton(0, #mnu_Undo, Edit\CanUndo() ! 1)
            UpdateToolbar()
          EndIf
      EndSelect
             
    Case #PB_Event_Menu
      Select EventMenu()
        Case #mnu_New
          Edit\Clear()
          SetStatusbarText()
          DisableToolBarButton(0, #mnu_Undo, Edit\CanUndo() ! 1)
          DisableToolBarButton(0, #mnu_Redo, #True)
        Case #mnu_Open
          File = OpenFileRequester(Lang(23), "", "RichText (*.rtf)|*.rtf", 0)
          If File
            Edit\LoadRTF(File)
            SetStatusbarText()
            DisableToolBarButton(0, #mnu_Undo, Edit\CanUndo() ! 1)
            DisableToolBarButton(0, #mnu_Redo, #True) 
          EndIf
        Case #mnu_Save
          File = SaveFileRequester(Lang(24), "", "RichText (*.rtf)|*.rtf", 0)
          If File
            Edit\SaveRTF(File)
            DisableToolBarButton(0, #mnu_Undo, Edit\CanUndo() ! 1)
            DisableToolBarButton(0, #mnu_Redo, #True)  
          EndIf
        Case #mnu_Print
          Edit\Print("PurePad", #True); Drucken mit Dialog
        Case #mnu_Font
          Result = FontRequester(Edit\GetFont(), Edit\GetFontSize(), #PB_FontRequester_Effects)
          If Result
            Edit\SetFont(SelectedFontName())
            Edit\SetFontSize(SelectedFontSize())
            Edit\SetFontStyle(SelectedFontStyle())
            Edit\SetTextColor(SelectedFontColor())
            SetToolBarButtonState(0, #mnu_Bold, SelectedFontStyle() & #PB_Font_Bold)
            SetToolBarButtonState(0, #mnu_Italic, SelectedFontStyle() & #PB_Font_Italic)
            SetToolBarButtonState(0, #mnu_Underline, SelectedFontStyle() & #PB_Font_Underline)
          EndIf
        Case #mnu_Search
          File = InputRequester(Lang(25), Lang(26), "")
          If File
            If Edit\FindText(File)
              MessageBeep_(#MB_OK)
            Else
              MessageBeep_(#MB_ICONERROR)
            EndIf
          EndIf
        Case #mnu_Cut
          Edit\Cut()
        Case #mnu_Copy
          Edit\Copy()
        Case #mnu_Paste
          Edit\Paste()
        Case #mnu_Undo
          Edit\Undo()
          DisableToolBarButton(0, #mnu_Redo, #False)  
        Case #mnu_Redo
          Edit\Redo()
        Case #mnu_SelectAll
          Edit\SelectAll()
        Case #mnu_List
          Edit\SetBulleted()
        Case #mnu_Bold, #mnu_Italic, #mnu_Underline
          Result = 0
          If GetToolBarButtonState(0, #mnu_Bold)
            Result | #PB_Font_Bold
          EndIf
          If GetToolBarButtonState(0, #mnu_Italic)
            Result | #PB_Font_Italic
          EndIf
          If GetToolBarButtonState(0, #mnu_Underline)
            Result | #PB_Font_Underline
          EndIf
          Edit\SetFontStyle(Result)
        Case #mnu_Left
          Edit\SetAlignment()
        Case #mnu_Center
          Edit\SetAlignment(#PB_Text_Center)
        Case #mnu_Right
          Edit\SetAlignment(#PB_Text_Right)
        Case #mnu_Indent
          Edit\Indent()
        Case #mnu_Outdent
          Edit\Outdent()
        Case #mnu_pct_10
          Edit\SetZoom(10)
          StatusBarText(0, 3, " Zoom: " + Str(Edit\GetZoom()) +"%")
        Case #mnu_pct_25
          Edit\SetZoom(25)
          StatusBarText(0, 3, " Zoom: " + Str(Edit\GetZoom()) +"%")
        Case #mnu_pct_50
          Edit\SetZoom(50)
          StatusBarText(0, 3, " Zoom: " + Str(Edit\GetZoom()) +"%")
        Case #mnu_pct_75
          Edit\SetZoom(75)
          StatusBarText(0, 3, " Zoom: " + Str(Edit\GetZoom()) +"%")
        Case #mnu_pct_100
          Edit\SetZoom(100)
          StatusBarText(0, 3, " Zoom: " + Str(Edit\GetZoom()) +"%")
        Case #mnu_pct_125
          Edit\SetZoom(125)
          StatusBarText(0, 3, " Zoom: " + Str(Edit\GetZoom()) +"%")
        Case #mnu_pct_150
          Edit\SetZoom(150)
          StatusBarText(0, 3, " Zoom: " + Str(Edit\GetZoom()) +"%")
        Case #mnu_pct_200
          Edit\SetZoom(200)
          StatusBarText(0, 3, " Zoom: " + Str(Edit\GetZoom()) +"%")
        Case #mnu_pct_400
          Edit\SetZoom(400)
          StatusBarText(0, 3, " Zoom: " + Str(Edit\GetZoom()) +"%")
        Case #mnu_linespacing_1
          Edit\SetLineSpacing(1.0)
        Case #mnu_linespacing_1_5
          Edit\SetLineSpacing(1.5)
        Case #mnu_linespacing_2_0
          Edit\SetLineSpacing(2.0)
      EndSelect
  EndSelect

ForEver

End

DataSection
  ico_new: IncludeBinary "..\Icons\New.ico"
  ico_open: IncludeBinary "..\Icons\Open.ico"
  ico_save: IncludeBinary "..\Icons\Save.ico"
  ico_print: IncludeBinary "..\Icons\Printer.ico"
  ico_font: IncludeBinary "..\Icons\FontDialog.ico"
  ico_search: IncludeBinary "..\Icons\Find.ico"
  ico_cut: IncludeBinary "..\Icons\Cut.ico"
  ico_copy: IncludeBinary "..\Icons\Copy.ico"
  ico_paste: IncludeBinary "..\Icons\Paste.ico"
  ico_undo: IncludeBinary "..\Icons\Undo.ico"
  ico_redo: IncludeBinary "..\Icons\Redo.ico"
  ico_bold_de: IncludeBinary "..\Icons\Bold_DE.ico"
  ico_bold: IncludeBinary "..\Icons\Bold.ico"
  ico_italic_de: IncludeBinary "..\Icons\Italic_DE.ico"
  ico_italic: IncludeBinary "..\Icons\Italic.ico"
  ico_underline: IncludeBinary "..\Icons\Underline.ico"
  ico_left: IncludeBinary "..\Icons\Left.ico"
  ico_center: IncludeBinary "..\Icons\Center.ico"
  ico_right: IncludeBinary "..\Icons\Right.ico"
  ico_selectall: IncludeBinary "..\Icons\SelectAll.ico"
  ico_indent: IncludeBinary "..\Icons\Indent.ico"
  ico_outdent: IncludeBinary "..\Icons\Outdent.ico"
  ico_list: IncludeBinary "..\Icons\List.ico"
  
  german:
  Data.s "Zeile:", "Spalte:", "Datei", "Neu", "Öffnen", "Speichern", "Drucken", "Schriftart"
  Data.s "Bearbeiten", "Neue Datei", "Datei öffnen", "Datei speichern", "Datei drucken", "Schriftart auswählen"
  Data.s "Suchen ...", "Ausschneiden", "Kopieren", "Einfügen", "Rückgangig", "Wiederholen", "Fett", "Kursiv"
  Data.s "Unterstrichen", "RTF-Datei wählen:", "Speichern unter:", "PurePad suche...", "Bitte geben Sie den Suchtext ein!"
  Data.s "Alles markieren", "Zeilenabstand", "Liste"
  
  english:
  Data.s "Line:", "Row:", "File", "New", "Open", "Save", "Print", "Font"
  Data.s "Edit", "New File", "Open File", "Save File", "Print File", "Select Font"
  Data.s "Search ...", "Cut", "Copy", "Insert", "Undo", "Redo", "Bold", "Italic"
  Data.s "Underlined", "Select RTF-File:", "Save as ...:", "PurePad search...", "Insert Text to Search!"
  Data.s "Select all", "Line spacing", "List"
EndDataSection

; IDE Options = PureBasic 4.60 Beta 3 (Windows - x86)
; CursorPosition = 240
; FirstLine = 207
; Folding = --
; EnableXP
; EnableUser
; CompileSourceDirectory