﻿EnableExplicit

XIncludeFile "..\RichEdit.pbi"

UsePNGImageDecoder()  ; only required for loadimage (not for dropimage!)
UseJPEGImageDecoder() ; only required for loadimage (not for dropimage!)

Define.RichEdit Edit
Define.s Files, File, Ext
Define.i i, j

OpenWindow(0, #PB_Ignore, #PB_Ignore, 640, 480, "EditorGadget with ImageDrop-Support", #PB_Window_SizeGadget | #PB_Window_SystemMenu)
Edit = New_RichEdit(5, 5, 630, 470)
Edit\SetInterface() ; this enables the image-support and shows images in rtf-files
EnableGadgetDrop(Edit\GetID(), #PB_Drop_Image | #PB_Drop_Files, #PB_Drag_Copy | #PB_Drag_Move)

Repeat
  Select WaitWindowEvent()
    Case #PB_Event_CloseWindow
      Break
      
    Case #PB_Event_SizeWindow
      ResizeGadget(Edit\GetID(), #PB_Ignore, #PB_Ignore, WindowWidth(0) - 10, WindowHeight(0) - 10)
      
    Case #PB_Event_GadgetDrop
      If EventGadget() = edit\GetID()
        Select EventDropType()
          Case #PB_Drop_Image 
            If EventDropImage(0)
              Edit\SetImage(ImageID(0))
            EndIf
          Case #PB_Drop_Files
            Files = EventDropFiles()
            j = CountString(Files, #LF$) + 1
            For i = 1 To j
              File = StringField(Files, i, #LF$)
              Ext = LCase(GetExtensionPart(File))
              Select Ext
                Case "bmp", "jpg", "png"
                  If LoadImage(0, File)
                    Edit\SetImage(ImageID(0))
                  EndIf
                Case "rtf"
                  Edit\LoadRTF(File, #True)
                Case "txt"
                  Edit\LoadText(File, #True)
              EndSelect
            Next
        EndSelect
      EndIf
  EndSelect
ForEver
; IDE Options = PureBasic 4.60 Beta 3 (Windows - x86)
; CursorPosition = 29
; FirstLine = 15
; EnableUnicode
; EnableXP
; EnableUser
; CompileSourceDirectory