; As a Example of how go thrugh the Text an Start checking/changing word.
; Usefull for Syntaxhighlighter, Spellchecker and so on.
;

EnableExplicit

XIncludeFile "..\RichEdit.pbi"

Define.RichEdit Edit; Objectvariable fr unser RTF-Control
Define.i a,i, Pos
Define.s word

Enumeration
  #gad_redo_wordwalk
EndEnumeration

; German forum: http://www.purebasic.fr/german/viewtopic.php?t=149&postdays=0&postorder=asc&start=10
; Author: NicTheQuick (updated for PB 4.00 by Andre)
; Date: 16. September 2004
; OS: Windows
; Demo: Yes
CompilerIf #PB_Compiler_Unicode  
  Global Dim AllowedChars.Character( 65536 ) 
CompilerElse
  Global Dim AllowedChars.Character( 255 ) 
CompilerEndIf

Procedure SetAllowedChars(*AllowedChars.Character) 
  Protected a.l 
  
  For a = 0 To SizeOf(Character )
    AllowedChars(a)\c = #False 
  Next 
  
  While *AllowedChars\c 
    AllowedChars(*AllowedChars\c)\c = #True 
    *AllowedChars + 1 
  Wend 
EndProcedure 


Procedure.s nextWord2(txt.s, pos.i)
  Protected *p.CHARACTER = @txt
  Protected s_pos.i = pos
  Protected e_pos.i = 0  
  
  *p + ( pos * SizeOf(Character) )
  While *p\c <> 0
    If Not AllowedChars(*p\c)\c 
      Break
    EndIf
    e_pos+1
    *p + SizeOf(Character)
  Wend    
  ProcedureReturn Mid(txt, s_pos,e_pos+1)  
EndProcedure   


Procedure Editor_WordWalker(*Edit.RichEdit)
  Protected txt.s = *Edit\GetText()
  Protected i.i, NextWord.s, P.CHARRANGE
  Protected ipos = 0, flag = 0, spos
  
  txt = ReplaceString(txt, Chr(9), " ")
  txt = ReplaceString(txt, #CRLF$, " ")
  
  Protected slen = Len(txt)

  While ipos < slen
    
    NextWord = NextWord2( txt, iPos)
    Debug("NextWord="+NextWord)
    p\cpMin = spos+ipos-1
    p\cpMax = spos+iPos+Len(NextWord)-1
    
    SendMessage_(*Edit\GetHwnd(), #EM_EXSETSEL, 0 , @p)      
    If Flag
      *Edit\SetTextBackColor(#Yellow)
    EndIf
    Flag = 1!flag
      
           
    ipos + Len(NextWord)+1
    
  Wend     
  
EndProcedure


If OpenWindow(0,0,0,500,250,"RichEdit-Example - Wordwalker",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
  
  Edit = New_RichEdit(10,10,480,200)
  
  ButtonGadget(#gad_redo_wordwalk  , 10,220,100,20,"Start Wordwalker")
  
  AddGadgetItem(Edit\GetID(),-1,"As a very nice exmaple of how to walk trough",0,0)
  AddGadgetItem(Edit\GetID(),-1,"the words of a EditorGadget, read the code of",0,0)
  AddGadgetItem(Edit\GetID(),-1,"this Example.",0,0)
  AddGadgetItem(Edit\GetID(),-1,"It will highlight every second word.",0,0)
  
; Set German-Chars
  SetAllowedChars(@"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_") 
  
  Repeat
    Select WaitWindowEvent()
      Case #PB_Event_CloseWindow
        Break
      Case #PB_Event_Gadget
        Select EventGadget()
          Case #gad_redo_wordwalk
            Editor_WordWalker(Edit)
        EndSelect
    EndSelect
  ForEver
Else  
  Debug "Could not Open Window!"
EndIf

End

; IDE Options = PureBasic 4.60 Beta 3 (Windows - x86)
; CursorPosition = 24
; FirstLine = 75
; Folding = -
; EnableXP
; CompileSourceDirectory