
EnableExplicit

XIncludeFile "..\..\RichEdit.pbi"
XIncludeFile "module.spell.pbi"


#SPELL_DICDIR$="dict"     ;Directory of the Dictionaries

Enumeration
  #gad_new_testtext
  #gad_label_info
  #gad_label_testtext_len
  #gad_string_testtext_len
EndEnumeration

Enumeration
  #SPELL_TIMER
EndEnumeration

Enumeration
  #SPELL_POPUP_MENU
  #SPELL_POPUP_ENTRY=440
  #SPELL_POPUP_ENTRY_END = #SPELL_POPUP_ENTRY+100    ; maximum 100 suggestions
  #SPELL_POPUP_ADD
EndEnumeration


Structure sToken
  text.s
  start.i
EndStructure  


Define.RichEdit Edit; Objectvariable fr unser RTF-Control

;Define.s WordUnderCursor
Define.s SpellcheckWord

Define.i cc

Define WordRange.CHARRANGE

NewList suggests.s()

Procedure.s GetProgramDirectory() ; Program Path
  Protected ProgDir.s, TempDir.s
  TempDir = GetTemporaryDirectory()
  ProgDir = GetPathPart(ProgramFilename())
  If ProgDir = #PB_Compiler_Home+"Compilers\" Or UCase(ProgDir) = UCase(TempDir)
    ProgDir = GetCurrentDirectory()
  EndIf
  ProcedureReturn ProgDir
EndProcedure


Procedure.i Tokenise (line$, separator$, List token.sToken(), quoteMode.i = #True)
   ; in : line$     : Text to be tokenised
   ;      separator$: List of characters that act as delimiters;
   ;                  If 'line$' can contain quoted strings, then
   ;                  'separator$' should contain #DQUOTE$.
   ; out: token$()    : List of tokens
   ;      return value: #False if 'line$' cannot be parsed, and
   ;                    #True otherwise
   Protected char$, left, right, length, result=#True

   left  = 1
   right = 1
   length = Len(line$)
   ClearList(token())
   
   While right <= length   
      char$ = Mid(line$, right, 1)
      If FindString(separator$, char$, 1)
         If left < right
            AddElement(token())
            token()\text = Mid(line$, left, right-left)
            token()\start = left
            left = right
         ElseIf char$ = #DQUOTE$ And quotemode    ; Open quote. left=right
            right = FindString(line$, char$, left+1)
            If right = 0             ; No end quote.
               right = length
               result = #False
            EndIf
            AddElement(token())
            token()\text = Mid(line$, left, right-left+1)
            token()\start = left
            right + 1
            left = right
         ElseIf char$ <> " "         ; left=right
            AddElement(token())
            token()\text = Mid(line$, left, 1)
            token()\start = left
            left  + 1
            right + 1
         Else         
            left  + 1
            right + 1
         EndIf
      ElseIf right = length
         right + 1
         AddElement(token())
         token()\text = Mid(line$, left, right-left)
         token()\start = left
      Else         
         right + 1
      EndIf
   Wend

   ProcedureReturn result
 EndProcedure
 


; Updates only visible!

Procedure Editor_SpellWalkVisible(*Edit.RichEdit)
  
  Protected i.i, NextWord.s, P.CHARRANGE
  Protected ipos.i = 0
  Protected spos.i = *Edit\GetFirstVisibleLinePos()
  Protected lpos.i = *Edit\GetLastVisibleLinePos()
  Protected txt.s
  Protected ScrollPos.POINT
  Protected CursorPos.CHARRANGE

  Protected NewList tokens.sToken()
  Protected Separators.s = " ,;():=." + #DQUOTE$ + Chr(9)+Chr(13)
  
  Protected bColor
  
  *Edit\DisableRedraw(#True)
  
  SendMessage_(*Edit\GetHwnd(), #EM_EXGETSEL    , 0 , @CursorPos)
  SendMessage_(*Edit\GetHwnd(), #EM_GETSCROLLPOS, 0 , @ScrollPos)  
  
  bColor = *Edit\GetTextBackColor()

  p\cpMin = sPos
  p\cpMax = lPos  
  SendMessage_(*Edit\GetHwnd(), #EM_EXSETSEL, 0 , @p)
  
  txt = *Edit\GetSelText()
  
  
  
  Tokenise(txt, Separators, tokens(), #True)  
  
  *Edit\ClearUnderlineWave()
  *Edit\Unselect()
  
  ForEach tokens()
    If Len(tokens()\text) > 1
      If Spell_Spell(tokens()\text) = #False
;;;        Debug("misspelled word: ("+Str(Asc(Left(tokens()\text,1)))+") '"+tokens()\text+"'")
        p\cpMin = sPos+tokens()\start -1
        p\cpMax = p\cpMin + Len(tokens()\text)
        SendMessage_(*Edit\GetHwnd(), #EM_EXSETSEL, 0 , @p)
        *Edit\SetUnderlineWave()
      EndIf
    EndIf
  Next
   
  
  *Edit\SetTextBackColor(bColor)

  SendMessage_(*Edit\GetHwnd(), #EM_EXSETSEL    , 0 , @CursorPos)
  SendMessage_(*Edit\GetHwnd(), #EM_SETSCROLLPOS, 0 , @ScrollPos)
  
  *Edit\DisableRedraw(#False)
  
EndProcedure

Procedure.s GetTestText()
  Protected res.s, line.s
  Restore joke
  Repeat
    Read.s line
    If line="*END*" : Break : EndIf
    res + line
  ForEver
  ProcedureReturn res
EndProcedure  
  
Procedure.s CreateTestText(length.i, linelen.i=80)
  
  Protected ic.s = "", out.s, line.s
  Protected CountSp.i, Word.s, sizell.i, i.i
  
  Protected NewList TestWords.s()

  Protected orgText.s = GetTestText()
  orgText = ReplaceString(orgText, Chr(9), " ")
  orgText = ReplaceString(orgText, Chr(13), " ")  
  orgText = ReplaceString(orgText, Chr(10), " ")  
  orgText = ReplaceString(orgText, "'", " ")  
  orgText = ReplaceString(orgText, "  ", " ")  
  CountSp = CountString(orgText, " ")
  For i = 1 To CountSp-2
    word = Trim(StringField(orgText,i," "))
    If Len(word) > 0    
      AddElement(TestWords())
      TestWords() = word
    EndIf
  Next    
  sizell = ListSize(TestWords()) -1 
  While Len(out) < length
    SelectElement(TestWords(), Random ( sizell ) )
    line + ic + TestWords()
    ic = " "
    If Len(line) > linelen
      out + line+ #CRLF$
      line=""
    EndIf
  Wend
  ProcedureReturn out + line
EndProcedure



;Initialize German Spelling
If Not Spell_Init(GetProgramDirectory() + "\" + #SPELL_DICDIR$ +"\en\en_GB.aff", GetProgramDirectory() + "\" + #SPELL_DICDIR$ +"\en\en_GB.dic")
  MessageRequester("No Dictionary Found!", "Sorry, can't find the dictionary."+Chr(10)+"(Kein Wrterbuch gefunden)")
  End
EndIf
  
If OpenWindow(0,0,0,500,300,"RichEdit-Example - Spellchecker",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
  
  AddWindowTimer(0, #SPELL_TIMER, 250)  ; Spellchecinmg-Time
  
  Edit = New_RichEdit(10,30,480,200)
  
  
  TextGadget  (#gad_label_info,10,2,480,18,"Use the right mouse button over misspelled words to get suggestions.")
  ButtonGadget(#gad_new_testtext,10,250,100,18,"New Testtext")
  TextGadget  (#gad_label_testtext_len,130,250,100,18,"aprox.Length:")
  StringGadget(#gad_string_testtext_len,230,250,100,18,"500",#PB_String3D_Numeric)  
  
  If CreateStatusBar(0, WindowID(0))
    AddStatusBarField(200)
    AddStatusBarField(200)
  EndIf
  
  
  
  Edit\SetText(GetTestText())
  Edit\SetScrollPos(0,0)
  Repeat
    Select WaitWindowEvent()
      Case #PB_Event_CloseWindow
        Break
      Case #PB_Event_Gadget
        Select EventGadget()
          Case #gad_new_testtext
            Edit\Clear()
            Edit\SetText( CreateTestText( Val(GetGadgetText(#gad_string_testtext_len)) ,60))            
            Edit\SetScrollPos(0,0)             
        EndSelect
      Case #PB_Event_Timer
        If EventTimer() = #SPELL_TIMER
          Editor_SpellWalkVisible(Edit)
          Edit\Redraw()
        EndIf        
      Case #WM_RBUTTONUP
        SpellcheckWord = Edit\GetWordUnderMouse( WindowMouseX(0) - GadgetX(Edit\GetId()) ,WindowMouseY(0) - GadgetY(Edit\GetId()))
        If Spell_Spell(SpellcheckWord) = #False
          If IsMenu(#SPELL_POPUP_MENU) : FreeMenu(#SPELL_POPUP_MENU):EndIf
            If Spell_Suggest(SpellcheckWord, suggests() )
              CreatePopupMenu(#SPELL_POPUP_MENU)
              MenuItem(#SPELL_POPUP_ENTRY,"Select a Word:")
              MenuBar()
              
              cc=1
              ForEach suggests()
                MenuItem(#SPELL_POPUP_ENTRY+cc, suggests())
                cc+1
              Next
              
              MenuBar()
              MenuItem(#SPELL_POPUP_ADD,"Add Word:"+SpellcheckWord)
              DisplayPopupMenu(#SPELL_POPUP_MENU, WindowID(0))
              
              ;remember the Range of the Word!
              WordRange\cpMin = Edit\GetWordUnderCursorStart()+1
              WordRange\cpMax = Edit\GetWordUnderCursorEnd()                      
            EndIf
          EndIf
      Case  #PB_Event_Menu
        If EventMenu() = #SPELL_POPUP_ADD
          Spell_Add(SpellcheckWord)          
        EndIf
        
        If EventMenu() > #SPELL_POPUP_ENTRY And EventMenu() < #SPELL_POPUP_ENTRY_END
          SendMessage_(Edit\GetHwnd(), #EM_EXSETSEL    , 0 , @WordRange)
          Edit\SetText( GetMenuItemText(#SPELL_POPUP_MENU, EventMenu()))
          StatusBarText(0, 1, "'"+Edit\GetWordAtPosition(Edit\GetCursorPosition())+"'")
        EndIf           ;               
        
      Case #WM_KEYDOWN
       StatusBarText(0, 1, "'"+Edit\GetWordAtPosition(Edit\GetCursorPosition())+"'")
       
      Case #WM_LBUTTONUP
       StatusBarText(0, 1, "'"+Edit\GetWordAtPosition(Edit\GetCursorPosition())+"'")
       
     Case #WM_MOUSEMOVE
       StatusBarText(0, 0, "'"+Edit\GetWordUnderMouse( WindowMouseX(0) - GadgetX(Edit\GetId()) ,WindowMouseY(0) - GadgetY(Edit\GetId()))+"'")
    EndSelect
     
     
  ForEver
Else  
  Debug "Could not Open Window!"
EndIf

Spell_Free()

End

DataSection
  joke:
Data.s "Due to a power outage at the time, only one paramedic responded to the call." + Chr(10)
Data.s "The house was very, very dark, so the paramdic asked Katelyn, a 3-year-old"
Data.s " girl, to hold a flashlight high over her mommy so he could see while he helped deliver the baby." + Chr(10)
Data.s "Very diligently, Katelyn did as she was asked." + Chr(10)
Data.s "Heidi pushed and pushed, and after a little while Connor was born." + Chr(10)
Data.s "The paramedic lifted him by his little feet and spanked him on his bottom." + Chr(10)
Data.s "Connor began to cry." + Chr(10)
Data.s "The paramedic then thanked Katelyn for her help and asked the wide-eyed"
Data.s " 3-year old what she thought about what she had just witnessed." + Chr(10)
Data.s "Katelyn quikly responded: 'He shouldn't have crawled in there in the first"
Data.s " plaze. Smack him again.'" + Chr(10)
Data.s "*END*"
EndDataSection

; IDE Options = PureBasic 4.60 Beta 3 (Windows - x86)
; CursorPosition = 128
; FirstLine = 114
; Folding = --
; EnableUnicode
; EnableThread
; EnableXP
; Executable = HunspellChecker.exe
; CompileSourceDirectory