;==============================================================================
; Module............: Hunspell
; 
; Description.......:
; This is a very basic module to add/use the Spellchecker 'Hunspell' in PB.
; Hunspell is used in some very popular Applications, lik OpenOffice. So it
; seems to be a good base for actual dictionaries.
; 
; At the moment are only the spell-things implemted. But Hunspell also support
; Theasaurus.
;
; Global Variables...:
; 
;   Global hunspellDLL.i = #Null            - Library-Id of PB
;   Global _Spell_hunspellHandle.i          - Handle of Hunspell-instace
;
;   Global NewMap _Spell_UserAddedWords.i() - To Keep User-Added Words!
;
;   Global HunspellDLL_Filename.s            - Name of the hunspell-dll
; 
;
; Procedures.........:  
;
;   Spell_Init()          - Initialise Hunspell, needs aff and dic-file
;   Spell_Spell(word.s)   - Test the word (#True if correct)
;   Spell_Add(word.s)     - Add Word to the Dictionary. 
;   Spell_Suggest(word.s, List suggestions.s()) - returns a list of suggestions
;                                                 for the word. (Strings!)
;   Spell_Free()          - Frees the Hunspell-Instace and Library
;
; Author(s) .........:   Michael 'neotoma' Taupitz
; Creation Date .....:   27.08.2010
; Version ...........:   0.0.0.1
; Last Update .......:   
; Remarks ...........:   
;==============================================================================



;-- Variables, Globals
CompilerIf #PB_Compiler_Processor = #PB_Processor_x86
  Global HunspellDLL_Filename.s = ".\Hunspellx86.dll"
CompilerElse 
  CompilerIf #PB_Compiler_Processor = #PB_Processor_x64
    Global HunspellDLL_Filename.s = ".\Hunspellx64.dll"
  CompilerElse
    CompilerError "Hunspell needs a x86 or x64-Processor!"
  CompilerEndIf
CompilerEndIf

;---- Globals 
Global hunspellDLL.i = #Null
Global _Spell_hunspellHandle.i 

;To Keep User-Added Words!
Global NewMap _Spell_UserAddedWords.i()
;
;
;---- Prototypes
PrototypeC proto_HunspellInit(aff_file.p-unicode, dict_file.p-unicode, key.i)
PrototypeC proto_HunspellFree(handle.i)
PrototypeC proto_HunspellAdd(handle.i, word.p-unicode)
PrototypeC proto_HunspellAddWithAffix(handle.i,word.p-unicode, affix.p-Unicode)
PrototypeC proto_HunspellSpell(handle.i, word.p-unicode)
PrototypeC proto_HunspellSuggest(handle.i, word.p-unicode)
PrototypeC proto_HunspellAnalyze(handle.i, word.p-unicode)
PrototypeC proto_HunspellStem(handle.i, word.p-unicode)
PrototypeC proto_HunspellGenerate(handle.i, word.p-unicode, word2.p-unicode)

PrototypeC proto_HyphenInit(dict_file.p-unicode)
PrototypeC proto_HyphenFree(*handle)
PrototypeC proto_HyphenHyphenate(*handle, word.p-unicode)

PrototypeC proto_MyThesInit(idx_file.p-unicode,dat_file.p-unicode)
PrototypeC proto_MyThesFree(*handle)
PrototypeC proto_MyThesLookup(*handle, word.p-unicode)


;==============================================================================
; Procedure Name ....:  hunspell_Init()
; Description .......:  Loads the hunspell-dll and maps the Prototypes         
; Syntax ............:  hunspell_Init()
; Parameter(s) ......:  -
; Return value(s) ...:  Success:  Returns #True (1)
;                       Failure:  Returns #False (0)
;
; Author(s) .........:   Michael 'neotoma' Taupitz
; Creation Date .....:   27.08.2010
; Version ...........:   0.0.0.1
; Last Update .......:   
; Remarks ...........:   
;==============================================================================

Procedure hunspell_Init()
  Protected retVal.i = #False
  If hunspellDLL = #Null
      hunspellDLL = OpenLibrary(#PB_Any, HunspellDLL_Filename)
      If hunspellDLL
        Global hunspell_HunspellInit.proto_HunspellInit   = GetFunction(hunspellDLL, "HunspellInit")
        Global hunspell_HunspellFree.proto_HunspellFree   = GetFunction(hunspellDLL, "HunspellFree")
        Global hunspell_HunspellAdd.proto_HunspellAdd     = GetFunction(hunspellDLL, "HunspellAdd")
        Global hunspell_HunspellAddWithAffix.proto_HunspellAddWithAffix  = GetFunction(hunspellDLL, "HunspellAddWithAffix")
        Global hunspell_HunspellSpell.proto_HunspellSpell = GetFunction(hunspellDLL, "HunspellSpell")
        Global hunspell_HunspellSuggest.proto_HunspellSuggest = GetFunction(hunspellDLL, "HunspellSuggest")
        Global hunspell_HunspellAnalyze.proto_HunspellAnalyze = GetFunction(hunspellDLL, "HunspellAnalyze")
        Global hunspell_HunspellStem.proto_HunspellStem = GetFunction(hunspellDLL, "HunspellStem")
        Global hunspell_HunspellStem.proto_HunspellGenerate = GetFunction(hunspellDLL, "HunspellGenerate")
        
        Global hunspell_HyphenInit.proto_HyphenInit = GetFunction(hunspellDLL, "HyphenInit")
        Global hunspell_HyphenFree.proto_HyphenFree = GetFunction(hunspellDLL, "HyphenFree")
        Global hunspell_HyphenHyphenate.proto_HyphenHyphenate = GetFunction(hunspellDLL, "HyphenHyphenate")
        
        Global hunspell_MyThesInit.proto_MyThesInit = GetFunction(hunspellDLL, "MyThesInit")
        Global hunspell_MyThesFree.proto_MyThesFree = GetFunction(hunspellDLL, "MyThesFree")
        Global hunspell_MyThesLookup.proto_MyThesLookup = GetFunction(hunspellDLL, "MyThesLookup")
        
        retVal = #True
      EndIf    
  EndIf
  
  ProcedureReturn retVal
EndProcedure    


;==============================================================================
; Procedure Name ....:  hunspell_Free()
; Description .......:  Free the hunspell instace and unload/close the library
; Syntax ............:  hunspell_Init()
; Parameter(s) ......:  -
; Return value(s) ...:  Success:  Returns #True (1)
;                       Failure:  Returns #False (0)
;
; Author(s) .........:   Michael 'neotoma' Taupitz
; Creation Date .....:   27.08.2010
; Version ...........:   0.0.0.1
; Last Update .......:   
; Remarks ...........:   
;==============================================================================
Procedure hunspell_Free()
  Protected retVal.i = #True
  If _Spell_hunspellHandle
    hunspell_HunspellFree(_Spell_hunspellHandle)
    _Spell_hunspellHandle = #Null
  EndIf
  
  If hunspellDLL <> #Null
    CloseLibrary(hunspellDLL)
    hunspellDLL = #Null
  EndIf
  
  ProcedureReturn retVal
EndProcedure    


;==============================================================================
; Procedure Name ....:   _ReadHunspellArray()
; Description .......:  The Hunspell-Arrays are stored in Memory, so we have to
;                       grab them. Thats, what this Procedure do.
; Syntax ............:   _ReadHunspellArray(*ptr, List res.s())
; Parameter(s) ......:  *ptr          - Poitner to a Hunspell-Array
;                       Lisr res.s()  - List to fill with found words/entries
; Return value(s) ...:  Nothing
;
; Author(s) .........:   Michael 'neotoma' Taupitz
; Creation Date .....:   27.08.2010
; Version ...........:   0.0.0.1
; Last Update .......:   
; Remarks ...........:   It clears the List.
;==============================================================================
Procedure _ReadHunspellArray(*ptr, List res.s())
  Protected str.s
  If *ptr And PeekI(*ptr) <> 0
    ClearList(res())
    While PeekI(*ptr) <> 0
      str = PeekS( PeekI(*ptr),-1,#PB_Unicode)
      AddElement(res())
      res() = str
      *ptr + SizeOf(Integer)
    Wend
  EndIf
EndProcedure  
      

;==============================================================================
; Procedure Name ....:  Spell_Init()
; Description .......:  Initialises the Hunspell-Lib and create a hunspell-
;                       instance.
; Syntax ............:  Spell_Init(aff_file.s, dic_file.s)
; Parameter(s) ......:  aff_file.s - Filename (e.g. "de_DE_frami.aff")
;                       dic_file.s - Filename (e.g. "de_DE_frami.dic")
;
; Return value(s) ...:  Success:  Returns #True (1)
;                       Failure:  Returns #False (0)
;
; Author(s) .........:   Michael 'neotoma' Taupitz
; Creation Date .....:   27.08.2010
; Version ...........:   0.0.0.1
; Last Update .......:   
; Remarks ...........:   
;==============================================================================
Procedure Spell_Init(aff_file.s, dic_file.s)
  Protected retVal.i = #False
  
  If hunspell_Init()
    If FileSize(aff_file) >0
      If FileSize(dic_file) > 0    
        _Spell_hunspellHandle = hunspell_HunspellInit(aff_file,dic_file,#Null)
        If _Spell_hunspellHandle
          retVal = #True
        EndIf
      Else
        Debug("SPELL: Missing File:"+dic_file)
      EndIf
    Else
      Debug("SPELL: Missing File:"+aff_file)
    EndIf
  Else
    Debug("SPELL: Could not Initialise Hunspell!")
  EndIf
  ProcedureReturn retVal  
EndProcedure


;==============================================================================
; Procedure Name ....:  Spell_Spell()
; Description .......:  Checks the corectness of a word
;
; Syntax ............:  Spell_Spell(word.s)
; Parameter(s) ......:  word.s - word to check
;
; Return value(s) ...:  Success:  Returns #True (1) - Correct
;                       Failure:  Returns #False (0) - Incorrect
;
; Author(s) .........:   Michael 'neotoma' Taupitz
; Creation Date .....:   27.08.2010
; Version ...........:   0.0.0.1
; Last Update .......:   
; Remarks ...........:   
;==============================================================================

Procedure Spell_Spell(word.s)
  Protected retVal.i = #False
  If _Spell_hunspellHandle
    retVal = hunspell_HunspellSpell(_Spell_hunspellHandle, word)
  Else
    Debug("Hunspell was not Initialised!!")
  EndIf
  ProcedureReturn retVal  
EndProcedure

;==============================================================================
; Procedure Name ....:  Spell_Add()
; Description .......:  Add a Word to the Dictionary
;
; Syntax ............:  Spell_Add(word.s)
; Parameter(s) ......:  word.s - word to check
;
; Return value(s) ...:  Found out, that also 0 is correct. So ignore it.
;                       
;
; Author(s) .........:   Michael 'neotoma' Taupitz
; Creation Date .....:   27.08.2010
; Version ...........:   0.0.0.1
; Last Update .......:   
; Remarks ...........:   It also add this word to the Global Map _Spell_UserAddedWords().
;                        We have to keep them, while Hunspell adds Wiord only to the 
;                        runtime-dictionary.
;                        If you want to remember the User-Words, you have to
;                        store them (into a file, db, whatever) and add them 
;                        for next start of yoiur program with Spell_Add().
;                        
;                        Returncode 0 is also success.
;==============================================================================
Procedure Spell_Add(word.s)
  Protected retVal.i = #False
  If _Spell_hunspellHandle
    retVal = hunspell_HunspellAdd(_Spell_hunspellHandle, word)
      _Spell_UserAddedWords(word) + 1
;     If retVal 
;     Else
;       Debug("Somthing wrong when adding...(retVal="+Str(retVal)+")")
;     EndIf
  Else
    Debug("Hunspell was not Initialised!!")
  EndIf
  ProcedureReturn retVal  
EndProcedure

;==============================================================================
; Procedure Name ....:  Spell_Suggest()
; Description .......:  Suggestions for a word
;
; Syntax ............:  Spell_Add(word.s)
; Parameter(s) ......:  word.s - word to check
;                       List Suggestions.s() - List to fill with Hunspell-Suggestions.
;
; Return value(s) ...:  Success:  Returns #True (1) - Correct
;                       Failure:  Returns #False (0) - Incorrect
;                       ;
; Author(s) .........:   Michael 'neotoma' Taupitz
; Creation Date .....:   27.08.2010
; Version ...........:   0.0.0.1
; Last Update .......:   
; Remarks ...........:   It does NOT clear the List!
;==============================================================================
Procedure Spell_Suggest(word.s, List suggestions.s())
  Protected retVal.i = #False
  Protected ptrArray.i
  If _Spell_hunspellHandle
    
    ptrArray = hunspell_HunspellSuggest(_Spell_hunspellHandle, word )
    If ptrArray
      _ReadHunspellArray(ptrArray, suggestions())
      retVal = #True
    EndIf
    
  Else
    Debug("Hunspell was not Initialised!!")
  EndIf
  
  ProcedureReturn retVal  
EndProcedure


;==============================================================================
; Procedure Name ....:  Spell_Free()
; Description .......:  Free the Handle and unload/close the library
;
; Syntax ............:  Spell_Free()
; Parameter(s) ......:  
;
; Return value(s) ...:  Success:  Returns #True (1) - Correct
;                       Failure:  Returns #False (0) - Incorrect
;                       ;
; Author(s) .........:   Michael 'neotoma' Taupitz
; Creation Date .....:   27.08.2010
; Version ...........:   0.0.0.1
; Last Update .......:   
; Remarks ...........:  
;==============================================================================
Procedure Spell_Free()
  Protected retVal.i = #False
  If _Spell_hunspellHandle
    hunspell_Free()
    retVal = #True
  Else
    Debug("Hunspell was not Initialised!!")
  EndIf
  
  ProcedureReturn retVal  
EndProcedure


; IDE Options = PureBasic 4.50 (Windows - x86)
; CursorPosition = 341
; FirstLine = 300
; Folding = --
; EnableXP