# Generate ESM modules and modular TS definitions
# Dependency: POSIX shell, e.g. bash
echo "Generating ECMAScript modules using Shell"

AUTOGENERATED_NOTICE="// NOTICE: This code is @generated from code outside the esm directory. Please do not edit it to contribute!"

# Main file
#   code-input.mjs: (../code-input.js without the templates) + ESM
    echo $AUTOGENERATED_NOTICE > code-input.mjs
    echo "" >> code-input.mjs
    # Imports: Nothing
    # Code before first templates block
    head -$(($(sed -n "/ESM-SUPPORT-START-TEMPLATES-BLOCK-1/=" ../code-input.js | head -1) - 1)) ../code-input.js >> code-input.mjs
    # Code before second templates block, after first templates block
    head -$(($(sed -n "/ESM-SUPPORT-START-TEMPLATES-BLOCK-2/=" ../code-input.js | head -1) - 1)) ../code-input.js | tail --line=+$(($(sed -n "/ESM-SUPPORT-END-TEMPLATES-BLOCK-1/=" ../code-input.js | head -1) + 1)) >> code-input.mjs
    # Code after second templates block
    tail --line=+$(($(sed -n "/ESM-SUPPORT-END-TEMPLATES-BLOCK-2/=" ../code-input.js | head -1) + 1)) ../code-input.js >> code-input.mjs
    # Exports
    echo "export const Plugin = codeInput.Plugin;" >> code-input.mjs
    echo "export const Template = codeInput.Template;" >> code-input.mjs
    echo "export const CodeInput = codeInput.CodeInput;" >> code-input.mjs
    echo "export const registerTemplate = codeInput.registerTemplate;" >> code-input.mjs
    echo "export default { Plugin, Template, CodeInput, registerTemplate };" >> code-input.mjs

#   code-input.d.mts: (../code-input.d.ts without the plugin/template namespaces) + ESM
    echo $AUTOGENERATED_NOTICE > code-input.d.mts
    echo "" >> code-input.d.mts
    # Miss out no-ESM specific code at the top
    # Code before first namespace, after no-ESM specific code
    head -$(($(sed -n "/ESM-SUPPORT-START-NAMESPACE-1/=" ../code-input.d.ts | head -1) - 1)) ../code-input.d.ts | tail --line=+$(($(sed -n "/ESM-SUPPORT-END-NOESM-SPECIFIC/=" ../code-input.d.ts | head -1) + 1)) >> code-input.d.mts
    # Code before second namespace, after first namespace
    head -$(($(sed -n "/ESM-SUPPORT-START-NAMESPACE-2/=" ../code-input.d.ts | head -1) - 1)) ../code-input.d.ts | tail --line=+$(($(sed -n "/ESM-SUPPORT-END-NAMESPACE-1/=" ../code-input.d.ts | head -1) + 1)) >> code-input.d.mts
    # Code after second namespace
    tail --line=+$(($(sed -n "/ESM-SUPPORT-END-NAMESPACE-2/=" ../code-input.d.ts | head -1) + 1)) ../code-input.d.ts >> code-input.d.mts
    echo "export default { Plugin, Template, CodeInput, registerTemplate };" >> code-input.d.mts

# Templates
mkdir -p templates
#   templates/*.mjs
    # For each template name prepared for ESM support from the d.ts file:
    grep -Eo "ESM-SUPPORT-START-TEMPLATE-[A-Za-z]+" ../code-input.d.ts | sed "s/ESM-SUPPORT-START-TEMPLATE-//" | xargs -I % sh -c '
    echo $1 > templates/$0.mjs;
    echo "" >> templates/$0.mjs;
    # Imports
    echo "import { Template } from \"../code-input.mjs\";" >> templates/$0.mjs

    # Code after start and before end of this template, making use of the imported Template, not codeInput.Template
    head -$(($(sed -n "/ESM-SUPPORT-END-TEMPLATE-$0/=" ../code-input.js | head -1) - 1)) ../code-input.js | tail --line=+$(($(sed -n "/ESM-SUPPORT-START-TEMPLATE-$0/=" ../code-input.js | head -1) + 1)) | sed "s/codeInput\.Template/Template/g" >> templates/$0.mjs

    TEMPLATE_CLASS_NAME="$(grep -Eo "class [a-zA-Z]+ extends Template" templates/$0.mjs | head -1 | sed "s/class //" | sed "s/ extends Template//")";
    # Export.
    echo "export default $TEMPLATE_CLASS_NAME;" >> templates/$0.mjs

    # $0 is the template name, $1 is the autogenerated notice
    ' "%" "$AUTOGENERATED_NOTICE"
#   templates/*.d.mts
    # For each template name prepared for ESM support from the d.ts file:
    grep -Eo "ESM-SUPPORT-START-TEMPLATE-[A-Za-z]+" ../code-input.d.ts | sed "s/ESM-SUPPORT-START-TEMPLATE-//" | xargs -I % sh -c '
    echo $1 > templates/$0.d.mts;
    echo "" >> templates/$0.d.mts;
    # Imports
    echo "import { Template, Plugin } from \"../code-input.d.mts\";" >> templates/$0.d.mts
    # Code after start and before end of this template, making use of the imported Template, not codeInput.Template, and the imported Plugin, not codeInput.Plugin, exporting the class as default
    # export default class replacement should work but won"t leave indentation as JS version does.
    head -$(($(sed -n "/ESM-SUPPORT-END-TEMPLATE-$0/=" ../code-input.d.ts | head -1) - 1)) ../code-input.d.ts | tail --line=+$(($(sed -n "/ESM-SUPPORT-START-TEMPLATE-$0/=" ../code-input.d.ts | head -1) + 1)) | sed "s/codeInput\.Template/Template/g" | sed "s/codeInput\.Plugin/Plugin/g" | sed -E "s/^[[:space:]]*class /export default class /" >> templates/$0.d.mts

    # $0 is the template name, $1 is the autogenerated notice
    ' "%" "$AUTOGENERATED_NOTICE"

# Plugins
mkdir -p plugins
#   plugins/*.mjs
    # For each plugin name prepared for ESM support from the d.ts file:
    grep -Eo "ESM-SUPPORT-START-PLUGIN-[A-Za-z\-]+" ../code-input.d.ts | sed "s/ESM-SUPPORT-START-PLUGIN-//" | xargs -I % sh -c '
    echo $1 > plugins/$0.mjs;
    echo "" >> plugins/$0.mjs;
    # Imports
    echo "import { Plugin } from \"../code-input.mjs\";" >> plugins/$0.mjs
    # Plugin syntax is to be stored in an object; do so temporarily.
    echo "let plugins = {};" >> plugins/$0.mjs
    # Code from this plugin"s file, making use of the imported Plugin, not codeInput.Plugin, and of the created plugins object, not codeInput.plugins
    cat ../plugins/$0.js | sed "s/codeInput\.Plugin/Plugin/g" | sed "s/codeInput\.plugins/plugins/g" >> plugins/$0.mjs;

    PLUGIN_CLASS_NAME="$(grep -Eo "codeInput\.plugins\.[a-zA-Z]+" ../plugins/$0.js | head -1 | sed "s/codeInput\.plugins\.//")";
    # Export.
    echo "" >> plugins/$0.mjs;
    echo "export default plugins.$PLUGIN_CLASS_NAME;" >> plugins/$0.mjs;

    # $0 is the plugin name, $1 is the autogenerated notice
    ' "%" "$AUTOGENERATED_NOTICE"
#   plugins/*.d.mts
    # For each plugin name prepared for ESM support from the d.ts file:
    grep -Eo "ESM-SUPPORT-START-PLUGIN-[A-Za-z\-]+" ../code-input.d.ts | sed "s/ESM-SUPPORT-START-PLUGIN-//" | xargs -I % sh -c '
    echo $1 > plugins/$0.d.mts;
    echo "" >> plugins/$0.d.mts;
    # Imports
    echo "import { Plugin, CodeInput } from \"../code-input.d.mts\";" >> plugins/$0.d.mts
    # Code after start and before end of this template, making use of the imported Plugin, not codeInput.Plugin and the imported CodeInput, not codeInput.CodeInput, exporting the class as default
    # export default class replacement should work but won"t leave indentation as JS version does.
    head -$(($(sed -n "/ESM-SUPPORT-END-PLUGIN-$0/=" ../code-input.d.ts | head -1) - 1)) ../code-input.d.ts | tail --line=+$(($(sed -n "/ESM-SUPPORT-START-PLUGIN-$0/=" ../code-input.d.ts | head -1) + 1)) | sed "s/codeInput\.Plugin/Plugin/g" | sed "s/codeInput\.CodeInput/CodeInput/g" | sed -E "s/^[[:space:]]*class /export default class /" >> plugins/$0.d.mts

    # $0 is the plugin name, $1 is the autogenerated notice
    ' "%" "$AUTOGENERATED_NOTICE"
