import logging
import threading
import time

def invokeSleep(name):
    logging.info("Thread is %s: starting", name)
    time.sleep(2)
    logging.info("Thread is %s: finishing", name)

if __name__ == "__main__":
    format = "%(asctime)s: %(message)s"
    logging.basicConfig(format=format, level=logging.INFO,
                        datefmt="%H:%M:%S")

    logging.info("creating thread")
    aThread = threading.Thread(target=invokeSleep, args=(1,))
    logging.info("before starting thread")
    aThread.start()
    logging.info("thread finishing")