# AddInput

> *1.1.1*

A plugin that adds Material Design styles to the standard HTML `<input>`

```HTML
<input data-addui='input' />
```

![](res/demo.gif)

## Importing
Because this is a jQuery plugin, jQuery must be first imported before this plugin. Any version of jQuery should work.

```HTML
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
```

Then copy addInput.js and addInput.css from the distribution (dist) directory into your project and import it into your page.

```HTML
<link rel='stylesheet' href='path/to/addInput.css' />
<script src='path/to/addInput.js'></script>
```

### Theming
The CSS was compiled from Sass (SCSS), you can change the color and the theme by editing the variables in src/addInput.scss, the colors can be set to any color and $theme can be set to "dark" or "light". After making your changes you will need to recompile the SASS, if you do not have sass installed on your system visit [SassMeister.com](http://www.sassmeister.com/) for an easy to use online compiler (you will need to manually import the partials).

### Obj.JS
This plugin is built using the [Obj.JS 2.1+ framework](https://github.com/addui/ObjJS), but it is included in the distribution JS file (dist/addInput.js). If you are already using Obj.JS on your page you should import the JS file from source instead (src/addInput.js) to avoid loading duplicate code.

## How to Use

To use give your `<input>` element a `data-addui` attribute set to `"input"`. You can also use the "placeholder", "name", "type", "id" and "value" attributes.

```HTML
<input data-addui='input' id='myInput' name='myInput' value='Dustin' type='text' placeholder='Name' />
```
![](res/demo.gif)


#License

This software is property of [**Dustin Poissant**](http://github.com/dustinpoissant).

This software is distributed AS-IS with no warranties/guarantees either expressed or implied.

This software is Licensed under [CC BY-NC-SA 3.0 US](https://creativecommons.org/licenses/by-nc-sa/3.0/us/).
