# Tooltiper.js
JQuery plugin for easy simple ToolTips. Only have 2.73 KB!

# Installation
Download the [latest release](https://github.com/vaaip/tooltiper/releases) and includes stylesheet and script.

#### Stylesheet
Include `tooltiper.min.css` in the `<head>`.
```html
<link rel="stylesheet" href="tooltiper.js/dist/css/tooltiper.min.css">
```

#### Script
Include `tooltiper.min.js` in just before close the `body` tag and just after inlcuded the JQuery library.
```html
<script src="https://code.jquery.com/jquery-3.1.1.min.js"></script>
<script src="tooltiper.js/dist/js/tooltiper.min.js"></script>
```

# Usage
After the installation of package you can initialize the `tooltiper.js` and add options. Please note, initialize it just before close your `body` tag and just after included the `jquery` library and `tooltiper.min.js`.

#### Initialize
```javascript
<script>
    // with default options
    $("element").tooltiper();

    // with your own options
    $("element").tooltiper({
        // options here
    });
</script>
```

#### Options

Option            | Description                                                                                             | Default value |
------------------|---------------------------------------------------------------------------------------------------------|---------------|
`title`           | Tooltip text. You can also set it via `data-title` attribute                                            | `Tooltiper`   |
`position`        | Tooltip position (`left`, `right`, `top`, `bottom`). You can also set it via `data-position` attribute  | `top`         |
`color`           | Color of the Tooltip text. (`black`, `#000`, `rgb(0, 0, 0)`)                                            | `#FFF`        |
`backgroundColor` | Background color of the Tooltip. (`black`, `#000`, `rgb(0, 0, 0)`)                                      | `#000`        |
`fontSize`        | Font size of the Tooltip in any unit (`1em`, `16px`, `12pt`, `100%`)                                    | `10px`        |
`padding`         | Tooltip padding (`5px 4px 3px 2px`, `5px 4px`, `4px`)                                                   | `5px`         |
`borderRadius`    | Tooltip border's radius (`2px`)                                                                         | `none`        |
`cursor`          | Custom cursor for element (`auto`, `pointer`, `help` etc...)                                            | `auto`        |
`boxShadow`       | Tooltip box shadow (`1px 1px 5px #000`)                                                                 | `none`        |



# License
It is open-sourced software licensed under the GNU GPLv3.
