/**
Project: vaaip/tooltiper.js
Project URL: https://github.com/vaaip/tooltiper
Auther: Renjith VK <renjith@vaaip.com>
Auther URL: renjithvk.com, vaaip.com
Created: 29th Oct 2016 8:35PM
*/

(function ( $ ) {
    $.fn.tooltiper = function( options ) {

        /**
        * options and default values
        */
        var settings = $.extend({

            // core options
            title: 'Tooltiper',
            position: 'top',

            // css options
            color: '#FFF',
            backgroundColor: '#000',
            fontSize: '10px',
            padding: "5px",
            borderRadius: 'none',
            cursor: 'auto',
            boxShadow: 'none',

        }, options );


        /**
        inhert options by setting element attributes
        */
        if( this.attr("data-title") ) {
            settings.title = this.attr("data-title");
        }

        if( this.attr("data-position") ) {
            settings.position = this.attr("data-position");
        }


        /**
        * add the tooltip to initialisation and build elements
        */
        this.css("position", "relative")
            .append("<div class='tooltiper-wrapper hide'>" + settings.title + "</div>");

        // apply style to tooltip
        var tooltipWrapper = this.find(".tooltiper-wrapper");
        tooltipWrapper.css({
            color: settings.color,
            backgroundColor: settings.backgroundColor,
            fontSize: settings.fontSize,
            padding: settings.padding,
            borderRadius: settings.borderRadius,
            boxShadow: settings.boxShadow,
        });

        // apply style to element
        this.css({
            cursor: settings.cursor,
        });

        // add arrow
        tooltipWrapper.append("<span class='arrow arrow-" + settings.position + "'></span>");


        /**
        position tooltip and arrow
        */
        var tooltiperWrapperPositionHorizontal = ( this.outerWidth() - tooltipWrapper.outerWidth() ) / 2;
        var tooltiperWrapperPositionVertical = ( this.outerHeight() - tooltipWrapper.outerHeight() ) / 2;

        // position: top
        if( settings.position == 'top' ) {

            tooltipWrapper.css({
                top: -( tooltipWrapper.outerHeight() + 10 ),
                left: tooltiperWrapperPositionHorizontal,
            });

        // position: right
        } else if( settings.position == 'right' ) {

            tooltipWrapper.css({
                right: -(tooltipWrapper.outerWidth() + 10),
                top: tooltiperWrapperPositionVertical,
            });

        // position: bottom
        } else if ( settings.position == 'bottom' ) {

            tooltipWrapper.css({
                bottom: -( tooltipWrapper.outerHeight() + 10 ),
                left: tooltiperWrapperPositionHorizontal,
            });

        // position: left
        } else if( settings.position == 'left' ) {

            tooltipWrapper.css({
                left: -(tooltipWrapper.outerWidth() + 10),
                top: tooltiperWrapperPositionVertical,
            });

        }


        /**
        * toggle tooltip when mouse enter and leave
        */
        this.mouseenter( function() {
            tooltipWrapper.show();
        }).mouseleave( function() {
            tooltipWrapper.hide();
        });

    }
}( jQuery ));
