        function setParams(u) {
            userOpts = u;
            interactive = userOpts.interactive !== undefined ? userOpts.interactive : true;
            showButtons = userOpts.showButtons !== undefined ? userOpts.showButtons : true;
            scrollto = userOpts.scrollto !== undefined ? userOpts.scrollto : true;
        }

        function init() {
          // Set defaults
            var w = userOpts.w || 180,
                h = userOpts.h || 140,
                arrowColour = userOpts.arrowColour || 'grey',
                shapeStrokeColour = 'rgb(66, 66, 66)',
                lightText = '#fff',
                darkText = 'rgb(51, 51, 51)',
                defaultFontSize = userOpts.defaultFontSize || 12,
                defaults = {
                    showButtons: userOpts.showButtons || true,
                    minOpacity: userOpts.minOpacity || 0,
                    maxOpacity: userOpts.maxOpacity || 1,
                    btnBarHeight: userOpts.btnBarHeight || 40,
                    btnBarSelectedColour: userOpts.btnBarSelectedColour || 'black',
                    btnBarHoverColour: userOpts.btnBarHoverColour || 'dimgrey',
                    btnBarFontSize: userOpts.btnBarFontSize || defaultFontSize,
                    btnBarRadius: userOpts.btnBarRadius || 10,
                    shapeWidth: userOpts.shapeWidth  || w,
                    shapeHeight: userOpts.shapeHeight  || h,
                    connectorLength: userOpts.connectorLength || 80,
                    startWidth: userOpts.startWidth  || w,
                    startHeight: userOpts.startHeight || 40,
                    startCornerRadius: userOpts.startCornerRadius || 20,
                    startFill:  userOpts.startFill || arrowColour,
                    startStrokeWidth: userOpts.startStrokeWidth || 0.1,
                    startStrokeColour: userOpts.startStrokeColour || 'rgb(66, 66, 66)',
                    startTextColour: userOpts.startTextColour || lightText,
                    startText: userOpts.startText || 'Start',
                    startFontSize: userOpts.startFontSize || defaultFontSize,
                    decisionWidth: userOpts.decisionWidth || userOpts.w || w,
                    decisionHeight: userOpts.decisionHeight || userOpts.h || h,
                    decisionFill: userOpts.decisionFill || '#8b3572',
                    decisionTextColour: userOpts.decisionTextColour || lightText,
                    decisionFontSize: userOpts.decisionFontSize || defaultFontSize,
                    finishTextColour: userOpts.finishTextColour ||  lightText,
                    finishWidth: userOpts.finishWidth  || w,
                    finishHeight: userOpts.finishHeight  || h,
                    finishLeftMargin: userOpts.finishLeftMargin || 20,
                    finishFill: userOpts.finishFill || '#0F6C7E',
                    finishFontSize: userOpts.finishFontSize  || defaultFontSize,
                    finishLinkColour: userOpts.finishLinkColour || 'yellow',
                    processWidth: userOpts.processWidth  || w,
                    processHeight: userOpts.processHeight  || h,
                    processLeftMargin: userOpts.processLeftMargin || 20,
                    processFill: userOpts.processFill || '#fff',
                    processStrokeColour: userOpts.processStrokeColour || shapeStrokeColour,
                    processStrokeWidth: userOpts.processStrokeWidth || 0.1,
                    processTextColour: userOpts.processTextColour || darkText,
                    processFontSize: userOpts.processFontSize  || defaultFontSize,
                    processLinkColour: userOpts.processLinkColour || 'darkblue',
                    labelWidth: userOpts.labelWidth || 30,
                    labelHeight: userOpts.labelHeight || 20,
                    labelRadius: userOpts.labelRadius || 5,
                    labelStroke: userOpts.labelStroke || 0.1,
                    labelFill: userOpts.labelFill || arrowColour,
                    labelOpacity: userOpts.labelOpacity || 1.0,
                    labelFontSize: userOpts.labelFontSize ||  defaultFontSize,
                    labelTextColour: userOpts.labelTextColour ||  lightText,
                    arrowHeadHeight: userOpts.arrowHeadHeight || 20,
                    arrowHeadColor: userOpts.arrowHeadColor || arrowColour,
                    arrowHeadOpacity: userOpts.arrowHeadOpacity || 1.0,
                    connectorStrokeWidth: userOpts.connectorStrokeWidth || 1.5,
                    connectorStrokeColour: userOpts.connectorStrokeColour || arrowColour,
                    tipStrokeColour: userOpts.tipStrokeColour || shapeStrokeColour,
                    tipStrokeWidth: userOpts.tipStrokeWidth || 0.1,
                    tipFill: userOpts.tipFill || '#fff',
                    tipFontSize: userOpts.tipFontSize || defaultFontSize,
                    tipMarginTop: userOpts.tipMarginTop || 10,
                    tipMarginLeft: userOpts.tipMarginLeft || 10
                };
            return defaults;
        }