(function( $ ){
    $.fn.tooltipPlus = function(options) {
       /*-----------------------------------------------------------------------*/
       /*--  Tool tips and Custom Select objects                              --*/
       /*-----------------------------------------------------------------------*/
       var defaults = {
	   "classNm": "",    /*-- allows user to send in the class name to style the tooltip --*/
	   "type": "",       /*-- tooltip or user can pass in the html to display what they want --*/
	   "html": "",       /*-- good for passing in things like html tables --*/
	   "HelpBtn": $('img#help'),  /*--  jquery selector for element that should *always* show a tooltip (usu. ---*/
	   "FadeOut": 2000,
	   "AltClass": "",    /*-- allows user to pass in a class and an alt class that gets added on mouseenter and removed on mouseleave --*/
	   "ClearBtn": "",  /*-- if set, it should point to a 16x16 gif file, that when clicked, will clear the input field that the control to it's left ---*/
	   "SelectOnly": false  /*-- if true, will not allow user to type input, only values from the select box will be allowed ---*/
       },
       DisplayThis,
       ID = "UnIqUeToOlTiPIdEnTiFiEr",
       $this;
       options = $.extend(defaults, options); /*-- replace defaults if caller provided options --*/
       if ( $('head').find('style').text().match(/ClearButton /) === null ) { 
	 $("<style type='text/css'> img.ClearButton { padding:2px; border:2px outset beige;cursor:pointer; } img.ClearButtonMO { border-color: #95C256; } </style>").appendTo("head");    
       } 
       return this.each(function() {  // for every selector that has been associated with tooltipPlus
	   var $this = $(this);
	   DisplayThis = "";
	   if ( options.SelectOnly ) {
	       $this.prop("readonly", true);
	   }
	   if (options.ClearBtn) {
	       $this.after("<div style='margin-left:5px;cursor:pointer;display:inline-block; width:18px;height:18px;'><img class='ClearButton' style='float:right;' height=17px id=ClearInput tooltip='Click to clear field' src='"+options.ClearBtn+"' onclick=\"$(this).parent().prev('input').val('');$(this).parent().prev('input').attr('key','');\"></div>"); 
	       $('.ClearButton').tooltipPlus({ "type": "tooltip", "AltClass": "ClearButtonMO" });
	   }
	   $this.off('mouseenter');
	   $this.on('mouseenter', function(e) {
	      $('span.UnIqUeToOlTiP').remove(); /*-- remove any stragglers --*/
	      /*--  if user has provided a mouseover class, take care of the class swap   --*/
	      if ( options.AltClass && $this.attr('class') && $this.attr('class').match(options.AltClass) === null ) {
		 $(this).addClass(options.AltClass);
	      }
	      /*--  if you want to be able to toggle tootips, attach "ShowHelp" data to the "body" and toggle it   --*/
	      if (options.type === "tooltip" && $("body").data('ShowHelp') === false ) {
		   /*--  if you want to always show the tooltip for a button that toggles tooltips on and off, pass in that selector as HelpBtn --*/
		   if ( ! options.HelpBtn.is($this) ) {
			return false; /* if tooltips are off, return -- unless this is the element that always has tooltips on */
		   }
	      }
	      /*--  html input has he highest priority, so if supplied, it overrides title or tooltip attributes. Also, tooltip takes precendence over title  --*/
	      DisplayThis = ( options.html !== "" ? options.html : ( $this.attr('tooltip') === undefined ? $this.attr('title') : $this.attr('tooltip') )); 
	      /*-----------------------------------------------------------*/
	      /*--  if the tooltip or control does not exist, create it  --*/
	      /*-----------------------------------------------------------*/
	      if ( ! $("span#" + ID).length ) {
		 if (  DisplayThis === undefined ) {
		    alert ( "You need to provide title, tooltip or html to use tooltipPlus control (ID = " +ID+", html = "+options.html+" )" );
		    return false;   
		 }
		 /*--  create the tooltip or control and hide it. Note that a duration of zero on hide() breaks the control --*/
		 $("<span class='UnIqUeToOlTiP " + options.classNm + "' id="+ID+">" + DisplayThis + "</span>")   
			    .appendTo('body')  
			    .hide(1) 
			    .position ({      
			      of:  $this,  
			      my: 'left top',  
			      at: 'right bottom',  
			      collision: 'fit fit'  
			    });  
		 if ( options.type === "tooltip" ) { // tooltips get css but no event bindings
		    if ( options.classNm === "" ) {
			$('span#'+ID).css({
			     'width': '210px', 'height':'auto', 'padding': '5px', 'border': '1px solid gray', '-moz-border-radius': '6px', '-webkit-border-radius': '6px', 
			     'background': '#ffffff', 'color': '#020202'
			 });
		    } 
		 } else { // controls get event bindings
                    if ( $this.attr('id') === "ClearInput" ) { /*-- this is the clear button added in this plug in ---*/
                       $('span#'+ID).attr('width','80');
		    }
		    $("span#" + ID + ' tbody td').hover(function() { 
			     $(this).addClass("mo"); 
			     $.data(this, 'hover', true); 
			 },
			 function() { 
			     $(this).removeClass("mo");
			     $.data(this, 'hover', false); 
		    }).data('hover', false);
		    $("span#" + ID + ' tbody td').click(function() { 
			 $this.val($.trim($(this).text())); 
			 if ( $(this).attr('key') !== undefined ) {
			     $this.attr('key',$(this).attr('key'));  
			 }
			 $('span#'+ID).remove(); 
		    });
		    $("span#" + ID).hover( 
			function() { $.data(this, 'hover', true); },
			function() { 
			    $.data(this, 'hover', false); 
			    $(this).remove(); 
			}).data('hover', false);  
			var SpanWidth = (parseInt($("span#" + ID+" > table").css('width'),10) > $this.width()) ? parseInt($("span#" + ID+" > table").css('width'),10)+3 : $this.width();
			$("span#"+ID+ ", span#"+ID+" > table").css({ width: SpanWidth, zIndex: 9999 });
		 }
	      }
	      $('span#'+ID) 
	      .stop(true,false)
	      .show(0)
	      .position({
		  my : "left top",
		  at : "left bottom",
		  of : $this,
		  collision: 'fit fit',
		  offset: '0 0'
	      });
	      if ( options.type === "tooltip" ) { 
		 $("span#" + ID ).delay(options.FadeOut).fadeOut(500);
	      }
	   });
	   $this.off('mouseleave');
	   $this.on('mouseleave', function(e) {
	      if ( defaults.AltClass !== "" ) { 
		 if ( options.AltClass && $this.attr('class') && $this.attr('class').match(options.AltClass) !== null ) {
		    $(this).removeClass(options.AltClass);
		 }
	      }
	       if ( options.type === "tooltip" ) {
		     $("span#" + ID ).remove();
	       } else {
		  setTimeout(function(){ 
		       /*--  check the control's data.hover field to see if mouse is over the control  --*/
		      if ( $("span#"+ID).data('hover') === false ) {
			     $('span#'+ID).remove();  
		      }
		  }, 1);  
	       }
	    });
	 });  
    };
})( jQuery );
