import java.util.List;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;

public class AuthorDB {
    private final Connection connection;

    public AuthorDB(Connection connection) {
        this.connection = connection;
    }

    public void insert(Author author) throws DBException {
        if (author == null) {
            return;
        }

        var sql = "INSERT INTO Authors (FirstName, LastName, BirthDate) VALUES (?,?,?)";

        try (var statement = connection.prepareStatement(sql)) {
            // Bind values to parameters
            statement.setString(1, author.getFirstName());
            statement.setString(2, author.getLastName());
            statement.setDate(3, Date.valueOf(author.getBirthDate()));

            // Execute the query
            statement.executeUpdate();

        } catch (SQLException e) {
            throw new DBException(e.getMessage());
        }
    }

}
