import java.sql.SQLException;
import java.time.LocalDate;

public class Main {
    public static void main(String[] args) {

        // Create a new Author object
        var author = new Author("John","Doe",LocalDate.of(1990, 12, 31));

        // Connect to the SQL Server
        try (var connection = SQLServerConnection.connect()) {
            // Create a new AuthorDB object
            var authorDB = new AuthorDB(connection);

            // Insert the author into the database
            authorDB.insert(author);
        } catch (SQLException | DBException e) {
            System.err.println(e.getMessage());
        }
    }
}