import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class CSV {
    public static List<Author> read(String filename) throws IOException {
        return Files.lines(Paths.get(filename))
                .skip(1) // Skip the first line (header)
                .map(CSV::parseLineToAuthor)
                .collect(Collectors.toList());
    }

    private static Author parseLineToAuthor(String line) {
        String[] fields = line.split(",");

        if (fields.length < 3) {
            throw new IllegalArgumentException("Invalid line: " + line);
        }

        String firstName = fields[0].trim();
        String lastName = fields[1].trim();
        LocalDate birthDate = LocalDate.parse(fields[2].trim(), DateTimeFormatter.ISO_LOCAL_DATE);

        return new Author(firstName, lastName, birthDate);
    }
}
