import java.sql.SQLException;

public class Main {
    public static void main(String[] args) {
        try (var connection = SQLServerConnection.connect()) {
            var authorDB = new AuthorDB(connection);
            // Find author with id 1
            var author = authorDB.findById(1);
            // Change the first name
            author.setFirstName("Johnson");
            // Update the author
            authorDB.update(author);

        } catch (SQLException | DBException e) {
            System.err.println(e.getMessage());
        }
    }
}