/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.PicassoExecutorService;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

class Dispatcher {
    private static final int RETRY_DELAY = 500;
    private static final int AIRPLANE_MODE_ON = 1;
    private static final int AIRPLANE_MODE_OFF = 0;
    static final int REQUEST_SUBMIT = 1;
    static final int REQUEST_CANCEL = 2;
    static final int REQUEST_GCED = 3;
    static final int HUNTER_COMPLETE = 4;
    static final int HUNTER_RETRY = 5;
    static final int HUNTER_DECODE_FAILED = 6;
    static final int HUNTER_DELAY_NEXT_BATCH = 7;
    static final int HUNTER_BATCH_COMPLETE = 8;
    static final int NETWORK_STATE_CHANGE = 9;
    static final int AIRPLANE_MODE_CHANGE = 10;
    private static final String DISPATCHER_THREAD_NAME = "Dispatcher";
    private static final int BATCH_DELAY = 200;
    final DispatcherThread dispatcherThread = new DispatcherThread();
    final Context context;
    final ExecutorService service;
    final Downloader downloader;
    final Map<String, BitmapHunter> hunterMap;
    final Handler handler;
    final Handler mainThreadHandler;
    final Cache cache;
    final Stats stats;
    final List<BitmapHunter> batch;
    final NetworkBroadcastReceiver receiver;
    NetworkInfo networkInfo;
    boolean airplaneMode;

    Dispatcher(Context context, ExecutorService service, Handler mainThreadHandler, Downloader downloader, Cache cache, Stats stats) {
        this.dispatcherThread.start();
        this.context = context;
        this.service = service;
        this.hunterMap = new LinkedHashMap<String, BitmapHunter>();
        this.handler = new DispatcherHandler(this.dispatcherThread.getLooper(), this);
        this.downloader = downloader;
        this.mainThreadHandler = mainThreadHandler;
        this.cache = cache;
        this.stats = stats;
        this.batch = new ArrayList<BitmapHunter>(4);
        this.airplaneMode = Utils.isAirplaneModeOn(this.context);
        this.receiver = new NetworkBroadcastReceiver(this.context);
        this.receiver.register();
    }

    void shutdown() {
        this.service.shutdown();
        this.dispatcherThread.quit();
        this.receiver.unregister();
    }

    void dispatchSubmit(Action action) {
        this.handler.sendMessage(this.handler.obtainMessage(1, (Object)action));
    }

    void dispatchCancel(Action action) {
        this.handler.sendMessage(this.handler.obtainMessage(2, (Object)action));
    }

    void dispatchComplete(BitmapHunter hunter) {
        this.handler.sendMessage(this.handler.obtainMessage(4, (Object)hunter));
    }

    void dispatchRetry(BitmapHunter hunter) {
        this.handler.sendMessageDelayed(this.handler.obtainMessage(5, (Object)hunter), 500L);
    }

    void dispatchFailed(BitmapHunter hunter) {
        this.handler.sendMessage(this.handler.obtainMessage(6, (Object)hunter));
    }

    void dispatchNetworkStateChange(NetworkInfo info) {
        this.handler.sendMessage(this.handler.obtainMessage(9, (Object)info));
    }

    void dispatchAirplaneModeChange(boolean airplaneMode) {
        this.handler.sendMessage(this.handler.obtainMessage(10, airplaneMode ? 1 : 0, 0));
    }

    void performSubmit(Action action) {
        BitmapHunter hunter = this.hunterMap.get(action.getKey());
        if (hunter != null) {
            hunter.attach(action);
            return;
        }
        if (this.service.isShutdown()) {
            return;
        }
        hunter = BitmapHunter.forRequest(this.context, action.getPicasso(), this, this.cache, this.stats, action, this.downloader);
        hunter.future = this.service.submit(hunter);
        this.hunterMap.put(action.getKey(), hunter);
    }

    void performCancel(Action action) {
        String key = action.getKey();
        BitmapHunter hunter = this.hunterMap.get(key);
        if (hunter != null) {
            hunter.detach(action);
            if (hunter.cancel()) {
                this.hunterMap.remove(key);
            }
        }
    }

    void performRetry(BitmapHunter hunter) {
        if (hunter.isCancelled()) {
            return;
        }
        if (this.service.isShutdown()) {
            this.performError(hunter);
            return;
        }
        if (hunter.shouldRetry(this.airplaneMode, this.networkInfo)) {
            hunter.future = this.service.submit(hunter);
        } else {
            this.performError(hunter);
        }
    }

    void performComplete(BitmapHunter hunter) {
        if (!hunter.shouldSkipMemoryCache()) {
            this.cache.set(hunter.getKey(), hunter.getResult());
        }
        this.hunterMap.remove(hunter.getKey());
        this.batch(hunter);
    }

    void performBatchComplete() {
        ArrayList<BitmapHunter> copy = new ArrayList<BitmapHunter>(this.batch);
        this.batch.clear();
        this.mainThreadHandler.sendMessage(this.mainThreadHandler.obtainMessage(8, copy));
    }

    void performError(BitmapHunter hunter) {
        this.hunterMap.remove(hunter.getKey());
        this.batch(hunter);
    }

    void performAirplaneModeChange(boolean airplaneMode) {
        this.airplaneMode = airplaneMode;
    }

    void performNetworkStateChange(NetworkInfo info) {
        this.networkInfo = info;
        if (this.service instanceof PicassoExecutorService) {
            ((PicassoExecutorService)this.service).adjustThreadCount(info);
        }
    }

    private void batch(BitmapHunter hunter) {
        if (hunter.isCancelled()) {
            return;
        }
        this.batch.add(hunter);
        if (!this.handler.hasMessages(7)) {
            this.handler.sendEmptyMessageDelayed(7, 200L);
        }
    }

    private class NetworkBroadcastReceiver
    extends BroadcastReceiver {
        private static final String EXTRA_AIRPLANE_STATE = "state";
        private final ConnectivityManager connectivityManager;

        NetworkBroadcastReceiver(Context context) {
            this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        void register() {
            boolean shouldScanState = Dispatcher.this.service instanceof PicassoExecutorService && Utils.hasPermission(Dispatcher.this.context, "android.permission.ACCESS_NETWORK_STATE");
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.AIRPLANE_MODE");
            if (shouldScanState) {
                filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            }
            Dispatcher.this.context.registerReceiver((BroadcastReceiver)this, filter);
        }

        void unregister() {
            Dispatcher.this.context.unregisterReceiver((BroadcastReceiver)this);
        }

        public void onReceive(Context context, Intent intent) {
            if (null == intent) {
                return;
            }
            String action = intent.getAction();
            Bundle extras = intent.getExtras();
            if ("android.intent.action.AIRPLANE_MODE".equals(action)) {
                Dispatcher.this.dispatchAirplaneModeChange(extras.getBoolean(EXTRA_AIRPLANE_STATE, false));
            } else if ("android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
                Dispatcher.this.dispatchNetworkStateChange(this.connectivityManager.getActiveNetworkInfo());
            }
        }
    }

    static class DispatcherThread
    extends HandlerThread {
        DispatcherThread() {
            super("Picasso-Dispatcher", 10);
        }
    }

    private static class DispatcherHandler
    extends Handler {
        private final Dispatcher dispatcher;

        public DispatcherHandler(Looper looper, Dispatcher dispatcher) {
            super(looper);
            this.dispatcher = dispatcher;
        }

        public void handleMessage(final Message msg) {
            switch (msg.what) {
                case 1: {
                    Action action = (Action)msg.obj;
                    this.dispatcher.performSubmit(action);
                    break;
                }
                case 2: {
                    Action action = (Action)msg.obj;
                    this.dispatcher.performCancel(action);
                    break;
                }
                case 4: {
                    BitmapHunter hunter = (BitmapHunter)msg.obj;
                    this.dispatcher.performComplete(hunter);
                    break;
                }
                case 5: {
                    BitmapHunter hunter = (BitmapHunter)msg.obj;
                    this.dispatcher.performRetry(hunter);
                    break;
                }
                case 6: {
                    BitmapHunter hunter = (BitmapHunter)msg.obj;
                    this.dispatcher.performError(hunter);
                    break;
                }
                case 7: {
                    this.dispatcher.performBatchComplete();
                    break;
                }
                case 9: {
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    this.dispatcher.performNetworkStateChange(info);
                    break;
                }
                case 10: {
                    this.dispatcher.performAirplaneModeChange(msg.arg1 == 1);
                    break;
                }
                default: {
                    Picasso.HANDLER.post(new Runnable(){

                        @Override
                        public void run() {
                            throw new AssertionError((Object)("Unknown handler message received: " + msg.what));
                        }
                    });
                }
            }
        }
    }
}

