/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import com.squareup.picasso.Action;
import com.squareup.picasso.Cache;
import com.squareup.picasso.ContentStreamBitmapHunter;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import java.io.IOException;

class MediaStoreBitmapHunter
extends ContentStreamBitmapHunter {
    private static final String[] CONTENT_ORIENTATION = new String[]{"orientation"};

    MediaStoreBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(context, picasso, dispatcher, cache, stats, action);
    }

    @Override
    Bitmap decode(Request data) throws IOException {
        ContentResolver contentResolver = this.context.getContentResolver();
        this.setExifRotation(MediaStoreBitmapHunter.getExitOrientation(contentResolver, data.uri));
        if (data.hasSize()) {
            PicassoKind picassoKind = MediaStoreBitmapHunter.getPicassoKind(data.targetWidth, data.targetHeight);
            if (picassoKind == PicassoKind.FULL) {
                return super.decode(data);
            }
            long id = ContentUris.parseId((Uri)data.uri);
            BitmapFactory.Options options = MediaStoreBitmapHunter.createBitmapOptions(data);
            options.inJustDecodeBounds = true;
            MediaStoreBitmapHunter.calculateInSampleSize(data.targetWidth, data.targetHeight, picassoKind.width, picassoKind.height, options);
            Bitmap result = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)id, (int)picassoKind.androidKind, (BitmapFactory.Options)options);
            if (result != null) {
                return result;
            }
        }
        return super.decode(data);
    }

    static PicassoKind getPicassoKind(int targetWidth, int targetHeight) {
        if (targetWidth <= PicassoKind.MICRO.width && targetHeight <= PicassoKind.MICRO.height) {
            return PicassoKind.MICRO;
        }
        if (targetWidth <= PicassoKind.MINI.width && targetHeight <= PicassoKind.MINI.height) {
            return PicassoKind.MINI;
        }
        return PicassoKind.FULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getExitOrientation(ContentResolver contentResolver, Uri uri) {
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(uri, CONTENT_ORIENTATION, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                int n = 0;
                return n;
            }
            int n = cursor.getInt(0);
            return n;
        }
        catch (RuntimeException ignored) {
            int n = 0;
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    static enum PicassoKind {
        MICRO(3, 96, 96),
        MINI(1, 512, 384),
        FULL(2, -1, -1);

        final int androidKind;
        final int width;
        final int height;

        private PicassoKind(int androidKind, int width, int height) {
            this.androidKind = androidKind;
            this.width = width;
            this.height = height;
        }
    }
}

