/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.widget.ImageView;
import com.squareup.picasso.Picasso;

final class PicassoDrawable
extends Drawable {
    private static final Paint DEBUG_PAINT = new Paint();
    private static final float FADE_DURATION = 200.0f;
    private final boolean debugging;
    private final float density;
    private final Picasso.LoadedFrom loadedFrom;
    final BitmapDrawable image;
    Drawable placeholder;
    long startTimeMillis;
    boolean animating;
    int alpha = 255;

    static void setBitmap(ImageView target, Context context, Bitmap bitmap, Picasso.LoadedFrom loadedFrom, boolean noFade, boolean debugging) {
        Drawable placeholder = target.getDrawable();
        if (placeholder instanceof AnimationDrawable) {
            ((AnimationDrawable)placeholder).stop();
        }
        PicassoDrawable drawable = new PicassoDrawable(context, placeholder, bitmap, loadedFrom, noFade, debugging);
        target.setImageDrawable((Drawable)drawable);
    }

    static void setPlaceholder(ImageView target, int placeholderResId, Drawable placeholderDrawable) {
        if (placeholderResId != 0) {
            target.setImageResource(placeholderResId);
        } else {
            target.setImageDrawable(placeholderDrawable);
        }
        if (target.getDrawable() instanceof AnimationDrawable) {
            ((AnimationDrawable)target.getDrawable()).start();
        }
    }

    PicassoDrawable(Context context, Drawable placeholder, Bitmap bitmap, Picasso.LoadedFrom loadedFrom, boolean noFade, boolean debugging) {
        boolean fade;
        Resources res = context.getResources();
        this.debugging = debugging;
        this.density = res.getDisplayMetrics().density;
        this.loadedFrom = loadedFrom;
        this.image = new BitmapDrawable(res, bitmap);
        boolean bl = fade = loadedFrom != Picasso.LoadedFrom.MEMORY && !noFade;
        if (fade) {
            this.placeholder = placeholder;
            this.animating = true;
            this.startTimeMillis = SystemClock.uptimeMillis();
        }
    }

    public void draw(Canvas canvas) {
        if (!this.animating) {
            this.image.draw(canvas);
        } else {
            float normalized = (float)(SystemClock.uptimeMillis() - this.startTimeMillis) / 200.0f;
            if (normalized >= 1.0f) {
                this.animating = false;
                this.placeholder = null;
                this.image.draw(canvas);
            } else {
                if (this.placeholder != null) {
                    this.placeholder.draw(canvas);
                }
                int partialAlpha = (int)((float)this.alpha * normalized);
                this.image.setAlpha(partialAlpha);
                this.image.draw(canvas);
                this.image.setAlpha(this.alpha);
                this.invalidateSelf();
            }
        }
        if (this.debugging) {
            this.drawDebugIndicator(canvas);
        }
    }

    public int getIntrinsicWidth() {
        return this.image.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.image.getIntrinsicHeight();
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        if (this.placeholder != null) {
            this.placeholder.setAlpha(alpha);
        }
        this.image.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.placeholder != null) {
            this.placeholder.setColorFilter(cf);
        }
        this.image.setColorFilter(cf);
    }

    public int getOpacity() {
        return this.image.getOpacity();
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.image.setBounds(bounds);
        if (this.placeholder != null) {
            this.placeholder.setBounds(bounds);
        }
    }

    private void drawDebugIndicator(Canvas canvas) {
        DEBUG_PAINT.setColor(-1);
        Path path = PicassoDrawable.getTrianglePath(new Point(0, 0), (int)(16.0f * this.density));
        canvas.drawPath(path, DEBUG_PAINT);
        DEBUG_PAINT.setColor(this.loadedFrom.debugColor);
        path = PicassoDrawable.getTrianglePath(new Point(0, 0), (int)(15.0f * this.density));
        canvas.drawPath(path, DEBUG_PAINT);
    }

    private static Path getTrianglePath(Point p1, int width) {
        Point p2 = new Point(p1.x + width, p1.y);
        Point p3 = new Point(p1.x, p1.y + width);
        Path path = new Path();
        path.moveTo((float)p1.x, (float)p1.y);
        path.lineTo((float)p2.x, (float)p2.y);
        path.lineTo((float)p3.x, (float)p3.y);
        return path;
    }
}

