<?php

// The above starts the PHP and it ends down at the bottom
// You can end PHP at any time write HTML and go back into PHP or not, etc.

// ZIM Bind as of ZIM 10.9.0 - https://zimjs.com/docs.html?item=Bind
// ZIM supports data binding of JSON-ready properties on objects
// This PHP page is an example of the structure for binding with either GET or POST
// -- GET and POST can also be sent from a DOM HTML form tag using the method parameter
// -- The same code can be used for receiving and sending data to the DOM

// Here, we are collecting the GET or POST data from ZIM on the Canvas
// We use two common Web technologies called JSONp and AJAX
// GET with ZIM async() uses JSONp and is limited to 2048 characters
    // an advantage of JSONp is that the HTML page can be run from the client
    // this makes testing building and testing easier - just save and test
// POST with ZIM Ajax() is similar and happily has unlimited data
    // but unfortunately, the HTML (and the server) page must be on the server
    // this makes testing harder - so we recommend building and testing with GET
    // and then switching over to POST for the final production

// CONNECT TO THE DATABASE - set this up in cPanel under MySQL Databases, etc.
// Note: in PHP the variables start with $
// $hostname = "localhost"; // just use "localhost"
// $username = "username";  // enter your own values for these three
// $password = "password";
// $databasename = "databasename";
// $mysqli = new mysqli($hostname, $username, $password, $databasename);

// Use MySQLi or PDO for a safer way to connect (mysql is old and unsafe)
// We are using the object oriented version of mysqli so note the new keyword
// $mysqli = new mysqli($hostname, $username, $password, $databasename);

// We are hiding our information in a remote PHP page
require_once('../../all/allNew.php');

// ZIM BASE class for database manipulation
require_once("zimbase.php");

// provides global $type, $master, $data, $command, $extra, $lock, $unique
// unless second parameter is set to false in which case use $base->$data, etc.
$base = new ZIM_Base($mysqli);

// ZIM Bind methods send the following variables
// ZIM Base makes these global variables - we may not use them all...

// $master - information for all "to" and "from" - like a room, etc.
// $data - the JSON data to store or the data requested
// $command - "to" or "from" to store or retrieve data
// $extra - holds extra information we might need like an id
// $lock - are we wanting to record lock - see ZIM PHP setLock() function
// $unique - is whether we want our "to" to be unique (if not, we can update)

// in this case, our extra data holds our hero name
$name = $extra;

if ($name == "") $base->reply("error","missing id");

if ($command == "to") {

    // GENERAL DATA - stored as JSON
    // ZIM Bind to() will send a data property in JSON format:
    // '{"id1":{"prop1":"value", "prop2":"value"}, "id2":{"prop3":"value"}}'
    // In this example we are going to just store the JSON directly

    // SPECIFIC DATA
    // we could split the data up and store it in separate fields
    // something like this:
    // $obj = json_decode($data); // decodes to a PHP Object
    // $name = $obj->name->text; // the -> is like the dot syntax in JavaScript
    // $lucky = $obj->lucky->currentValue;
    // $color = $obj->color->selectedColor;

    // OR - we could set the ZIM Bind() "couple" parameter to true
    // this would give us a flattened JSON file for ease of adding to the table

    // $obj = json_decode($data); // decodes to a PHP Object
    // so we use $obj->name_text, etc. the -> is like the dot syntax in JavaScript
    // and the name_text is the coupled format for our property

    // or $arr = json_decode($data, true); // this saves to a PHP Associative Array
    // so we use $arr["name_text"], etc.
    // Either way is fine, we will use the PHP object

    // DATABASE TABLES
    // A Database can have tables added to them in PHPMyAdmin for instance (see cPanel, etc.)
    // A TABLE is used to hold data for a project or part of a project
    // Some projects may have user information in one table and page stats in another, etc.
    // The table has field names going across top (columns)
    // and records going down (rows) with data stored in the appropriate column
    // Each table must (is supposed to) have a primary key field - that is unique
    // There is an auto incrementing setting to automatically increase an id if desired
    // Each field can hold a certain type of data like an int, varchar, text, date, etc.
    // These are specified as the table is made or set up at the start

    // OUR TABLE
    // Our table is called zim_hero
    // We want to store a name, data and date
    // The name will be the hero name as type varchar 255
    // and we want it to be our primary key and unique
    // The data is of type text
    // The date is of type date

    // If we want to see if the name is unique then
    // then we select the name and check the num_rows
    if ($unique) {
        // select($table, $fields, $where, $more)
        $response = $base->select("zim_hero", "name", [name=>$name]);
        if ($response->error) {
            $base->reply("error", "could not access data");
        } else if ($response->num_rows > 0) {
            $base->reply("error", "that Hero name is taken");
        }
    }

    // here we insert or update the entry
    // insert($table, $fields, $update, $where, $more)
    $response = $base->insert("zim_hero", [name=>$name, data=>$data, date=>"NOW()"], [data=>$data]);
    if ($response->error) {
        $base->reply("error", "could not access data");
    } else {
        $base->reply("success", "hero added/updated");
    }

} else if ($base->command == "from") {


    // send back five other heros
    $response = $base->select("zim_hero", "data", [name=>["NOT", "=", $name]], "ORDER BY RAND() LIMIT 5");

    if ($response->error) {
        $base->reply("error", "could not access data");
    } else if ($response->num_rows == 0) {
        $base->reply("[]");
    } else {
        $base->reply($response->json); // use for single json field - returns json array
    }
}

?>
