import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;


public class XpathDemo
{
		public static void main(String[] args) throws Exception
		{

				DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
				documentBuilderFactory.setNamespaceAware(true);
				DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
				Document doc = documentBuilder.parse("src/cricketTeam_info.xml");

				XPathFactory xpathFactory = XPathFactory.newInstance();
				XPath xpath = xpathFactory.newXPath();

				// XPath concat example
				XPathExpression expr = xpath.compile("concat(//cricketer[name='Shami']/@type,//cricketer[name='Zaheer Khan']/@type)");
				String combination = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The concat result is : " + combination);

				// XPath starts-with example
				expr = xpath.compile("//cricketer[starts-with(name,'Za')]/name/text()");
				String startswith = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The Player name starting-with 'Za'  is : " + startswith);

				// XPath contains example
				expr = xpath.compile("//cricketer[contains(name,'MS')]/name/text()");
				String msdesc = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The Player with name containing 'MS' is : " + msdesc);

				// XPath substring-before example
				expr = xpath.compile("substring-before(//cricketer[name='MS Dhoni']/position,'-Keeper')");
				String substrbefore = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The substring before Keeper is : " + substrbefore);

		   	// XPath substring-after example
				expr = xpath.compile("substring-after(//cricketer[name='MS Dhoni']/position,'Wicket-')");
				String substrafter = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The substring after Keeper is : " + substrafter);

				// XPath substring example
				expr = xpath.compile("substring(//cricketer[name='MS Dhoni']/position,'1','4')");
				String substr = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The substring is : " + substr);

				// XPath string-length(string) example
				expr = xpath.compile("string-length(//cricketer[name='MS Dhoni']/position)");
				String strlength = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The length of the string is : " + strlength);

				// XPath normalize-space(string) example
				expr = xpath.compile("normalize-space(//cricketer[name='Shikhar Dhawan']/role/text())");
				String result = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The normalized string is : " + result);

				expr = xpath.compile("translate('Shikhar Dhawan','S','K')");
				String replacedstring = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The translated string is : " + replacedstring);
		}
}
