package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public abstract class ListBaseTest {

	protected Logger logger;

	List<String> list;

	@Test
	public void test_add() {
		// Adding items to arrayList
		list.add("new Item");
		assertEquals(5, list.size());

		// Display the contents of the array list
		logger.info("The arraylist contains the following elements: " + list);
	}

	@Test
	public void test_contains() {
		// Checking if an element is included to the list
		assertTrue(list.contains("Item1"));
		assertFalse(list.contains("Item5"));
	}

	@Test
	public void test_get() {
		assertEquals("Item1", list.get(0));
		assertEquals("Item2", list.get(1));
		assertEquals("Item3", list.get(2));
		assertEquals("Item4", list.get(3));
	}

	@Test
	public void test_getSize() {
		// Getting the size of the list
		assertEquals(4, list.size());
	}

	@Test
	public void test_indexOf() {
		// Checking index of an item
		int pos = list.indexOf("Item2");
		assertEquals(1, pos);
	}

	@Test
	public void test_isEmpty() {
		// Checking if array list is empty
		assertFalse(list.isEmpty());
	}

	@Test
	public void test_loop_arraylist_via_for() {
		// Retrieve elements from the arraylist via foreach
		logger.info("Retrieving items using foreach loop");
		for (String str : list) {
			logger.info("Item is: " + str);
		}
	}

	@Test
	public void test_loop_arraylist_via_for_2() {
		// Retrieve elements from the arraylist via loop using index and size list
		logger.info("Retrieving items with loop using index and size list");
		for (int i = 0; i < list.size(); i++) {
			logger.info("Index: " + i + " - Item: " + list.get(i));
		}
	}

	@Test
	public void test_loop_arrayList_via_foreach() {
		logger.info("Retrieving items using Java 8 Stream");
		list.forEach((item) -> {
			logger.info(item);
		});
	}

	@Test
	public void test_loop_arraylist_via_iterator_for() {
		// hasNext(): returns true if there are more elements
		// next(): returns the next element
		logger.info("Retrieving items using iterator");
		for (Iterator<String> it = list.iterator(); it.hasNext();) {
			logger.info("Item is: " + it.next());
		}
	}

	@Test
	public void test_loop_arraylist_via_iterator_while() {
		Iterator<String> it = list.iterator();
		logger.info("Retrieving items using iterator");
		while (it.hasNext()) {
			logger.info("Item is: " + it.next());
		}
	}

	@Test
	public void test_remove() {
		// removing the item in index 0
		list.remove(0);
		assertEquals(3, list.size());
		assertEquals("Item2", list.get(0));
		assertEquals("Item3", list.get(1));
		assertEquals("Item4", list.get(2));

		// removing the first occurrence of item "Item3"
		list.remove("Item3");
		assertEquals(2, list.size());
		assertEquals("Item2", list.get(0));
		assertEquals("Item4", list.get(1));
	}

	@Test
	public void test_replace() {
		// Replacing an element
		list.set(1, "NewItem");
		assertEquals("Item1", list.get(0));
		assertEquals("NewItem", list.get(1));
		assertEquals("Item3", list.get(2));
		assertEquals("Item4", list.get(3));
	}

	@Test
	public void test_toArray() {
		// Converting ArrayList to Array
		String[] simpleArray = list.toArray(new String[list.size()]);
		logger.info("The array created after the conversion of our arraylist is: " + Arrays.toString(simpleArray));
	}
}