const express = require("express");
const cors = require("cors");

const dotenv = require("dotenv");
dotenv.config();

const app = express();
app.use(express.json());
app.use(
  cors({
    origin: "*" // helps to receive a request from any domain
  })
);

app.get("/", (req, res) => {
  res.status(200).json({ data: "backend for reactjs is running" });
});

const db = require("./users");

// http get endpoint - http://localhost:9500/health
app.get("/health", db.health);
// http get endpoint - http://localhost:9500/all
app.get("/all", db.getUsers);

const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
  console.log(`app running on http://localhost:${PORT}`);
});
