const Pool = require("pg").Pool;

// you're free to change the database details as per your setup
// reading it from the .env file or using default in case the file is missing
const pool = new Pool({
  user: process.env.DATABASE_USER || "postgres",
  host: "localhost",
  database: process.env.DATABASE || "learning",
  password: process.env.DATABASE_PASSWORD || "p@S$w0rd@123!",
  port: 5432
});

const health = (req, res) => {
  pool.query("select version()", (err, result) => {
    if (err) {
      console.log("err in getting db health", err);
      throw err;
    }
    return res.status(200).json({ data: result.rows[0].version });
  });
};

const getUsers = (req, res) => {
  pool.query("select id, name, email, age from users", (err, result) => {
    if (err) {
      console.log("err in fetching all users", err);
      throw err;
    }
    // console.log("data fetched");
    return res.status(200).json({ data: result.rows });
  });
};

module.exports = {
  health,
  getUsers
};
