import React, { useState } from "react";
import "./App.css";

function App() {
  const create = "http://localhost:9500/create";

  const [name, setName] = useState("");
  const [email, setEmail] = useState("");
  const [age, setAge] = useState("");

  let [status, setStatus] = useState(undefined);
  let [state, setState] = useState(undefined);

  function saveUser() {
    // console.log(name, email, age);
    let data = { name, email, age };

    // input form validation
    if (!data.name || !data.email || !data.age) {
      setState({ error: "field cannot be blank or empty" });
      return;
    }

    let requestOptions = {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify(data),
    };

    fetch(create, requestOptions)
      .then((result) => {
        // handle response
        // console.log("data created", result);
        setStatus({ type: "success", message: result.statusText });

        // Todo - add the fetch api to show response
      })
      .catch((err) => {
        // handle error
        // console.log("error occurred!", err);
        setStatus({ type: "error", message: err.message });
      });
  }

  return (
    <div className="App">
      <h1>React crud - Fetch POST example</h1>
      <input
        type="text"
        name="name"
        value={name}
        onChange={(e) => {
          setState("");
          setName(e.target.value);
        }}
        placeholder="Enter name"
      />
      <br /> <br />
      <input
        type="email"
        name="email"
        value={email}
        onChange={(e) => {
          setState("");
          setEmail(e.target.value);
        }}
        placeholder="Enter email"
      />
      <br /> <br />
      <input
        type="number"
        name="age"
        value={age}
        onChange={(e) => {
          setState("");
          setAge(e.target.value);
        }}
        placeholder="Enter age"
      />
      <br /> <br />
      <button type="button" onClick={saveUser}>
        Create new user
      </button>
      <div id="note">
        <small>
          Get all users can be fetched by clicking
          <a
            id="getall-users"
            href="http://localhost:9500/all"
            target="_blank"
            rel="noreferrer"
          >
            here
          </a>
        </small>
      </div>
      <div id="validations">
        {state?.error !== undefined && <p>{state?.error}</p>}
        {status?.type === "success" && <p>{status?.message}</p>}
        {status?.type === "error" && <p>{status?.message}</p>}
      </div>
    </div>
  );
}

export default App;
