# devowl.io WordPress Plugins Monorepo

This repository contains the WordPress plugins from devowl.io, including packages that are shared between plugins. Feel free to learn from the code and incorporate this knowledge into your own developments!

## Prerequisites

1. [Install NodeJS v18.x](https://nodejs.org/en/download/)
1. [Install `pnpm@10`](https://pnpm.io/installation)
1. [Install `composer@2`](https://getcomposer.org/download/)

## Getting started

1. Run `pnpm bootstrap` to install all dependencies including NPM and PHP Composer.
1. Run `pnpm build:js:development` to build the JavaScript files from all TypeScript files across all packages and plugins.
1. Navigate to a single WordPress plugin with e.g. `cd wordpress-plugins/real-custom-post-order` and run the `pnpm dev` command to start the development build via webpack. The compiled files are stored in the `src/public/dev` folder.
1. Tip: Ensure you are using [`SCRIPT_DEBUG=true`](https://developer.wordpress.org/advanced-administration/debug/debug-wordpress/#script_debug) in your WordPress environment to ensure the development build is used.
1. If you want to test/install the plugin, you can easily mount the plugin folder into your WordPress container by adding the following to your `docker-compose.yml` file:

```yaml
services:
    wordpress:
        # [...] other configurations
        volumes:
            # Composer PHP files
            - ${REPO_PWD}/wordpress-plugins/<the-plugin-you-want-to-mount>/vendor:/var/www/html/wp-content/plugins/<the-plugin-you-want-to-mount>/vendor
            # The main plugin source
            - ${REPO_PWD}/wordpress-plugins/<the-plugin-you-want-to-mount>/src:/var/www/html/wp-content/plugins/<the-plugin-you-want-to-mount>
            # Allow symlinking for composer "path" repositories so symlinked packages in composer work as expected
            - ${REPO_PWD}/wordpress-packages:/var/www/html/wp-content/wordpress-packages
            - ${REPO_PWD}/isomorphic-packages:/var/www/html/wp-content/isomorphic-packages
```

## Troubleshooting

> FATAL ERROR: Reached heap limit Allocation failed - JavaScript heap out of memory

You need to increase the heap limit for NodeJS. Please check out this [article](https://dev.to/abdielwilsn/how-to-fix-fatal-reached-heap-limit-allocation-failed-javascript-heap-out-of-memory-2ab2) and configure your environment accordingly.
