import type { ESupportedLanguage } from "../../route/supported-languages/supported-languages.get.js";

type TranslationFlaggedWordCount = {
    [key: string]: number;
};
/**
 * Key: property name
 * Entry:
 *  translatableWords = source language words for property
 *  translations = Array with entries showing target language translatedWords
 */
type StatisticsProperty = Record<
    string,
    {
        sourceLanguage: ESupportedLanguage;
        translatableWords: number;
        translations: {
            [language in ESupportedLanguage]?: {
                translatedWords: number;
                missingTranslationEntities?: string[]; // filled, when property is not translated
                flaggedWords?: TranslationFlaggedWordCount;
            };
        };
    }
>;

type StatisticsEntity = {
    entity?: string;
    sourceLanguage: ESupportedLanguage;
    sumTranslatableWords: number;
    translations: {
        [language in ESupportedLanguage]?: {
            sumTranslatedWords: number;
            sumTranslationFlaggedWords: TranslationFlaggedWordCount;
        };
    };
    statisticsProperty: StatisticsProperty;
    missingEntityIdentifiedBy?: string | number | symbol;
    calculatedIdentifier: string[];
};

export { type StatisticsEntity, type StatisticsProperty };
