import type { EMachineTranslationStatus, IStorage, ITranslationStatus } from "@devowl-wp/api";

import type { ITemplateMetaDataTranslatable } from "./translatable.js";
import type { IUser } from "../../user/user.js";

interface ITemplateMetaData extends ITemplateMetaDataTranslatable {
    id: string;
    extends?: ITemplateMetaData;
    extendsId?: string;
    extendsIdentifier?: string;
    extendedTemplateId?: string;
    extendedMergeStrategies?: Record<string, EExtendsMergeStrategy>;

    identifier: string;
    version: number;
    logo: IStorage;
    logoId?: string;

    enabledWhenOneOf?: string[];
    isHidden: boolean;
    recommendedWhenOneOf?: string[];

    /**
     * Adding successors for outdated and deleted templates (CU-869372jf7)
     * @see https://app.clickup.com/t/869372jf7
     */
    successorOfIdentifier?: string[];
    successorOfIdentifierInfo?: TemplateSuccessorOfInfo[];

    status: ETemplateStatus;
    createdAt: Date;
    next?: ITemplateMetaData;
    nextId?: string;
    pre?: ITemplateMetaData;
    preId?: string;
    minRequiredRcbVersion: string;
    tier: ERcbTier;
    isDeleted: boolean;

    /**
     * Adding last edited by CU-86936my3v
     * @see https://app.clickup.com/t/86936my3v
     */
    lastEditedBy?: IUser;

    /**
     * Adding favorite indicator for translation priority
     * @see https://app.clickup.com/t/2unbw4a
     */
    isFavourite: boolean;

    /**
     * Added indicator for machine translated templates. (CU-8692xtha4)
     *
     * @see https://app.clickup.com/t/8692xtha4
     */
    machineTranslationStatus?: EMachineTranslationStatus;

    /**
     * Added indicator for caching mechanism. (CU-2mjzexr)
     *
     * @see https://app.clickup.com/t/2mjzexr?comment=90040004776120
     */
    isExtendingMetaData: boolean;

    /**
     * Used to calculate status informations.
     *
     * @see https://app.clickup.com/t/2unbw4a
     */
    translationInfo?: ITranslationStatus[];

    /**
     * Used to calculate release status information. (CU-86936mue3)
     */
    releaseStatus?: ETemplateMetaDataVersionUpdateState;
}

type TemplateSuccessorOfInfo = { identifier: string; name: string };

enum EExtendsMergeStrategy {
    Append = "append",
    Overwrite = "overwrite",
    Clear = "clear",
    /**
     * Introducing Keep as strategy to keep values from extended template.
     *
     * @see https://app.clickup.com/t/861m6y395 (CU-861m6y395)
     * */
    Keep = "keep",
}

enum ETemplateStatus {
    Draft = "draft",
    Published = "published",
}

enum ERcbTier {
    Free = "free",
    Pro = "pro",
}

enum EWhenOneOfCondition {
    IsWordPressPluginOrThemeActive = "is-wordpress-plugin-or-theme-active",
}

enum ETemplateMetaDataVersionUpdateState {
    Initial = "initial",
    Update = "update",
    Notify = "notify",
    Removed = "removed",
    NeverReleased = "never-released",
}

type TemplateMetaDataColumn = keyof ITemplateMetaData;

/**
 * Represents the fields of a base template meta data.
 */
enum TemplateMetaDataField {
    CreatedAt = "createdAt",
    EnabledWhenOneOf = "enabledWhenOneOf",
    Extends = "extends",
    ExtendedMergeStrategies = "extendedMergeStrategies",
    ExtendedTemplateId = "extendedTemplateId",
    ExtendsId = "extendsId",
    ExtendsIdentifier = "extendsIdentifier",
    Headline = "headline",
    Id = "id",
    Identifier = "identifier",
    IsDeleted = "isDeleted",
    IsExtendingMetaData = "isExtendingMetaData",
    IsFavourite = "isFavourite",
    MachineTranslationStatus = "machineTranslationStatus",
    IsHidden = "isHidden",
    LastEditedBy = "lastEditedBy",
    Logo = "logo",
    LogoId = "logoId",
    MinRequiredRcbVersion = "minRequiredRcbVersion",
    Name = "name", // also known as displayName
    NameTranslationFlags = "nameTranslationFlags",
    Next = "next",
    NextId = "nextId",
    Pre = "pre",
    PreId = "preId",
    RecommendedWhenOneOf = "recommendedWhenOneOf",
    ReleaseStatus = "releaseStatus",
    SubHeadline = "subHeadline",
    Status = "status",
    SuccessorOfIdentifier = "successorOfIdentifier",
    SuccessorOfIdentifierInfo = "successorOfIdentifierInfo",
    Tier = "tier",
    TranslationInfo = "translationInfo",
    Version = "version",
}

export {
    TemplateMetaDataField,
    type TemplateSuccessorOfInfo,
    EExtendsMergeStrategy,
    ERcbTier,
    ETemplateMetaDataVersionUpdateState,
    ETemplateStatus,
    EWhenOneOfCondition,
    type ITemplateMetaData,
    type TemplateMetaDataColumn,
};
