import type { ETranslationFlag } from "@devowl-wp/api";

interface ITemplateMetaDataTranslatable {
    name: string;
    headline: string;
    subHeadline?: string;

    // Translation Flags 🚩
    nameTranslationFlags: ETranslationFlag[];
    headlineTranslationFlags: ETranslationFlag[];
    subHeadlineTranslationFlags: ETranslationFlag[];
}

type TemplateMetaDataTranslatableKeys = keyof ITemplateMetaDataTranslatable;

const TRANSLATABLE_METADATA_TEMPLATE_ATTRIBUTES_LIST: TemplateMetaDataTranslatableKeys[] = [
    "name",
    "headline",
    "subHeadline",
];
Object.freeze(TRANSLATABLE_METADATA_TEMPLATE_ATTRIBUTES_LIST);

export {
    type ITemplateMetaDataTranslatable,
    type TemplateMetaDataTranslatableKeys,
    TRANSLATABLE_METADATA_TEMPLATE_ATTRIBUTES_LIST,
};
