import type { ETranslationFlag, ITranslatableProperties, ITranslated, ITranslationProperties } from "@devowl-wp/api";

interface IServiceTemplateDynamicFieldTranslatable {
    label?: string;
    invalidMessage?: string;
    example?: string;
    hint?: string;

    // Translation Flags 🚩
    labelTranslationFlags: ETranslationFlag[];
    invalidMessageTranslationFlags: ETranslationFlag[];
    exampleTranslationFlags: ETranslationFlag[];
    hintTranslationFlags: ETranslationFlag[];
}

interface IServiceTemplateDynamicFieldTranslation
    extends IServiceTemplateDynamicFieldTranslatable,
        ITranslatableProperties,
        ITranslationProperties {}

interface IServiceTemplateDynamicField
    extends IServiceTemplateDynamicFieldTranslatable,
        ITranslated<IServiceTemplateDynamicFieldTranslation> {
    id: string;
    name: string;
    expression?: string;
    orderPosition: number;
}

export {
    type IServiceTemplateDynamicField,
    type IServiceTemplateDynamicFieldTranslatable,
    type IServiceTemplateDynamicFieldTranslation,
};
