import type { ETranslationFlag, ITranslatableProperties, ITranslated, ITranslationProperties } from "@devowl-wp/api";

interface IServiceTemplatePurposeTranslatable {
    answer: string;

    // Translation Flags 🚩
    answerTranslationFlags: ETranslationFlag[];
}

interface IServiceTemplatePurposeTranslation
    extends IServiceTemplatePurposeTranslatable,
        ITranslatableProperties,
        ITranslationProperties {}

interface IServiceTemplatePurpose
    extends IServiceTemplatePurposeTranslatable,
        ITranslated<IServiceTemplatePurposeTranslation> {
    id: string;
    question: string | EServiceTemplatePurpose;
    orderPosition: number;
    isNewParagraph: boolean;
}

/**
 * list adjusted according to https://app.clickup.com/t/2de4a0k
 * https://app.clickup.com/2088/v/dc/218-357/218-8301, section 8, field purpose
 */
enum EServiceTemplatePurpose {
    ServiceWebsiteFunction = "serviceWebsiteFunction",
    PersonalDataProcessing = "personalDataProcessing",
    PersonalDataUsage = "personalDataUsage",
    PersonalDataAdditionalAccess = "personalDataAdditionalAccess",
    PersonalDataLinking = "personalDataLinking",
    LegalBasisLegitimateInterest = "legalBasisLegitimateInterest",
    AutomatedDecisionAndProfilingImpact = "automatedDecisionAndProfilingImpact",
    CookieStorageInformation = "cookieStorageInformation",
    FingerprintingConsistingOf = "fingerprintingConsistingOf",
}

export {
    type IServiceTemplatePurposeTranslatable,
    type IServiceTemplatePurposeTranslation,
    type IServiceTemplatePurpose,
    EServiceTemplatePurpose,
};
