import type { ETranslationFlag, ITranslatableProperties, ITranslated, ITranslationProperties } from "@devowl-wp/api";

interface IServiceTemplateTechnicalDefinitionTranslatable {
    purpose?: string;

    // Translation Flags 🚩
    purposeTranslationFlags: ETranslationFlag[];
}

interface IServiceTemplateTechnicalDefinitionTranslation
    extends IServiceTemplateTechnicalDefinitionTranslatable,
        ITranslatableProperties,
        ITranslationProperties {}

interface IServiceTemplateTechnicalDefinition
    extends IServiceTemplateTechnicalDefinitionTranslatable,
        ITranslated<IServiceTemplateTechnicalDefinitionTranslation> {
    id: string;
    type: ETechnicalDefinitionType;
    name: string;
    host: string | ETechnicalDefinitionHostType;
    duration?: number;
    durationUnit?: ETechnicalDefinitionDurationUnit;
    isSessionDuration?: boolean;
    orderPosition: number;
}

enum ETechnicalDefinitionType {
    Http = "http",
    Local = "local",
    Session = "session",
    IndexedDb = "indexedDb",
}

enum ETechnicalDefinitionHostType {
    /**
     * nip.io
     */
    Main = "main",
    /**
     * .nip.io
     */
    MainPlusSubDomains = "main+subdomains",
    /**
     * feat.nip.io
     */
    Current = "current",
    /**
     * https://feat.nip.io
     */
    CurrentPlusProtocol = "current+protocol",
    /**
     * .feat.nip.io
     */
    CurrentPlusSubDomains = "current+subdomains",
}

enum ETechnicalDefinitionDurationUnit {
    Seconds = "s",
    Minutes = "m",
    Hours = "h",
    Days = "d",
    Months = "mo",
    Years = "y",
}

export {
    type IServiceTemplateTechnicalDefinitionTranslatable,
    type IServiceTemplateTechnicalDefinitionTranslation,
    type IServiceTemplateTechnicalDefinition,
    ETechnicalDefinitionType,
    ETechnicalDefinitionHostType,
    ETechnicalDefinitionDurationUnit,
};
