import type { IUser } from "./user.js";

enum EUserSessionStatus {
    Pending = "pending",
    Active = "active",
    Revoked = "revoked",
}

interface IUserSession {
    user: IUser;
    magicLinkToken: string;
    magicLinkTokenValidUntil: Date;
    magicLinkRequestEmail: string;
    magicLinkRequestIp: string;
    magicLinkRequestedAt: Date;
    status: EUserSessionStatus;
    jwtValidUntil?: Date;
}

export { type IUserSession, EUserSessionStatus };
