import { z } from "zod";

import type { InferContractGuard } from "@devowl-wp/api";
import {
    ContractResponse,
    EHttpStatusCodeClientError,
    EHttpStatusCodeSuccess,
    createContractGuard,
} from "@devowl-wp/api";

import type { IUserSession } from "../entity/user/session.js";

const createContractGuardJwt = () =>
    createContractGuard({
        z,
        name: "jwt",
        headers: () =>
            z.object({
                authorization: z.string().startsWith("Bearer ").optional().meta({
                    description: "The JWT token to access the API, in bearer format",
                    isSecuritySchema: true,
                }),
            }),
        response: () => ({
            [EHttpStatusCodeSuccess.OK]: new ContractResponse<{
                userSession: IUserSession;
            }>({
                description: "The JWT token is valid",
            }),
            [EHttpStatusCodeClientError.Unauthorized]: new ContractResponse({
                description: "The JWT token is invalid",
            }),
            [EHttpStatusCodeClientError.Forbidden]: new ContractResponse({
                description: "The JWT token is valid, but the user is not authorized to access the API",
            }),
        }),
    });

type JwtGuard = InferContractGuard<typeof createContractGuardJwt>;

export { createContractGuardJwt, type JwtGuard };
